/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.cos;

import de.intarsys.pdf.cos.COSDocument;
import de.intarsys.pdf.cos.COSDocumentElement;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectKey;
import de.intarsys.pdf.cos.COSRuntimeException;
import de.intarsys.pdf.cos.COSSwapException;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.cos.ICOSContainer;
import de.intarsys.pdf.cos.ICOSObjectVisitor;
import de.intarsys.pdf.parser.COSLoadException;
import de.intarsys.pdf.st.STDocument;
import de.intarsys.tools.logging.LogTools;
import de.intarsys.tools.resourcetracker.ResourceTracker;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.logging.Level;

public class COSIndirectObject
extends COSDocumentElement
implements ICOSContainer {
    private static ResourceTracker tracker = new ResourceTracker(){

        protected void basicDispose(Object object) {
            LogTools.getLogger(COSIndirectObject.class).log(Level.WARNING, "disposed " + object);
        }
    };
    private static final byte F_DIRTY = 1;
    private static final byte F_FIXED = 2;
    private byte flags = 0;
    private Object object;
    private COSDocument doc;
    private STDocument stDoc;
    private int objectNumber = -1;
    private short generationNumber = (short)-1;
    private short referenceCount = 0;

    public static COSIndirectObject create(COSObject cOSObject) {
        COSIndirectObject cOSIndirectObject = new COSIndirectObject();
        cOSIndirectObject.setDirty(true);
        cOSObject.getContainer().register(cOSIndirectObject);
        cOSIndirectObject.object = cOSObject;
        cOSObject.basicSetContainer(cOSIndirectObject);
        return cOSIndirectObject;
    }

    public static COSIndirectObject create(STDocument sTDocument, COSObjectKey cOSObjectKey) {
        COSIndirectObject cOSIndirectObject = new COSIndirectObject();
        cOSIndirectObject.setKey(cOSObjectKey);
        cOSIndirectObject.registerWith(sTDocument);
        return cOSIndirectObject;
    }

    public static COSIndirectObject create(STDocument sTDocument, int n, int n2) {
        COSIndirectObject cOSIndirectObject = new COSIndirectObject();
        cOSIndirectObject.setKey(n, n2);
        cOSIndirectObject.registerWith(sTDocument);
        return cOSIndirectObject;
    }

    protected COSIndirectObject() {
    }

    protected COSIndirectObject(COSIndirectObject cOSIndirectObject) {
        this.flags = cOSIndirectObject.flags;
        this.doc = cOSIndirectObject.doc;
        this.objectNumber = cOSIndirectObject.objectNumber;
        this.generationNumber = cOSIndirectObject.generationNumber;
        this.stDoc = cOSIndirectObject.stDoc;
        this.referenceCount = cOSIndirectObject.referenceCount;
    }

    @Override
    public Object accept(ICOSObjectVisitor iCOSObjectVisitor) throws COSVisitorException {
        return iCOSObjectVisitor.visitFromIndirectObject(this);
    }

    @Override
    protected ICOSContainer addContainer(ICOSContainer iCOSContainer) {
        return this.associate(iCOSContainer, null);
    }

    @Override
    public ICOSContainer associate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        iCOSContainer.register(this);
        this.referenceCount = (short)(this.referenceCount + 1);
        return this;
    }

    protected COSObject basicSwapIn() {
        try {
            return this.stGetDoc().load(this);
        }
        catch (IOException iOException) {
            throw new COSSwapException("io error reading object " + this.getKey(), iOException);
        }
        catch (COSLoadException cOSLoadException) {
            throw new COSSwapException("parse error reading object " + this.getKey(), cOSLoadException);
        }
    }

    @Override
    public COSDocumentElement containable() {
        return this;
    }

    @Override
    public COSDocumentElement containable(COSObject cOSObject) {
        return this;
    }

    @Override
    protected COSObject copyDeep(Map map) {
        COSObject cOSObject = (COSObject)map.get(this);
        if (cOSObject == null) {
            cOSObject = this.dereference().copyDeep(map);
        }
        return cOSObject;
    }

    @Override
    protected COSDocumentElement copyShallowNested() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COSObject dereference() {
        COSObject cOSObject;
        Object object = this;
        synchronized (object) {
            cOSObject = this.getObject();
        }
        if (cOSObject == null) {
            object = this;
            if (this.stGetDoc() != null) {
                object = this.stGetDoc().getAccessLock();
            }
            COSIndirectObject cOSIndirectObject = object;
            synchronized (cOSIndirectObject) {
                cOSObject = this.getObject();
                if (cOSObject == null) {
                    try {
                        cOSObject = this.swapIn();
                        COSIndirectObject cOSIndirectObject2 = this;
                        synchronized (cOSIndirectObject2) {
                            this.setObject(cOSObject);
                        }
                    }
                    catch (COSRuntimeException cOSRuntimeException) {
                        this.setObject(COSNull.create());
                        if (this.doc != null) {
                            this.doc.handleException(cOSRuntimeException);
                        }
                        throw cOSRuntimeException;
                    }
                }
            }
        }
        return cOSObject;
    }

    @Override
    public ICOSContainer disassociate(ICOSContainer iCOSContainer, COSObject cOSObject) {
        this.referenceCount = (short)(this.referenceCount - 1);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exists() {
        COSObject cOSObject;
        Object object = this;
        synchronized (object) {
            cOSObject = this.getObject();
        }
        if (cOSObject != null) {
            return true;
        }
        object = this;
        if (this.stGetDoc() != null) {
            object = this.stGetDoc().getAccessLock();
        }
        COSIndirectObject cOSIndirectObject = object;
        synchronized (cOSIndirectObject) {
            block9: {
                cOSObject = this.getObject();
                if (cOSObject == null) break block9;
                return true;
            }
            return this.basicSwapIn() != null;
        }
    }

    @Override
    public COSDocument getDoc() {
        return this.doc;
    }

    public int getGenerationNumber() {
        return this.generationNumber & 0xFFFF;
    }

    public COSObjectKey getKey() {
        COSObjectKey cOSObjectKey = null;
        if (this.objectNumber == -1) {
            if (this.stGetDoc() != null) {
                cOSObjectKey = this.stGetDoc().createObjectKey();
                this.objectNumber = cOSObjectKey.getObjectNumber();
                this.generationNumber = (short)cOSObjectKey.getGenerationNumber();
            }
        } else {
            cOSObjectKey = new COSObjectKey(this.objectNumber, this.generationNumber);
        }
        return cOSObjectKey;
    }

    protected COSObject getObject() {
        if (this.object == null) {
            return null;
        }
        if (this.object instanceof Reference) {
            return (COSObject)((Reference)this.object).get();
        }
        return (COSObject)this.object;
    }

    public int getObjectNumber() {
        if (this.objectNumber == -1 && this.stGetDoc() != null) {
            COSObjectKey cOSObjectKey = this.stGetDoc().createObjectKey();
            this.objectNumber = cOSObjectKey.getObjectNumber();
            this.generationNumber = (short)cOSObjectKey.getGenerationNumber();
        }
        return this.objectNumber;
    }

    @Override
    public void harden(COSObject cOSObject) {
        if (this.object instanceof Reference) {
            this.flags = (byte)(this.flags | 2);
            this.object = ((Reference)this.object).get();
        }
    }

    public boolean isDirty() {
        return (this.flags & 1) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInitialState() {
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            return this.object == null;
        }
    }

    @Override
    public boolean isReference() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isSwapped() {
        COSIndirectObject cOSIndirectObject = this;
        synchronized (cOSIndirectObject) {
            return this.getObject() == null;
        }
    }

    @Override
    public int referenceCount() {
        return this.referenceCount;
    }

    @Override
    public COSIndirectObject referenceIndirect(COSObject cOSObject) {
        return this;
    }

    @Override
    public void register(COSDocumentElement cOSDocumentElement) {
        if (this.doc != null) {
            cOSDocumentElement.registerWith(this.doc);
        }
    }

    @Override
    protected void registerWith(COSDocument cOSDocument) {
        if (this.doc == null) {
            this.doc = cOSDocument;
            this.registerWith(cOSDocument.stGetDoc());
            COSObject cOSObject = this.getObject();
            if (cOSObject != null) {
                cOSObject.registerWith(this.doc);
            }
        } else if (this.doc != cOSDocument) {
            throw new IllegalStateException("You can not merge objects from different documents");
        }
    }

    public void registerWith(STDocument sTDocument) {
        this.stDoc = sTDocument;
        sTDocument.addObjectReference(this);
        if ((this.flags & 1) != 0) {
            sTDocument.addChangedReference(this);
        }
    }

    @Override
    protected ICOSContainer removeContainer(ICOSContainer iCOSContainer) {
        return this.disassociate(iCOSContainer, null);
    }

    @Override
    public ICOSContainer restoreStateContainer(ICOSContainer iCOSContainer) {
        COSIndirectObject cOSIndirectObject = (COSIndirectObject)iCOSContainer;
        this.flags = cOSIndirectObject.flags;
        this.referenceCount = cOSIndirectObject.referenceCount;
        return this;
    }

    @Override
    public ICOSContainer saveStateContainer() {
        return new COSIndirectObject(this);
    }

    public void setDirty(boolean bl) {
        if (bl) {
            if ((this.flags & 1) == 0) {
                this.harden(null);
            }
            if (this.stGetDoc() != null) {
                this.stGetDoc().addChangedReference(this);
            }
            this.flags = (byte)(this.flags | 1);
        } else {
            if ((this.flags & 1) != 0) {
                this.soften(null);
            }
            this.flags = (byte)(this.flags ^ 1);
        }
    }

    public void setKey(COSObjectKey cOSObjectKey) {
        if (cOSObjectKey == null) {
            this.objectNumber = -1;
            this.generationNumber = (short)-1;
        } else {
            this.objectNumber = cOSObjectKey.getObjectNumber();
            this.generationNumber = (short)cOSObjectKey.getGenerationNumber();
        }
    }

    public void setKey(int n, int n2) {
        this.objectNumber = n;
        this.generationNumber = (short)n2;
    }

    protected void setObject(COSObject cOSObject) {
        this.object = cOSObject.mayBeSwapped() ? new SoftReference<COSObject>(cOSObject) : cOSObject;
        cOSObject.basicSetContainer(this);
        if (this.doc != null) {
            cOSObject.registerWith(this.doc);
        }
    }

    @Override
    public void soften(COSObject cOSObject) {
        if ((this.flags & 2) != 0 && ((COSObject)this.object).mayBeSwapped()) {
            this.flags = (byte)(this.flags ^ 2);
            this.object = new SoftReference<Object>(this.object);
        }
    }

    public final STDocument stGetDoc() {
        return this.stDoc;
    }

    protected COSObject swapIn() {
        COSObject cOSObject = this.basicSwapIn();
        if (cOSObject == null) {
            cOSObject = COSNull.create();
        }
        return cOSObject;
    }

    public String toString() {
        return this.getObjectNumber() + " " + this.getGenerationNumber() + " R" + "->";
    }

    @Override
    public void willChange(COSObject cOSObject) {
        if (this.getDoc() != null) {
            this.getDoc().willChange(cOSObject);
        }
        this.setDirty(true);
    }
}

