/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.filter;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASCII85InputStream
extends FilterInputStream {
    private static final long CONST_85 = 85L;
    private static final long HIGH_BYTE = 255L;
    private byte[] ascii = new byte[5];
    private byte[] b = new byte[4];
    private boolean eof = false;
    private int index = 0;
    private int n = 0;

    public ASCII85InputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public final int read() throws IOException {
        if (this.index >= this.n) {
            byte by;
            byte by2;
            if (this.eof) {
                return -1;
            }
            this.index = 0;
            do {
                if ((by = (byte)this.in.read()) != -1) continue;
                this.eof = true;
                return -1;
            } while ((by2 = (byte)by) == 10 || by2 == 13 || by2 == 32);
            if (by2 == 126 | by2 == 120) {
                this.eof = true;
                this.ascii = null;
                this.b = null;
                this.n = 0;
                return -1;
            }
            if (by2 == 122) {
                this.b[0] = 0;
                this.b[1] = 0;
                this.b[2] = 0;
                this.b[3] = 0;
                this.n = 4;
            } else {
                this.ascii[0] = by2;
                int n = 1;
                while (n < 5) {
                    do {
                        if ((by = (byte)this.in.read()) != -1) continue;
                        this.eof = true;
                        return -1;
                    } while ((by2 = (byte)by) == 10 || by2 == 13 || by2 == 32);
                    this.ascii[n] = by2;
                    if (by2 == 126 | by2 == 120) break;
                    ++n;
                }
                this.n = n - 1;
                if (this.n == 0) {
                    this.eof = true;
                    this.ascii = null;
                    this.b = null;
                    return -1;
                }
                if (n < 5) {
                    ++n;
                    while (n < 5) {
                        this.ascii[n] = 33;
                        ++n;
                    }
                    this.eof = true;
                }
                long l = 0L;
                n = 0;
                while (n < 5) {
                    by2 = (byte)(this.ascii[n] - 33);
                    if (by2 < 0 || by2 > 93) {
                        this.n = 0;
                        this.eof = true;
                        this.ascii = null;
                        this.b = null;
                        throw new IOException("Invalid data in Ascii85 stream");
                    }
                    l = l * 85L + (long)by2;
                    ++n;
                }
                n = 3;
                while (n >= 0) {
                    this.b[n] = (byte)(l & 0xFFL);
                    l >>>= 8;
                    --n;
                }
            }
        }
        return this.b[this.index++] & 0xFF;
    }

    @Override
    public final int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.eof && this.index >= this.n) {
            return -1;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.index < this.n) {
                byArray[n3 + n] = this.b[this.index++];
            } else {
                int n4 = this.read();
                if (n4 == -1) {
                    return n3;
                }
                byArray[n3 + n] = (byte)n4;
            }
            ++n3;
        }
        return n2;
    }

    @Override
    public int available() throws IOException {
        throw new IOException("method not supported");
    }

    @Override
    public void close() throws IOException {
        this.ascii = null;
        this.eof = true;
        this.b = null;
        super.close();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("method not supported");
    }

    @Override
    public long skip(long l) throws IOException {
        throw new IOException("method not supported");
    }
}

