/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.CIDSystemInfo;
import de.intarsys.pdf.font.CIDWidthMap;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontDescriptor;
import de.intarsys.pdf.font.PDFontStyle;
import de.intarsys.pdf.font.PDGlyphs;
import java.io.ByteArrayInputStream;

public abstract class CIDFont
extends PDFont {
    public static final COSName DK_CIDSystemInfo = COSName.constant("CIDSystemInfo");
    public static final COSName DK_DW = COSName.constant("DW");
    public static final COSName DK_W = COSName.constant("W");
    public static final COSName DK_DW2 = COSName.constant("DW2");
    public static final COSName DK_W2 = COSName.constant("W2");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private CIDWidthMap map = null;

    protected CIDFont(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    protected PDFontDescriptor createBuiltinFontDescriptor() {
        return null;
    }

    public CIDSystemInfo getCIDSystemInfo() {
        return (CIDSystemInfo)CIDSystemInfo.META.createFromCos(this.cosGetField(DK_CIDSystemInfo));
    }

    public CIDWidthMap getCIDWidthMap() {
        if (this.map == null) {
            this.map = (CIDWidthMap)CIDWidthMap.META.createFromCos(this.cosGetField(DK_W));
        }
        return this.map;
    }

    public int getDefaultGlyphWidth() {
        return this.getFieldInt(DK_DW, 1000);
    }

    @Override
    public PDFontStyle getFontStyle() {
        return PDFontStyle.REGULAR;
    }

    public abstract int getGlyphIndex(int var1);

    @Override
    public PDGlyphs getGlyphsEncoded(int n) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    public int getGlyphWidthCID(int n) {
        CIDWidthMap cIDWidthMap = this.getCIDWidthMap();
        if (cIDWidthMap == null) {
            return this.getFieldInt(DK_DW, 1000);
        }
        int n2 = this.getCIDWidthMap().getWidth(n);
        if (n2 == -1) {
            return this.getFieldInt(DK_DW, 1000);
        }
        return n2;
    }

    @Override
    public int getGlyphWidthEncoded(int n) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    @Override
    public PDGlyphs getNextGlyphsEncoded(ByteArrayInputStream byteArrayInputStream) {
        throw new UnsupportedOperationException("CIDFont can not be used directly");
    }

    public void setCIDSystemInfo(CIDSystemInfo cIDSystemInfo) {
        this.setFieldObject(DK_CIDSystemInfo, cIDSystemInfo);
    }

    public void setCIDWidthMap(CIDWidthMap cIDWidthMap) {
        this.setFieldObject(DK_W, cIDWidthMap);
    }

    public void setDefaultGlyphWidth(int n) {
        this.setFieldInt(DK_DW, n);
    }

    public static class MetaClass
    extends PDFont.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }
    }
}

