/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.font;

import de.intarsys.pdf.cds.CDSRectangle;
import de.intarsys.pdf.content.CSContent;
import de.intarsys.pdf.content.CSError;
import de.intarsys.pdf.content.CSException;
import de.intarsys.pdf.content.CSInterpreter;
import de.intarsys.pdf.content.CSOperation;
import de.intarsys.pdf.content.CSWarning;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSInteger;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSObjectWalkerDeep;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.cos.COSTools;
import de.intarsys.pdf.cos.COSVisitorException;
import de.intarsys.pdf.encoding.Encoding;
import de.intarsys.pdf.encoding.WinAnsiEncoding;
import de.intarsys.pdf.font.CIDFont;
import de.intarsys.pdf.font.CIDFontType2;
import de.intarsys.pdf.font.CIDSystemInfo;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.font.PDFontTrueType;
import de.intarsys.pdf.font.PDFontType0;
import de.intarsys.pdf.font.PDFontType1;
import de.intarsys.pdf.font.outlet.FontFactoryException;
import de.intarsys.pdf.font.outlet.FontOutlet;
import de.intarsys.pdf.font.outlet.FontQuery;
import de.intarsys.pdf.font.outlet.IFontFactory;
import de.intarsys.pdf.pd.PDDocument;
import de.intarsys.pdf.pd.PDForm;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPage;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDResources;
import de.intarsys.tools.attribute.Attribute;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PDFontTools {
    private static final Attribute ATTR_CIDFONT = new Attribute("cidfont");
    private static final Attribute ATTR_CREATEDFONTS = new Attribute("createdfonts");
    private static final Attribute ATTR_TYPE0FONT = new Attribute("type0font");

    protected static void collectFonts(Set set, CSContent cSContent, PDResources pDResources, final boolean bl) {
        final HashSet hashSet = new HashSet();
        CSInterpreter cSInterpreter = new CSInterpreter(new HashMap()){
            private COSName fontName;
            private int renderingMode;
            {
                super(map);
                this.renderingMode = 0;
            }

            @Override
            protected void handleError(CSError cSError) throws CSException {
            }

            protected void handleText() {
                if (this.renderingMode != 3 || !bl) {
                    hashSet.add(this.fontName);
                }
            }

            @Override
            protected void handleWarning(CSWarning cSWarning) throws CSException {
            }

            @Override
            protected void notSupported(CSOperation cSOperation) throws CSException {
            }

            @Override
            protected void render_DoubleQuote(CSOperation cSOperation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Quote(CSOperation cSOperation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Tf(CSOperation cSOperation) throws CSException {
                if (cSOperation.operandSize() == 2) {
                    this.fontName = cSOperation.getOperand(0).asName();
                }
            }

            @Override
            protected void render_Tj(CSOperation cSOperation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_TJ(CSOperation cSOperation) throws CSException {
                this.handleText();
            }

            @Override
            protected void render_Tr(CSOperation cSOperation) throws CSException {
                COSInteger cOSInteger = (COSInteger)cSOperation.getOperand(0);
                this.renderingMode = cOSInteger.intValue();
            }
        };
        cSInterpreter.process(cSContent, pDResources);
        for (COSName cOSName : hashSet) {
            set.add(pDResources.getFontResource(cOSName));
        }
    }

    public static PDFont createBuiltinFont(String string) {
        PDFontType1 pDFontType1 = PDFontType1.createNew(string);
        if (pDFontType1.getFontDescriptor().isNonsymbolic()) {
            pDFontType1.setEncoding(WinAnsiEncoding.UNIQUE);
        }
        return pDFontType1;
    }

    protected static CIDFont createCIDFont(PDFont pDFont) {
        if (pDFont instanceof PDFontTrueType) {
            CIDFontType2 cIDFontType2 = (CIDFontType2)CIDFontType2.META.createNew();
            cIDFontType2.cosSetField(PDFont.DK_BaseFont, pDFont.getBaseFont().copyShallow());
            CIDSystemInfo cIDSystemInfo = (CIDSystemInfo)CIDSystemInfo.META.createNew();
            int n = pDFont.getMissingWidth();
            if (n == 0) {
                n = 1000;
            }
            cIDFontType2.setDefaultGlyphWidth(n);
            cIDFontType2.setCIDSystemInfo(cIDSystemInfo);
            cIDFontType2.setFontDescriptor(pDFont.getFontDescriptor());
            return cIDFontType2;
        }
        boolean cfr_ignored_0 = pDFont instanceof PDFontType1;
        return null;
    }

    protected static PDFont createType0Font(PDFont pDFont) {
        PDFont pDFont2;
        if (pDFont instanceof PDFontType0) {
            pDFont2 = pDFont;
        } else {
            CIDFont cIDFont = PDFontTools.getCIDFont(pDFont);
            if (cIDFont == null) {
                pDFont2 = pDFont;
            } else {
                PDFontType0 pDFontType0 = (PDFontType0)PDFontType0.META.createNew();
                pDFontType0.cosSetField(PDFont.DK_BaseFont, pDFont.getBaseFont().copyShallow());
                pDFontType0.setDescendantFont(cIDFont);
                pDFont2 = pDFontType0;
            }
        }
        return pDFont2;
    }

    protected static CIDFont getCIDFont(PDFont pDFont) {
        CIDFont cIDFont = (CIDFont)pDFont.getAttribute(ATTR_CIDFONT);
        if (cIDFont == null) {
            cIDFont = PDFontTools.createCIDFont(pDFont);
            pDFont.setAttribute(ATTR_CIDFONT, cIDFont);
        }
        return cIDFont;
    }

    public static PDFont getFont(PDDocument pDDocument, PDResources pDResources, COSName cOSName) {
        PDFont pDFont;
        if (pDResources != null && (pDFont = pDResources.getFontResource(cOSName)) != null) {
            return pDFont;
        }
        if (cOSName != null) {
            return PDFontTools.lookupFont(pDDocument, cOSName.stringValue());
        }
        return null;
    }

    public static PDFont getFont(PDResources pDResources, COSName cOSName) {
        return PDFontTools.getFont(pDResources.getDoc(), pDResources, cOSName);
    }

    public static List getFonts(PDDocument pDDocument) {
        final ArrayList arrayList = new ArrayList();
        try {
            COSDictionary cOSDictionary = pDDocument.cosGetDoc().stGetDoc().cosGetTrailer();
            COSObjectWalkerDeep cOSObjectWalkerDeep = new COSObjectWalkerDeep(){

                @Override
                protected void handleException(RuntimeException runtimeException) throws COSVisitorException {
                }

                @Override
                public Object visitFromDictionary(COSDictionary cOSDictionary) throws COSVisitorException {
                    try {
                        PDFont pDFont = (PDFont)PDFont.META.createFromCos(cOSDictionary);
                        if (pDFont != null) {
                            arrayList.add(pDFont);
                            return null;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return super.visitFromDictionary(cOSDictionary);
                }
            };
            cOSDictionary.accept(cOSObjectWalkerDeep);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList;
    }

    public static float getGlyphHeight(PDFont pDFont) {
        CDSRectangle cDSRectangle = pDFont.getFontDescriptor().getFontBB();
        float f = cDSRectangle.getUpperRightY() - cDSRectangle.getLowerLeftY();
        return f /= 1000.0f;
    }

    public static float getGlyphHeightScaled(PDFont pDFont, float f) {
        CDSRectangle cDSRectangle = pDFont.getFontDescriptor().getFontBB();
        float f2 = cDSRectangle.getUpperRightY() - cDSRectangle.getLowerLeftY();
        f2 = f * f2 / 1000.0f;
        return f2;
    }

    public static int getGlyphWidthEncoded(PDFont pDFont, byte[] byArray, int n, int n2) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        Encoding encoding = pDFont.getEncoding();
        int n3 = 0;
        try {
            int n4 = encoding.getNextEncoded(byteArrayInputStream);
            while (n4 != -1) {
                n3 += pDFont.getGlyphWidthEncoded(n4);
                n4 = encoding.getNextEncoded(byteArrayInputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return n3;
    }

    public static float getGlyphWidthEncodedScaled(PDFont pDFont, float f, byte[] byArray, int n, int n2) {
        float f2 = PDFontTools.getGlyphWidthEncoded(pDFont, byArray, n, n2);
        return f * f2 / 1000.0f;
    }

    public static PDFont getType0Font(PDFont pDFont) {
        PDFont pDFont2 = (PDFont)pDFont.getAttribute(ATTR_TYPE0FONT);
        if (pDFont2 == null) {
            pDFont2 = PDFontTools.createType0Font(pDFont);
            pDFont.setAttribute(ATTR_TYPE0FONT, pDFont2);
        }
        return pDFont2;
    }

    public static List getUsedFonts(PDDocument pDDocument, boolean bl) {
        Object object;
        HashSet hashSet = new HashSet();
        for (PDPage pDPage = pDDocument.getPageTree().getFirstPage(); pDPage != null; pDPage = pDPage.getNextPage()) {
            object = pDPage.getContentStream();
            if (object == null) continue;
            PDFontTools.collectFonts(hashSet, (CSContent)object, pDPage.getResources(), bl);
        }
        object = pDDocument.cosGetDoc().objects();
        while (object.hasNext()) {
            try {
                Object object2;
                COSObject cOSObject = (COSObject)object.next();
                COSDictionary cOSDictionary = COSTools.toDictionary(cOSObject);
                if (cOSDictionary == null) continue;
                if (cOSDictionary.get(PDObject.DK_Subtype).equals(PDForm.CN_Subtype_Form) && (object2 = (PDForm)PDForm.META.createFromCos(cOSObject)) != null) {
                    PDFontTools.collectFonts(hashSet, ((PDForm)object2).getContentStream(), ((PDForm)object2).getResources(), bl);
                }
                if (!cOSDictionary.get(PDPattern.DK_PatternType).equals(COSInteger.create(1))) continue;
                object2 = CSContent.createFromCos((COSStream)cOSObject);
                COSDictionary cOSDictionary2 = cOSDictionary.get(PDForm.DK_Resources).asDictionary();
                PDResources pDResources = (PDResources)PDResources.META.createFromCos(cOSDictionary2);
                PDFontTools.collectFonts(hashSet, (CSContent)object2, pDResources, bl);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return new ArrayList(hashSet);
    }

    protected static PDFont lookupFont(PDDocument pDDocument, String string) {
        PDFont pDFont = null;
        IFontFactory iFontFactory = FontOutlet.get().lookupFontFactory(pDDocument);
        FontQuery fontQuery = new FontQuery(string);
        try {
            pDFont = iFontFactory.getFont(fontQuery);
        }
        catch (FontFactoryException fontFactoryException) {
            // empty catch block
        }
        if (pDFont == null) {
            pDFont = PDFontTools.createBuiltinFont(string);
            iFontFactory.registerFont(pDFont);
        }
        return pDFont;
    }
}

