/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDOutline;
import de.intarsys.pdf.pd.PDOutlineItem;
import java.util.ArrayList;
import java.util.List;

public abstract class PDOutlineNode
extends PDObject {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    public static final COSName DK_First = COSName.constant("First");
    public static final COSName DK_Last = COSName.constant("Last");
    public static final COSName DK_Count = COSName.constant("Count");

    protected PDOutlineNode(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addItem(PDOutlineItem pDOutlineItem) {
        PDOutlineItem pDOutlineItem2;
        this.changeCount(1);
        PDOutlineItem pDOutlineItem3 = this.getFirst();
        if (pDOutlineItem3 == null) {
            this.setFirst(pDOutlineItem);
        }
        if ((pDOutlineItem2 = this.getLast()) != null) {
            pDOutlineItem2.setNext(pDOutlineItem);
            pDOutlineItem.setPrev(pDOutlineItem2);
        }
        this.setLast(pDOutlineItem);
        pDOutlineItem.setParent(this);
    }

    protected void changeCount(int n) {
        int n2 = this.getCount();
        n2 = n2 < 0 ? (n2 -= n) : (n2 += n);
        this.setCount(n2);
        if (this.getParent() != null) {
            this.getParent().changeCount(n);
        }
    }

    public boolean collapse() {
        if (this.getCount() <= 0) {
            return false;
        }
        this.setCount(-this.getCount());
        if (this.getParent() != null) {
            this.getParent().changeCount(this.getCount());
        }
        return true;
    }

    public boolean expand() {
        if (this.getCount() >= 0) {
            return false;
        }
        this.setCount(-this.getCount());
        if (this.getParent() != null) {
            this.getParent().changeCount(this.getCount());
        }
        return true;
    }

    public List getChildren() {
        ArrayList<PDOutlineItem> arrayList = new ArrayList<PDOutlineItem>();
        PDOutlineItem pDOutlineItem = this.getFirst();
        while (pDOutlineItem != null) {
            arrayList.add(pDOutlineItem);
            pDOutlineItem = pDOutlineItem.getNext();
        }
        return arrayList;
    }

    public int getCount() {
        return this.getFieldInt(DK_Count, 0);
    }

    public PDOutlineItem getFirst() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_First));
    }

    public PDOutlineItem getLast() {
        return (PDOutlineItem)PDOutlineItem.META.createFromCos(this.cosGetField(DK_Last));
    }

    protected PDOutlineNode getParent() {
        return null;
    }

    public boolean isOutline() {
        return false;
    }

    public boolean removeItem(PDOutlineItem pDOutlineItem) {
        if (pDOutlineItem.getParent() != this) {
            return false;
        }
        this.changeCount(-1);
        if (pDOutlineItem.getPrev() != null) {
            pDOutlineItem.getPrev().setNext(pDOutlineItem.getNext());
        }
        if (pDOutlineItem.getNext() != null) {
            pDOutlineItem.getNext().setPrev(pDOutlineItem.getPrev());
        }
        if (this.getFirst() == pDOutlineItem) {
            this.setFirst(pDOutlineItem.getNext());
        }
        if (this.getLast() == pDOutlineItem) {
            this.setLast(pDOutlineItem.getPrev());
        }
        pDOutlineItem.setParent(null);
        return true;
    }

    protected void setCount(int n) {
        this.setFieldInt(DK_Count, n);
    }

    protected void setFirst(PDOutlineItem pDOutlineItem) {
        this.setFieldObject(DK_First, pDOutlineItem);
    }

    protected void setLast(PDOutlineItem pDOutlineItem) {
        this.setFieldObject(DK_Last, pDOutlineItem);
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject.MetaClass doDetermineClass(COSObject cOSObject) {
            if (cOSObject instanceof COSDictionary) {
                COSDictionary cOSDictionary = (COSDictionary)cOSObject;
                COSName cOSName = cOSDictionary.get(PDObject.DK_Type).asName();
                if (PDOutline.CN_Type_Outlines.equals(cOSName)) {
                    return PDOutline.META;
                }
                if (cOSDictionary.get(PDOutlineItem.DK_Parent).isNull() && cOSDictionary.get(PDOutlineItem.DK_Title).isNull()) {
                    return PDOutline.META;
                }
                return PDOutlineItem.META;
            }
            return super.doDetermineClass(cOSObject);
        }

        @Override
        public Class getRootClass() {
            return PDOutlineNode.class;
        }
    }
}

