/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSNull;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.font.PDFont;
import de.intarsys.pdf.pd.PDColorSpace;
import de.intarsys.pdf.pd.PDExtGState;
import de.intarsys.pdf.pd.PDObject;
import de.intarsys.pdf.pd.PDPattern;
import de.intarsys.pdf.pd.PDShading;
import de.intarsys.pdf.pd.PDXObject;
import java.util.HashMap;
import java.util.Map;

public class PDResources
extends PDObject {
    public static final COSName CN_RT_ColorSpace = COSName.constant("ColorSpace");
    public static final COSName CN_RT_Encoding = COSName.constant("Encoding");
    public static final COSName CN_RT_ExtGState = COSName.constant("ExtGState");
    public static final COSName CN_RT_Font = COSName.constant("Font");
    public static final COSName CN_RT_Pattern = COSName.constant("Pattern");
    public static final COSName CN_RT_ProcSet = COSName.constant("ProcSet");
    public static final COSName CN_RT_Properties = COSName.constant("Properties");
    public static final COSName CN_RT_Shading = COSName.constant("Shading");
    public static final COSName CN_RT_XObject = COSName.constant("XObject");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private static Map resourceNamePrefixes = new HashMap();
    private Map currentCounters = new HashMap();
    private Map cachedResources = new HashMap();

    static {
        resourceNamePrefixes.put(CN_RT_ColorSpace, "CS");
        resourceNamePrefixes.put(CN_RT_ExtGState, "GS");
        resourceNamePrefixes.put(CN_RT_Font, "F");
        resourceNamePrefixes.put(CN_RT_Pattern, "P");
        resourceNamePrefixes.put(CN_RT_Shading, "S");
        resourceNamePrefixes.put(CN_RT_XObject, "X");
    }

    protected PDResources(COSObject cOSObject) {
        super(cOSObject);
    }

    public void addColorSpaceResource(COSName cOSName, PDColorSpace pDColorSpace) {
        this.addResource(CN_RT_ColorSpace, cOSName, pDColorSpace);
    }

    public void addExtGStateResource(COSName cOSName, PDExtGState pDExtGState) {
        this.addResource(CN_RT_ExtGState, cOSName, pDExtGState);
    }

    public void addFontResource(COSName cOSName, PDFont pDFont) {
        this.addResource(CN_RT_Font, cOSName, pDFont);
    }

    public void addPatternResource(COSName cOSName, PDPattern pDPattern) {
        this.addResource(CN_RT_Pattern, cOSName, pDPattern);
    }

    public void addResource(COSName cOSName, COSName cOSName2, PDObject pDObject) {
        COSDictionary cOSDictionary = this.cosGetResources(cOSName);
        if (cOSDictionary == null) {
            cOSDictionary = this.cosInitResources(cOSName);
        }
        cOSDictionary.put(cOSName2, pDObject.cosGetObject());
    }

    public void addShadingResource(COSName cOSName, PDShading pDShading) {
        this.addResource(CN_RT_Shading, cOSName, pDShading);
    }

    public void addXObjectResource(COSName cOSName, PDXObject pDXObject) {
        this.addResource(CN_RT_XObject, cOSName, pDXObject);
    }

    public void cosAddResource(COSName cOSName, COSName cOSName2, COSObject cOSObject) {
        COSDictionary cOSDictionary = this.cosGetResources(cOSName);
        if (cOSDictionary == null) {
            cOSDictionary = this.cosInitResources(cOSName);
        }
        cOSDictionary.put(cOSName2, cOSObject);
    }

    public COSName cosCreateResource(COSName cOSName, COSObject cOSObject) {
        COSName cOSName2;
        COSDictionary cOSDictionary = this.cosGetResources(cOSName);
        if (cOSDictionary == null) {
            cOSDictionary = this.cosInitResources(cOSName);
        }
        if ((cOSName2 = cOSDictionary.keyOf(cOSObject).asName()) == null) {
            cOSName2 = this.createResourceName(cOSName);
            cOSDictionary.put(cOSName2, cOSObject);
        }
        return cOSName2;
    }

    public COSObject cosGetResource(COSName cOSName, COSName cOSName2) {
        COSDictionary cOSDictionary = this.cosGetResources(cOSName);
        if (cOSDictionary == null) {
            return COSNull.NULL;
        }
        return cOSDictionary.get(cOSName2);
    }

    public COSDictionary cosGetResources(COSName cOSName) {
        COSDictionary cOSDictionary = (COSDictionary)this.cachedResources.get(cOSName);
        if (cOSDictionary == null) {
            cOSDictionary = this.cosGetField(cOSName).asDictionary();
            this.cachedResources.put(cOSName, cOSDictionary);
        }
        return cOSDictionary;
    }

    public COSDictionary cosInitResources(COSName cOSName) {
        COSDictionary cOSDictionary = COSDictionary.create();
        this.cosSetField(cOSName, cOSDictionary);
        return cOSDictionary;
    }

    public void cosSetResources(COSName cOSName, COSDictionary cOSDictionary) {
        this.cosSetField(cOSName, cOSDictionary);
    }

    public COSName createColorSpaceResource(PDColorSpace pDColorSpace) {
        return this.createResource(CN_RT_ColorSpace, pDColorSpace);
    }

    public COSName createExtGStateResource(PDExtGState pDExtGState) {
        return this.createResource(CN_RT_ExtGState, pDExtGState);
    }

    public COSName createFontResource(PDFont pDFont) {
        return this.createResource(CN_RT_Font, pDFont);
    }

    public COSName createResource(COSName cOSName, PDObject pDObject) {
        return this.cosCreateResource(cOSName, pDObject.cosGetObject());
    }

    protected COSName createResourceName(COSName cOSName) {
        COSName cOSName2;
        COSObject cOSObject;
        Integer n = (Integer)this.currentCounters.get(cOSName);
        if (n == null) {
            n = new Integer(0);
        }
        String string = (String)resourceNamePrefixes.get(cOSName);
        do {
            n = new Integer(n + 1);
        } while (!(cOSObject = this.cosGetResource(cOSName, cOSName2 = COSName.create((String.valueOf(string) + n).getBytes()))).isNull());
        this.currentCounters.put(cOSName, n);
        return cOSName2;
    }

    public COSName createShadingResource(PDShading pDShading) {
        return this.createResource(CN_RT_Shading, pDShading);
    }

    public COSName createXObjectResource(PDXObject pDXObject) {
        return this.createResource(CN_RT_XObject, pDXObject);
    }

    public PDColorSpace getColorSpaceResource(COSName cOSName) {
        return (PDColorSpace)this.getResource(CN_RT_ColorSpace, PDColorSpace.META, cOSName);
    }

    public PDExtGState getExtGStateResource(COSName cOSName) {
        return (PDExtGState)this.getResource(CN_RT_ExtGState, PDExtGState.META, cOSName);
    }

    public PDFont getFontResource(COSName cOSName) {
        return (PDFont)this.getResource(CN_RT_Font, PDFont.META, cOSName);
    }

    public PDPattern getPatternResource(COSName cOSName) {
        return (PDPattern)this.getResource(CN_RT_Pattern, PDPattern.META, cOSName);
    }

    public PDObject getResource(COSName cOSName, PDObject.MetaClass metaClass, COSName cOSName2) {
        COSDictionary cOSDictionary = this.cosGetResources(cOSName);
        if (cOSDictionary == null) {
            return null;
        }
        return (PDObject)metaClass.createFromCos(cOSDictionary.get(cOSName2));
    }

    public PDShading getShadingResource(COSName cOSName) {
        return (PDShading)this.getResource(CN_RT_Shading, PDShading.META, cOSName);
    }

    public PDXObject getXObjectResource(COSName cOSName) {
        return (PDXObject)this.getResource(CN_RT_XObject, PDXObject.META, cOSName);
    }

    @Override
    public void invalidateCaches() {
        super.invalidateCaches();
        this.cachedResources.clear();
    }

    public static class MetaClass
    extends PDObject.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDResources(cOSObject);
        }
    }
}

