/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSArray;
import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.pd.PDFunction;

public class PDSampledFunction
extends PDFunction {
    public static final COSName DK_BitsPerSample = COSName.constant("BitsPerSample");
    public static final COSName DK_Decode = COSName.constant("Decode");
    public static final COSName DK_Encode = COSName.constant("Encode");
    public static final COSName DK_Order = COSName.constant("Order");
    public static final COSName DK_Size = COSName.constant("Size");
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private byte[] samples;

    protected PDSampledFunction(COSObject cOSObject) {
        super(cOSObject);
    }

    public COSArray cosGetDecode() {
        return this.cosGetDict().get(DK_Decode).asArray();
    }

    @Override
    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    public COSArray cosGetEncode() {
        return this.cosGetDict().get(DK_Encode).asArray();
    }

    @Override
    public float[] evaluate(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        this.prepareInput(fArray, fArray2);
        float[] fArray3 = this.stepInterpolateOutput(fArray2, 0, 0, 0);
        this.prepareOutput(fArray3);
        return fArray3;
    }

    public int getBitsPerSample() {
        return this.cosGetDict().get(DK_BitsPerSample).asNumber().intValue();
    }

    public float getDecodeMax(int n) {
        COSArray cOSArray = this.cosGetDecode();
        if (cOSArray == null) {
            return this.getRangeMax(n);
        }
        return cOSArray.get(n * 2 + 1).asNumber().floatValue();
    }

    public float getDecodeMin(int n) {
        COSArray cOSArray = this.cosGetDecode();
        if (cOSArray == null) {
            return this.getRangeMin(n);
        }
        return this.cosGetDecode().get(n * 2).asNumber().floatValue();
    }

    public float getEncodeMax(int n) {
        COSArray cOSArray = this.cosGetEncode();
        if (cOSArray == null) {
            return this.getSize(n) - 1;
        }
        return this.cosGetEncode().get(n * 2 + 1).asNumber().floatValue();
    }

    public float getEncodeMin(int n) {
        COSArray cOSArray = this.cosGetEncode();
        if (cOSArray == null) {
            return 0.0f;
        }
        return this.cosGetEncode().get(n * 2).asNumber().floatValue();
    }

    @Override
    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    protected int getSample(int n) {
        int n2 = n >> 3;
        int n3 = 7 - n & 7;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.getBitsPerSample()) {
            n4 <<= 1;
            int n6 = this.getSamples()[n2] >> n3 & 1;
            n4 += n6;
            if (n3 == 0) {
                ++n2;
                n3 = 7;
            } else {
                --n3;
            }
            ++n5;
        }
        return n4;
    }

    protected byte[] getSamples() {
        if (this.samples == null) {
            this.samples = this.cosGetStream().getDecodedBytes();
        }
        return this.samples;
    }

    public COSArray getSize() {
        return this.cosGetDict().get(DK_Size).asArray();
    }

    public int getSize(int n) {
        return this.getSize().get(n).asNumber().intValue();
    }

    protected float interpolate(float f, float f2, float f3, float f4, float f5) {
        return f4 + (f - f2) * (f5 - f4) / (f3 - f2);
    }

    protected float[] lookup(int n) {
        int n2 = this.getBitsPerSample() * this.getOutputSize() * n;
        float[] fArray = new float[this.getOutputSize()];
        int n3 = 0;
        while (n3 < fArray.length) {
            fArray[n3] = this.getSample(n2);
            ++n3;
            n2 += this.getBitsPerSample();
        }
        return fArray;
    }

    protected void prepareInput(float[] fArray, float[] fArray2) {
        int n = 0;
        while (n < fArray.length) {
            fArray2[n] = this.clip(fArray[n], this.getDomainMin(n), this.getDomainMax(n));
            fArray2[n] = this.interpolate(fArray2[n], this.getDomainMin(n), this.getDomainMax(n), this.getEncodeMin(n), this.getEncodeMax(n));
            fArray2[n] = this.clip(fArray2[n], 0.0f, this.getSize(n) - 1);
            ++n;
        }
    }

    protected void prepareOutput(float[] fArray) {
        int n = 0;
        while (n < fArray.length) {
            fArray[n] = this.interpolate(fArray[n], 0.0f, (float)Math.pow(2.0, this.getBitsPerSample()), this.getDecodeMin(n), this.getDecodeMax(n));
            fArray[n] = this.clip(fArray[n], this.getRangeMin(n), this.getRangeMax(n));
            ++n;
        }
    }

    protected float[] stepInterpolateOutput(float[] fArray, int n, int n2, int n3) {
        float[] fArray2;
        float[] fArray3;
        int n4 = fArray.length - n3 - 1;
        int n5 = 1;
        int n6 = 0;
        while (n6 < n4) {
            n5 *= this.getSize(n6);
            ++n6;
        }
        if (n4 > -1) {
            n6 = n5 * (int)Math.floor(fArray[n4]);
            int n7 = n5 * (int)Math.ceil(fArray[n4]);
            fArray3 = this.stepInterpolateOutput(fArray, n + n6, n + n7, n3 + 1);
            if (n3 == 0) {
                return fArray3;
            }
            fArray2 = this.stepInterpolateOutput(fArray, n2 + n6, n2 + n7, n3 + 1);
        } else {
            fArray3 = this.lookup(n);
            fArray2 = n2 == n ? fArray3 : this.lookup(n2);
        }
        float[] fArray4 = new float[this.getOutputSize()];
        n6 = 0;
        while (n6 < fArray4.length) {
            float f = fArray3[n6];
            float f2 = fArray2[n6];
            float f3 = (float)((double)fArray[n3 - 1] - Math.floor(fArray[n3 - 1]));
            fArray4[n6] = f + f3 * (f2 - f);
            ++n6;
        }
        return fArray4;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class<?> clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDSampledFunction(cOSObject);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSStream.create(null);
        }
    }
}

