/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.IXRefEntryVisitor;
import de.intarsys.pdf.st.STXRefEntry;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefEntryFree;
import de.intarsys.pdf.st.STXRefEntryOccupied;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class STTools {
    public static List<STXRefEntry> getOccupiedEntries(STXRefSection sTXRefSection) throws IOException {
        EntryCollector entryCollector = new EntryCollector();
        STTools.visitEntries(sTXRefSection, entryCollector);
        return entryCollector.getEntries();
    }

    public static void visitEntries(STXRefSection sTXRefSection, IXRefEntryVisitor iXRefEntryVisitor) throws IOException {
        Iterator iterator = sTXRefSection.subsectionIterator();
        while (iterator.hasNext()) {
            STXRefSubsection sTXRefSubsection = (STXRefSubsection)iterator.next();
            Iterator iterator2 = sTXRefSubsection.getEntries().iterator();
            while (iterator2.hasNext()) {
                try {
                    ((STXRefEntry)iterator2.next()).accept(iXRefEntryVisitor);
                }
                catch (XRefEntryVisitorException xRefEntryVisitorException) {
                    throw (IOException)xRefEntryVisitorException.getCause();
                }
            }
        }
    }

    public static class EntryCollector
    implements IXRefEntryVisitor {
        private List<STXRefEntry> entries = new ArrayList<STXRefEntry>();

        public List<STXRefEntry> getEntries() {
            return this.entries;
        }

        @Override
        public void visitFromCompressed(STXRefEntryCompressed sTXRefEntryCompressed) throws XRefEntryVisitorException {
        }

        @Override
        public void visitFromFree(STXRefEntryFree sTXRefEntryFree) throws XRefEntryVisitorException {
        }

        @Override
        public void visitFromOccupied(STXRefEntryOccupied sTXRefEntryOccupied) throws XRefEntryVisitorException {
            if (sTXRefEntryOccupied.getObjectNumber() == 0) {
                return;
            }
            this.entries.add(sTXRefEntryOccupied);
        }
    }
}

