/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.st;

import de.intarsys.pdf.st.AbstractXRefWriter;
import de.intarsys.pdf.st.STXRefEntryCompressed;
import de.intarsys.pdf.st.STXRefSection;
import de.intarsys.pdf.st.STXRefSubsection;
import de.intarsys.pdf.st.XRefEntryVisitorException;
import de.intarsys.pdf.writer.COSWriter;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class XRefTrailerWriter
extends AbstractXRefWriter {
    public static final byte[] TYPE_FREE = "f".getBytes();
    public static final byte[] TYPE_OCCUPIED = "n".getBytes();
    public static final NumberFormat FORMAT_XREF_GENERATION = new DecimalFormat("00000");
    public static final NumberFormat FORMAT_XREF_OFFSET = new DecimalFormat("0000000000");
    public static final byte[] XREF = "xref".getBytes();

    public XRefTrailerWriter(COSWriter cOSWriter) {
        super(cOSWriter);
    }

    @Override
    protected void initialize(STXRefSection sTXRefSection) throws IOException {
        super.initialize(sTXRefSection);
        this.setRandomAccess(this.getCosWriter().getRandomAccess());
        this.getRandomAccess().write(XREF);
        this.getRandomAccess().write(COSWriter.EOL);
    }

    @Override
    protected void finish(STXRefSection sTXRefSection) throws IOException {
        this.getCosWriter().write(COSWriter.TRAILER);
        this.getCosWriter().writeEOL();
        this.getCosWriter().writeObject(sTXRefSection.cosGetDict());
        super.finish(sTXRefSection);
    }

    @Override
    public void visitFromCompressed(STXRefEntryCompressed sTXRefEntryCompressed) throws XRefEntryVisitorException {
        try {
            this.write(sTXRefEntryCompressed.getObjectNumber(), 65535, this.getTypeFree());
        }
        catch (IOException iOException) {
            throw new XRefEntryVisitorException(iOException);
        }
    }

    @Override
    protected void write(int n, int n2, byte[] byArray) throws IOException {
        String string = FORMAT_XREF_OFFSET.format(n);
        String string2 = FORMAT_XREF_GENERATION.format(n2);
        this.getRandomAccess().write(StringTools.toByteArray((String)string));
        this.getRandomAccess().write(COSWriter.SPACE);
        this.getRandomAccess().write(StringTools.toByteArray((String)string2));
        this.getRandomAccess().write(COSWriter.SPACE);
        this.getRandomAccess().write(byArray);
        this.getRandomAccess().write(COSWriter.CRLF);
    }

    @Override
    protected void visitFromSubsection(STXRefSubsection sTXRefSubsection) throws IOException {
        this.getRandomAccess().write(StringTools.toByteArray((String)Integer.toString(sTXRefSubsection.getStart())));
        this.getRandomAccess().write(COSWriter.SPACE);
        this.getRandomAccess().write(StringTools.toByteArray((String)Integer.toString(sTXRefSubsection.getSize())));
        this.getRandomAccess().write(COSWriter.EOL);
    }

    @Override
    protected byte[] getTypeCompressed() {
        return TYPE_FREE;
    }

    @Override
    protected byte[] getTypeFree() {
        return TYPE_FREE;
    }

    @Override
    protected byte[] getTypeOccupied() {
        return TYPE_OCCUPIED;
    }
}

