/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.jna;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.jna.JNATools;

public class JnaNativeHandle
implements INativeHandle {
    private final Pointer pointer;
    private int size;

    public JnaNativeHandle(JnaNativeHandle jnaNativeHandle, int n) {
        this.pointer = new Pointer(jnaNativeHandle.getAddress() + (long)n);
        this.size = jnaNativeHandle.size - n;
    }

    public JnaNativeHandle(long l) {
        this.pointer = new Pointer(l);
    }

    public JnaNativeHandle(Pointer pointer) {
        this.pointer = pointer;
    }

    public boolean equals(Object object) {
        if (!(object instanceof INativeHandle)) {
            return false;
        }
        INativeHandle iNativeHandle = (INativeHandle)object;
        return JNATools.getPeer(this.pointer) == iNativeHandle.getAddress() && this.size == iNativeHandle.getSize();
    }

    @Override
    public long getAddress() {
        return JNATools.getPeer(this.pointer);
    }

    @Override
    public byte getByte(int n) {
        return this.pointer.getByte((long)n);
    }

    @Override
    public byte[] getByteArray(int n, int n2) {
        return this.pointer.getByteArray((long)n, n2);
    }

    @Override
    public long getCLong(int n) {
        if (Native.LONG_SIZE == 4) {
            return this.pointer.getInt((long)n);
        }
        return this.pointer.getLong((long)n);
    }

    @Override
    public int getInt(int n) {
        return this.pointer.getInt((long)n);
    }

    @Override
    public long getLong(int n) {
        return this.pointer.getLong((long)n);
    }

    @Override
    public INativeHandle getNativeHandle(int n) {
        Pointer pointer = this.pointer.getPointer((long)n);
        return new JnaNativeHandle(pointer);
    }

    public Pointer getPointer() {
        return this.pointer;
    }

    @Override
    public short getShort(int n) {
        return this.pointer.getShort((long)n);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public String getString(int n) {
        return this.getPointer().getString((long)n);
    }

    @Override
    public String getWideString(int n) {
        return this.getPointer().getString((long)n, true);
    }

    public int hashCode() {
        return this.pointer.hashCode();
    }

    @Override
    public INativeHandle offset(int n) {
        return new JnaNativeHandle(this, n);
    }

    @Override
    public void setByte(int n, byte by) {
        this.pointer.setByte((long)n, by);
    }

    @Override
    public void setByteArray(int n, byte[] byArray, int n2, int n3) {
        this.pointer.write((long)n, byArray, n2, n3);
    }

    @Override
    public void setCLong(int n, long l) {
        if (Native.LONG_SIZE == 4) {
            this.pointer.setInt((long)n, (int)l);
            return;
        }
        this.pointer.setLong((long)n, l);
    }

    @Override
    public void setInt(int n, int n2) {
        this.pointer.setInt((long)n, n2);
    }

    @Override
    public void setLong(int n, long l) {
        this.pointer.setLong((long)n, l);
    }

    @Override
    public void setNativeHandle(int n, INativeHandle iNativeHandle) {
        this.pointer.setPointer((long)n, new Pointer(iNativeHandle.getAddress()));
    }

    @Override
    public void setShort(int n, short s) {
        this.pointer.setShort((long)n, s);
    }

    @Override
    public void setSize(int n) {
        this.size = n;
    }

    @Override
    public void setString(int n, String string) {
        this.getPointer().setString((long)n, string);
    }

    @Override
    public void setWideString(int n, String string) {
        this.getPointer().setString((long)n, string, true);
    }
}

