/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.type.INativeObject;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeArray;
import de.intarsys.nativec.type.NativeType;

public class NativeArrayType
extends NativeType {
    private final int arraySize;
    private final int baseSize;
    private final INativeType baseType;

    public static NativeArrayType create(INativeType iNativeType, int n) {
        return new NativeArrayType(iNativeType, n);
    }

    protected NativeArrayType(INativeType iNativeType, int n) {
        this.baseType = iNativeType;
        this.baseSize = iNativeType.getByteCount();
        this.arraySize = n;
    }

    @Override
    public INativeObject createNative(INativeHandle iNativeHandle) {
        NativeArray nativeArray = new NativeArray(this, iNativeHandle);
        if (this.arraySize > 0) {
            nativeArray.setSize(this.arraySize);
        }
        return nativeArray;
    }

    @Override
    public INativeObject createNative(Object object) {
        NativeArray nativeArray = new NativeArray(this);
        return nativeArray;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public int getBaseSize() {
        return this.baseSize;
    }

    public INativeType getBaseType() {
        return this.baseType;
    }

    @Override
    public int getByteCount() {
        return this.arraySize * this.baseSize;
    }

    @Override
    public int getPreferredBoundary() {
        return this.baseType.getPreferredBoundary();
    }
}

