/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.type;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeTools;
import de.intarsys.nativec.type.INativeType;
import de.intarsys.nativec.type.NativeObject;
import de.intarsys.nativec.type.NativeType;
import de.intarsys.nativec.type.NativeWideStringType;

public class NativeWideString
extends NativeObject {
    public static final NativeWideStringType META = new NativeWideStringType();
    private int size = 0;
    private NativeWideStringType type;

    static {
        NativeType.register(NativeWideString.class, META);
    }

    public static NativeWideString createFromAddress(long l) {
        return (NativeWideString)META.createNative(NativeTools.toHandle(l));
    }

    protected NativeWideString(NativeWideStringType nativeWideStringType) {
        this.type = nativeWideStringType;
        this.allocate();
    }

    protected NativeWideString(NativeWideStringType nativeWideStringType, INativeHandle iNativeHandle) {
        super(iNativeHandle);
        this.type = nativeWideStringType;
        if (this.type.hasByteCount()) {
            iNativeHandle.setSize(this.type.getByteCount());
        }
    }

    protected NativeWideString(NativeWideStringType nativeWideStringType, String string) {
        this.type = nativeWideStringType;
        if (this.type.getStringSize() == 0) {
            this.size = string.length() + 1;
            this.size <<= 1;
        }
        this.allocate();
        this.setValue(string);
    }

    public NativeWideString(String string) {
        this(META, string);
    }

    @Override
    public int getByteCount() {
        if (this.type.hasByteCount()) {
            return this.type.getByteCount();
        }
        return this.size;
    }

    @Override
    public INativeType getNativeType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.stringValue();
    }

    @Override
    public void setValue(Object object) {
        this.setValue((String)object);
    }

    public void setValue(String string) {
        this.size = string.length() + 1;
        this.size <<= 1;
        this.handle.setWideString(0, string);
    }

    public String stringValue() {
        return this.handle.getWideString(0);
    }
}

