/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.annotations;

import java.awt.Color;
import java.awt.Component;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import org.icepdf.core.Memento;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.pobjects.PageTree;
import org.icepdf.core.pobjects.annotations.Annotation;
import org.icepdf.core.pobjects.annotations.BorderStyle;
import org.icepdf.core.pobjects.annotations.LinkAnnotation;
import org.icepdf.core.views.AnnotationComponent;

public class AnnotationState
implements Memento {
    protected Integer linkType;
    protected String highlightStyle;
    protected float lineThickness;
    protected String lineStyle;
    protected Color color;
    protected Rectangle2D.Float userSpaceRectangle;
    protected AnnotationComponent annotationComponent;

    public AnnotationState(AnnotationComponent annotationComponent) {
        this.annotationComponent = annotationComponent;
        if (this.annotationComponent != null && this.annotationComponent.getAnnotation() != null) {
            Annotation annotation = this.annotationComponent.getAnnotation();
            this.linkType = annotation.getLinkType();
            if (annotation instanceof LinkAnnotation) {
                this.highlightStyle = ((LinkAnnotation)annotation).getHighlightMode();
            }
            this.lineThickness = annotation.getLineThickness();
            this.lineStyle = annotation.getLineStyle();
            Color tmpColor = annotation.getColor();
            if (tmpColor != null) {
                this.color = new Color(tmpColor.getRGB());
            }
            Rectangle2D.Float rect = annotation.getUserSpaceRectangle();
            this.userSpaceRectangle = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public AnnotationState(Integer linkType, String highlightStyle, float lineThickness, String lineStyle, Color color) {
        this.linkType = linkType;
        this.highlightStyle = highlightStyle;
        this.lineThickness = lineThickness;
        this.lineStyle = lineStyle;
        if (color != null) {
            this.color = new Color(color.getRGB());
        }
    }

    public void apply(AnnotationState applyState) {
        this.linkType = applyState.linkType;
        this.highlightStyle = applyState.highlightStyle;
        this.lineThickness = applyState.lineThickness;
        this.lineStyle = applyState.lineStyle;
        this.color = applyState.color != null ? new Color(applyState.color.getRGB()) : Color.BLACK;
        Rectangle2D.Float rect = applyState.userSpaceRectangle;
        if (rect != null) {
            this.userSpaceRectangle = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
        }
        this.restore();
    }

    public void restore() {
        if (this.annotationComponent != null && this.annotationComponent.getAnnotation() != null) {
            Annotation annotation = this.annotationComponent.getAnnotation();
            this.restore(annotation);
            this.synchronizeState();
        }
    }

    public void restore(Annotation annotation) {
        if (annotation.getBorderStyle() == null) {
            annotation.setBorderStyle(new BorderStyle());
        }
        if (this.color != null) {
            annotation.setColor(this.color);
        }
        annotation.setUserSpaceRectangle(this.userSpaceRectangle);
        this.restoreLineThickness(annotation);
        this.restoreHighlightStyle(annotation);
        this.restoreLineStyle(annotation);
        this.applyInvisibleLinkType(annotation);
    }

    public void synchronizeState() {
        int pageIndex = this.annotationComponent.getPageIndex();
        Document document = this.annotationComponent.getDocument();
        Annotation annotation = this.annotationComponent.getAnnotation();
        PageTree pageTree = document.getPageTree();
        Page page = pageTree.getPage(pageIndex, this);
        if (!annotation.isDeleted()) {
            page.updateAnnotation(annotation);
            this.annotationComponent.refreshDirtyBounds();
        } else {
            annotation.setDeleted(false);
            page.addAnnotation(annotation);
            ((Component)((Object)this.annotationComponent)).setVisible(true);
            this.annotationComponent.refreshDirtyBounds();
        }
        pageTree.releasePage(page, (Object)this);
    }

    private void restoreLineThickness(Annotation annotation) {
        Vector borderProps;
        Object border;
        if (this.linkType == 1 && this.lineThickness == 0.0f) {
            this.lineThickness = 1.0f;
        }
        if ((border = annotation.getObject(Annotation.BORDER_KEY)) != null && border instanceof Vector && (borderProps = (Vector)border).size() >= 3) {
            borderProps.set(2, Float.valueOf(this.lineThickness));
        }
        if (annotation.getBorderStyle() != null) {
            BorderStyle borderStyle = annotation.getBorderStyle();
            borderStyle.setStrokeWidth(this.lineThickness);
        }
    }

    private void restoreHighlightStyle(Annotation annotation) {
        if (annotation instanceof LinkAnnotation) {
            LinkAnnotation linkAnnotation = (LinkAnnotation)annotation;
            Object object = linkAnnotation.getObject(LinkAnnotation.HIGHLIGHT_MODE_KEY);
            if (object != null && object instanceof Name) {
                linkAnnotation.getEntries().put(LinkAnnotation.HIGHLIGHT_MODE_KEY, new Name(this.highlightStyle));
            } else {
                linkAnnotation.getEntries().put(LinkAnnotation.HIGHLIGHT_MODE_KEY, new Name(this.highlightStyle));
            }
        }
    }

    private void restoreLineStyle(Annotation annotation) {
        Vector borderProps;
        Object border = annotation.getObject(Annotation.BORDER_KEY);
        BorderStyle borderStyle = annotation.getBorderStyle();
        borderStyle.setBorderStyle(this.lineStyle);
        if (border != null && border instanceof Vector && (borderProps = (Vector)border).size() == 4) {
            borderProps.remove(3);
        }
    }

    private void applyInvisibleLinkType(Annotation annotation) {
        if (this.linkType == 0) {
            Vector borderProps;
            Object border = annotation.getObject(Annotation.BORDER_KEY);
            if (border != null && border instanceof Vector && (borderProps = (Vector)border).size() >= 3) {
                borderProps.set(2, 0);
            }
            if (annotation.getBorderStyle() != null) {
                BorderStyle borderStyle = annotation.getBorderStyle();
                borderStyle.setStrokeWidth(0.0f);
            }
        }
    }
}

