/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.awt.environment;

import de.intarsys.cwt.awt.environment.CwtAwtGraphicsEnvironment;
import de.intarsys.cwt.common.BlendMode;
import de.intarsys.cwt.common.IPaint;
import de.intarsys.cwt.environment.IGraphicsContext;
import de.intarsys.cwt.environment.IGraphicsEnvironment;
import de.intarsys.cwt.image.IImage;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.Map;

public class CwtAwtGraphicsContext
implements IGraphicsContext {
    private BlendMode blendMode = (BlendMode)BlendMode.META.getDefault();
    private Graphics2D graphics;
    private Paint paintActive;
    private Paint paintBackground;
    private Paint paintForeground;

    public CwtAwtGraphicsContext(Graphics2D graphics2D) {
        this.graphics = graphics2D;
    }

    @Override
    public void clip(Shape shape) {
        if (shape == null) {
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            return;
        }
        this.graphics.clip(shape);
    }

    @Override
    public void dispose() {
        this.graphics.dispose();
    }

    public void disposeClip(Object object) {
    }

    @Override
    public void draw(Shape shape) {
        if (this.paintActive != this.paintForeground) {
            this.graphics.setPaint(this.paintForeground);
            this.paintActive = this.paintForeground;
        }
        this.graphics.draw(shape);
    }

    @Override
    public void drawImage(IImage iImage, float f, float f2) {
        iImage.drawFromGraphicsContext(this, f, f2);
    }

    @Override
    public void drawString(String string, float f, float f2) {
        if (this.paintActive != this.paintForeground) {
            this.graphics.setPaint(this.paintForeground);
            this.paintActive = this.paintForeground;
        }
        this.graphics.drawString(string, f, f2);
    }

    @Override
    public void fill(Shape shape) {
        if (this.paintActive != this.paintBackground) {
            this.graphics.setPaint(this.paintBackground);
            this.paintActive = this.paintBackground;
        }
        this.graphics.fill(shape);
    }

    @Override
    public Color getBackgroundColor() {
        if (this.paintBackground instanceof Color) {
            return (Color)this.paintBackground;
        }
        return this.graphics.getBackground();
    }

    public BlendMode getBlendMode() {
        return this.blendMode;
    }

    @Override
    public Shape getClip() {
        return this.graphics.getClip();
    }

    public Font getFont() {
        return this.graphics.getFont();
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    @Override
    public Color getForegroundColor() {
        if (this.paintForeground instanceof Color) {
            return (Color)this.paintForeground;
        }
        return this.graphics.getColor();
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    @Override
    public IGraphicsEnvironment getGraphicsEnvironment() {
        return CwtAwtGraphicsEnvironment.get();
    }

    @Override
    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    @Override
    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    public void resetAdvanced() {
    }

    @Override
    public void rotate(float f) {
        this.graphics.rotate(f);
    }

    @Override
    public void scale(float f, float f2) {
        this.graphics.scale(f, f2);
    }

    @Override
    public void setBackgroundColor(Color color) {
        this.graphics.setBackground(color);
        this.paintBackground = color;
    }

    @Override
    public void setBackgroundPaint(IPaint iPaint) {
        iPaint.setBackgroundPaintFromGraphicsContext(this);
    }

    public void setBackgroundPaint(Paint paint) {
        this.paintBackground = paint;
    }

    public void setBlendMode(BlendMode blendMode) {
        this.blendMode = blendMode;
    }

    @Override
    public void setClip(Shape shape) {
        if (shape == null) {
            this.graphics.setClip(null);
            return;
        }
        if (shape.getPathIterator(null).isDone()) {
            this.graphics.setClip(0, 0, 0, 0);
            return;
        }
        this.graphics.setClip(shape);
    }

    @Override
    public void setFont(Font font) {
        this.graphics.setFont(font);
    }

    @Override
    public void setForegroundColor(Color color) {
        this.paintForeground = color;
    }

    @Override
    public void setForegroundPaint(IPaint iPaint) {
        iPaint.setForegroundPaintFromGraphicsContext(this);
    }

    public void setForegroundPaint(Paint paint) {
        this.paintForeground = paint;
    }

    @Override
    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.graphics.setRenderingHint(key, object);
    }

    @Override
    public void setRenderingHints(Map map) {
        this.graphics.setRenderingHints(map);
    }

    @Override
    public void setStroke(Stroke stroke) {
        this.graphics.setStroke(stroke);
    }

    @Override
    public void setTransform(AffineTransform affineTransform) {
        this.graphics.setTransform(affineTransform);
    }

    @Override
    public void transform(AffineTransform affineTransform) {
        this.graphics.transform(affineTransform);
    }

    @Override
    public void translate(float f, float f2) {
        this.graphics.translate(f, f2);
    }
}

