/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.cache;

import de.intarsys.tools.cache.CacheEntry;
import de.intarsys.tools.component.ISynchronizable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Cache<T>
implements ISynchronizable {
    private final Map<Object, CacheEntry<T>> map = new HashMap<Object, CacheEntry<T>>();
    private final CacheEntry<T>[] elements;
    private int ptr = 0;

    public Cache(int n) {
        this.elements = new CacheEntry[n];
    }

    public synchronized void clear() {
        this.map.clear();
        int n = 0;
        while (n < this.ptr) {
            this.elements[n] = null;
            ++n;
        }
        this.ptr = 0;
    }

    public synchronized T get(Object object) {
        ISynchronizable iSynchronizable;
        CacheEntry<T> cacheEntry = this.map.get(object);
        if (cacheEntry != null && cacheEntry.getValue() instanceof ISynchronizable && (iSynchronizable = (ISynchronizable)cacheEntry.getValue()).isOutOfSynch()) {
            this.remove(object);
            cacheEntry = null;
        }
        if (cacheEntry != null) {
            cacheEntry.touch();
            return cacheEntry.getValue();
        }
        return null;
    }

    @Override
    public boolean isOutOfSynch() {
        return false;
    }

    public synchronized void put(Object object, T t) {
        CacheEntry<T> cacheEntry = new CacheEntry<T>(object, t);
        if (this.ptr >= this.elements.length) {
            this.removeStrategy();
        }
        this.elements[this.ptr++] = cacheEntry;
        this.map.put(object, cacheEntry);
    }

    public synchronized void remove(Object object) {
        CacheEntry<T> cacheEntry = this.map.remove(object);
        int n = 0;
        while (n < this.ptr) {
            CacheEntry<T> cacheEntry2 = this.elements[n];
            if (cacheEntry2 == cacheEntry) {
                --this.ptr;
                if (n < this.ptr) {
                    System.arraycopy(this.elements, n + 1, this.elements, n, this.ptr - n);
                }
                this.elements[this.ptr] = null;
            }
            ++n;
        }
    }

    protected void removeStrategy() {
        Arrays.sort(this.elements, 0, this.ptr);
        --this.ptr;
        CacheEntry<T> cacheEntry = this.elements[this.ptr];
        this.map.remove(cacheEntry.getKey());
        this.elements[this.ptr] = null;
    }

    public synchronized int size() {
        return this.ptr;
    }

    @Override
    public synchronized void synch() {
        int n = 0;
        while (n < this.ptr) {
            CacheEntry<T> cacheEntry = this.elements[n];
            if (cacheEntry.getValue() instanceof ISynchronizable) {
                ((ISynchronizable)cacheEntry.getValue()).synch();
            }
            ++n;
        }
    }
}

