/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.dom;

import de.intarsys.tools.dom.ElementTools;
import de.intarsys.tools.dom.IElementConfigurable;
import de.intarsys.tools.exception.TunnelingException;
import de.intarsys.tools.proxy.IProxy;
import de.intarsys.tools.reflect.ObjectCreationException;
import org.w3c.dom.Element;

public class ElementObjectProxy
implements IElementConfigurable,
IProxy {
    private Element element;
    private Object realized;
    private final Class proxyClass;
    private final String proxyClassAttribute;
    private final ClassLoader classLoader;

    public ElementObjectProxy() {
        this.proxyClass = Object.class;
        this.proxyClassAttribute = "class";
        this.classLoader = this.getClass().getClassLoader();
    }

    public ElementObjectProxy(Class clazz, Element element, ClassLoader classLoader) {
        this.element = element;
        this.proxyClass = clazz;
        this.classLoader = classLoader;
        this.proxyClassAttribute = "class";
    }

    public ElementObjectProxy(Class clazz, Element element, String string, ClassLoader classLoader) {
        this.element = element;
        this.proxyClass = clazz;
        this.classLoader = classLoader;
        this.proxyClassAttribute = string;
    }

    protected Object basicGetRealized() {
        return this.realized;
    }

    @Override
    public void configure(Element element) {
        this.element = element;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Element getElement() {
        return this.element;
    }

    public Class getProxyClass() {
        return this.proxyClass;
    }

    public String getProxyClassAttribute() {
        return this.proxyClassAttribute;
    }

    @Override
    public synchronized Object getRealized() {
        if (this.realized == null) {
            try {
                this.realized = this.realize();
            }
            catch (ObjectCreationException objectCreationException) {
                throw new TunnelingException(objectCreationException);
            }
        }
        return this.realized;
    }

    protected Object realize() throws ObjectCreationException {
        Object t = ElementTools.createObject(this.getElement(), this.getProxyClassAttribute(), this.getProxyClass(), this.getClassLoader());
        return t;
    }
}

