/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.expression;

import de.intarsys.tools.expression.ContainerResolver;
import de.intarsys.tools.expression.EvaluationException;
import de.intarsys.tools.expression.IStringEvaluator;
import de.intarsys.tools.expression.MessageBundleStringResolver;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.message.MessageBundle;
import de.intarsys.tools.message.MessageBundleTools;
import java.util.HashMap;
import java.util.Map;

public class NLSStringResolver
extends ContainerResolver {
    private final ClassLoader classLoader;
    private Map<String, IStringEvaluator> resolvers = new HashMap<String, IStringEvaluator>();

    public NLSStringResolver() {
        this(NLSStringResolver.class.getClassLoader());
    }

    public NLSStringResolver(ClassLoader classLoader) {
        super('#');
        this.classLoader = classLoader;
    }

    @Override
    protected Object basicEvaluate(String string, IArgs iArgs) throws EvaluationException {
        IStringEvaluator iStringEvaluator = this.resolvers.get(string);
        if (iStringEvaluator == null) {
            MessageBundle messageBundle = MessageBundleTools.getMessageBundle(string, this.getClassLoader());
            iStringEvaluator = new MessageBundleStringResolver(messageBundle);
            this.resolvers.put(string, iStringEvaluator);
        }
        return iStringEvaluator;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

