/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.functor;

import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.functor.FunctorCall;
import de.intarsys.tools.functor.FunctorInvocationException;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.functor.IFunctor;
import de.intarsys.tools.functor.IFunctorCall;
import de.intarsys.tools.functor.IFunctorCallFactory;
import de.intarsys.tools.functor.INamedFunctor;
import de.intarsys.tools.reflect.IMethodHandler;
import de.intarsys.tools.reflect.MethodInvocationException;
import de.intarsys.tools.reflect.ObjectCreationException;

public class FunctorMethodHandler
implements IMethodHandler,
IAttributeSupport {
    private final IFunctor invoker;
    private final String name;

    public static IMethodHandler create(IFunctor iFunctor) {
        if (iFunctor instanceof IMethodHandler) {
            return (IMethodHandler)((Object)iFunctor);
        }
        if (iFunctor instanceof INamedFunctor) {
            return new FunctorMethodHandler(((INamedFunctor)iFunctor).getId(), iFunctor);
        }
        return new FunctorMethodHandler("unknown", iFunctor);
    }

    public FunctorMethodHandler(String string, IFunctor iFunctor) {
        this.name = string;
        this.invoker = iFunctor;
    }

    @Override
    public Object getAttribute(Object object) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).getAttribute(object);
        }
        return null;
    }

    public IFunctor getInvoker() {
        return this.invoker;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Object invoke(Object object, IArgs iArgs) throws MethodInvocationException {
        IFunctorCall iFunctorCall;
        if (this.invoker == null) {
            return null;
        }
        if (object instanceof IFunctorCallFactory) {
            try {
                iFunctorCall = ((IFunctorCallFactory)object).createFunctorCall(this.invoker, object, iArgs);
            }
            catch (ObjectCreationException objectCreationException) {
                throw new MethodInvocationException(this.getName(), objectCreationException);
            }
        } else {
            iFunctorCall = new FunctorCall(object, iArgs);
        }
        try {
            return this.invoker.perform(iFunctorCall);
        }
        catch (FunctorInvocationException functorInvocationException) {
            Throwable throwable = functorInvocationException.getCause() == null ? functorInvocationException : functorInvocationException.getCause();
            throw new MethodInvocationException(this.getName(), throwable);
        }
    }

    @Override
    public Object removeAttribute(Object object) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).removeAttribute(object);
        }
        return null;
    }

    @Override
    public Object setAttribute(Object object, Object object2) {
        if (this.invoker instanceof IAttributeSupport) {
            return ((IAttributeSupport)((Object)this.invoker)).setAttribute(object, object2);
        }
        return null;
    }
}

