/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class BONSerializer
implements ISerializer {
    private final OutputStream os;
    private String charset = "UTF-8";
    private boolean first = true;

    public BONSerializer(OutputStream outputStream) {
        this.os = outputStream;
    }

    public BONSerializer(OutputStream outputStream, String string) {
        this.os = outputStream;
        this.charset = string;
    }

    protected void basicSerialize(Object object) throws IOException {
        if (object == null) {
            this.os.write(StringTools.toByteArray("null"));
        } else if (object instanceof Number) {
            this.os.write(StringTools.toByteArray(String.valueOf(object)));
        } else if (object instanceof Boolean) {
            this.os.write(StringTools.toByteArray(String.valueOf(object)));
        } else if (object instanceof String) {
            this.serializeString((String)object);
        } else if (object instanceof byte[]) {
            this.serializeBase64((byte[])object);
        } else if (object instanceof List) {
            this.serializeList((List)object);
        } else if (object instanceof Map) {
            this.serializeMap((Map)object);
        } else {
            throw new IOException("unknown object type " + object.getClass());
        }
    }

    public String getCharset() {
        return this.charset;
    }

    @Override
    public void serialize(Object object) throws IOException {
        if (!this.first) {
            this.os.write(32);
        }
        this.first = false;
        this.basicSerialize(object);
    }

    protected void serializeBase64(byte[] byArray) throws IOException {
        this.os.write(64);
        this.os.write(Base64.encode(byArray));
        this.os.write(64);
    }

    protected void serializeList(List list) throws IOException {
        boolean bl = false;
        this.os.write(91);
        for (Object e : list) {
            if (bl) {
                this.os.write(44);
            }
            bl = true;
            this.basicSerialize(e);
        }
        this.os.write(93);
    }

    protected void serializeMap(Map<Object, Object> map) throws IOException {
        boolean bl = false;
        this.os.write(123);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            if (bl) {
                this.os.write(44);
            }
            bl = true;
            this.basicSerialize(entry.getKey());
            this.os.write(58);
            this.basicSerialize(entry.getValue());
        }
        this.os.write(125);
    }

    protected void serializeString(String string) throws IOException {
        this.os.write(34);
        byte[] byArray = string.getBytes(this.getCharset());
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            if (by == 92) {
                this.os.write(92);
            } else if (by == 34) {
                this.os.write(92);
            }
            this.os.write(by);
            ++n;
        }
        this.os.write(34);
    }

    public void setCharset(String string) {
        this.charset = string;
    }
}

