/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.serialize;

import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.serialize.BONSerializationFactory;
import de.intarsys.tools.serialize.IDeserializer;
import de.intarsys.tools.serialize.ISerializer;
import de.intarsys.tools.serialize.StreamSerializationContext;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BONTools {
    public static Object deserialize(byte[] byArray) throws IOException {
        BONSerializationFactory bONSerializationFactory = new BONSerializationFactory();
        StreamSerializationContext streamSerializationContext = new StreamSerializationContext(byArray);
        IDeserializer iDeserializer = bONSerializationFactory.createDeserializer(streamSerializationContext);
        return iDeserializer.deserialize();
    }

    public static Object deserialize(String string) throws IOException {
        BONSerializationFactory bONSerializationFactory = new BONSerializationFactory();
        StreamSerializationContext streamSerializationContext = new StreamSerializationContext(string);
        IDeserializer iDeserializer = bONSerializationFactory.createDeserializer(streamSerializationContext);
        return iDeserializer.deserialize();
    }

    public static void flatten(Object object, String string, Map<String, String> map) throws IOException {
        if (object instanceof Map) {
            for (Map.Entry entry : ((Map)object).entrySet()) {
                String string2 = String.valueOf(entry.getKey());
                Object v = entry.getValue();
                String string3 = StringTools.isEmpty(string) ? string2 : String.valueOf(string) + "." + string2;
                BONTools.flatten(v, string3, map);
            }
        } else if (object instanceof Object[]) {
            int n = 0;
            for (Object object2 : Arrays.asList((Object[])object)) {
                String string4 = StringTools.isEmpty(string) ? "" + n : String.valueOf(string) + "." + n;
                BONTools.flatten(object2, string4, map);
            }
        } else if (object instanceof List) {
            int n = 0;
            for (Object e : (List)object) {
                String string5 = StringTools.isEmpty(string) ? "" + n : String.valueOf(string) + "." + n;
                BONTools.flatten(e, string5, map);
            }
        } else if (object instanceof IArgs) {
            IArgs iArgs = (IArgs)object;
            int n = 0;
            Iterator<IArgs.IBinding> iterator = iArgs.bindings();
            while (iterator.hasNext()) {
                IArgs.IBinding iBinding = iterator.next();
                Object object3 = iBinding.getValue();
                String string6 = iBinding.getName() == null ? "" + n : iBinding.getName();
                String string7 = StringTools.isEmpty(string) ? string6 : String.valueOf(string) + "." + string6;
                BONTools.flatten(object3, string7, map);
                ++n;
            }
        } else {
            String string8 = BONTools.serializeString(object);
            map.put(string, string8);
        }
    }

    public static boolean isSupported(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Number) {
            return true;
        }
        if (object instanceof Boolean) {
            return true;
        }
        if (object instanceof String) {
            return true;
        }
        return object instanceof byte[];
    }

    public static byte[] serializeBytes(Object object) throws IOException {
        BONSerializationFactory bONSerializationFactory = new BONSerializationFactory();
        StreamSerializationContext streamSerializationContext = new StreamSerializationContext();
        ISerializer iSerializer = bONSerializationFactory.createSerializer(streamSerializationContext);
        iSerializer.serialize(object);
        return streamSerializationContext.getBytes();
    }

    public static String serializeString(Object object) throws IOException {
        BONSerializationFactory bONSerializationFactory = new BONSerializationFactory();
        StreamSerializationContext streamSerializationContext = new StreamSerializationContext();
        ISerializer iSerializer = bONSerializationFactory.createSerializer(streamSerializationContext);
        iSerializer.serialize(object);
        return new String(streamSerializationContext.getBytes(), "UTF-8");
    }
}

