/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.tlv.common;

import de.intarsys.tools.tlv.common.TlvElement;
import de.intarsys.tools.tlv.common.TlvFormatException;
import de.intarsys.tools.tlv.common.TlvInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class TlvTemplate
implements Iterable<TlvElement> {
    private final List<TlvElement> elements = new ArrayList<TlvElement>();

    public TlvTemplate() {
    }

    public TlvTemplate(TlvInputStream tlvInputStream) throws TlvFormatException {
        try {
            TlvElement tlvElement = tlvInputStream.readElement();
            while (tlvElement != null) {
                this.elements.add(tlvElement);
                tlvElement = tlvInputStream.readElement();
            }
        }
        catch (IOException iOException) {
            throw new TlvFormatException(iOException.getMessage(), iOException);
        }
    }

    public void addElement(TlvElement tlvElement) {
        this.elements.add(tlvElement);
    }

    public TlvElement getElement(int n) {
        for (TlvElement tlvElement : this.elements) {
            if (tlvElement.getIdentifier() != n) continue;
            return tlvElement;
        }
        return null;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (TlvElement tlvElement : this.elements) {
            try {
                byteArrayOutputStream.write(tlvElement.getEncoded());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public Iterator<TlvElement> iterator() {
        return this.elements.iterator();
    }
}

