/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SegmentListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventFocus;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.gtk.PangoRectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;

public class Combo
extends Composite {
    int buttonHandle;
    int entryHandle;
    int textRenderer;
    int cellHandle;
    int popupHandle;
    int menuHandle;
    int lastEventTime;
    int visibleCount = 10;
    int imContext;
    int gdkEventKey = 0;
    int fixStart = -1;
    int fixEnd = -1;
    String[] items = new String[0];
    boolean selectionAdded;
    int indexSelected;
    public static final int LIMIT = 65535;

    public Combo(Composite composite, int n) {
        super(composite, Combo.checkStyle(n));
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.add(string, this.items.length);
    }

    public void add(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n > this.items.length) {
            this.error(6);
        }
        String[] stringArray = new String[this.items.length + 1];
        System.arraycopy(this.items, 0, stringArray, 0, n);
        stringArray[n] = string;
        System.arraycopy(this.items, n, stringArray, n + 1, this.items.length - n);
        this.items = stringArray;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK3) {
            OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
        } else {
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
        }
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(modifyListener);
        this.addListener(24, typedListener);
    }

    public void addSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.addListener(49, new TypedListener(segmentListener));
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(verifyListener);
        this.addListener(25, typedListener);
    }

    static int checkStyle(int n) {
        n &= 0xFFFFF7FF;
        n &= 0xFFFFFCFF;
        if (((n = Combo.checkBits(n, 4, 64, 0, 0, 0, 0)) & 0x40) != 0) {
            return n & 0xFFFFFFF7;
        }
        return n;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clearSelection() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int n = OS.gtk_editable_get_position(this.entryHandle);
            OS.gtk_editable_select_region(this.entryHandle, n, n);
        }
    }

    void clearText() {
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
        if ((this.style & 8) != 0) {
            int n = OS.gtk_combo_box_get_active(this.handle);
            if (n != -1) {
                int n2 = OS.gtk_combo_box_get_model(this.handle);
                int[] nArray = new int[1];
                int n3 = OS.g_malloc(OS.GtkTreeIter_sizeof());
                OS.gtk_tree_model_iter_nth_child(n2, n3, 0, n);
                OS.gtk_tree_model_get(n2, n3, 0, nArray, -1);
                OS.g_free(n3);
                if (nArray[0] != 0 && OS.strlen(nArray[0]) > 0) {
                    this.postEvent(24);
                }
                OS.g_free(nArray[0]);
            }
        } else {
            OS.gtk_entry_set_text(this.entryHandle, new byte[1]);
        }
        OS.gtk_combo_box_set_active(this.handle, -1);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if ((this.style & 8) != 0 || OS.GTK3) {
            return this.computeNativeSize(this.handle, n, n2, bl);
        }
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_widget_realize(this.entryHandle);
        int n3 = OS.gtk_entry_get_layout(this.entryHandle);
        OS.pango_layout_get_pixel_size(n3, nArray, nArray2);
        int n4 = 2;
        int n5 = 2;
        Point point = this.getThickness(this.entryHandle);
        n4 += point.x;
        n5 += point.y;
        int[] nArray3 = new int[1];
        OS.gtk_widget_style_get(this.entryHandle, OS.interior_focus, nArray3, 0);
        if (nArray3[0] == 0) {
            OS.gtk_widget_style_get(this.entryHandle, OS.focus_line_width, nArray3, 0);
            n4 += nArray3[0];
            n5 += nArray3[0];
        }
        int n6 = nArray[0] + n4 * 2;
        int n7 = nArray2[0] + n5 * 2;
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_get_preferred_size(this.buttonHandle, gtkRequisition);
        GtkRequisition gtkRequisition2 = new GtkRequisition();
        int n8 = OS.gtk_bin_get_child(this.popupHandle);
        this.gtk_widget_get_preferred_size(n8, gtkRequisition2);
        n6 = Math.max(gtkRequisition2.width, n6) + gtkRequisition.width;
        n6 = n == -1 ? n6 : n;
        n7 = n2 == -1 ? n7 : n2;
        return new Point(n6, n7);
    }

    public void copy() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_copy_clipboard(this.entryHandle);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x28;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0);
        if (this.fixedHandle == 0) {
            this.error(2);
        }
        this.gtk_widget_set_has_window(this.fixedHandle, true);
        int n2 = OS.gtk_window_list_toplevels();
        if ((this.style & 8) != 0) {
            this.handle = OS.GTK3 ? OS.gtk_combo_box_text_new() : OS.gtk_combo_box_new_text();
            if (this.handle == 0) {
                this.error(2);
            }
            this.cellHandle = OS.gtk_bin_get_child(this.handle);
            if (this.cellHandle == 0) {
                this.error(2);
            }
            OS.gtk_combo_box_set_wrap_width(this.handle, 1);
        } else {
            this.handle = OS.GTK3 ? OS.gtk_combo_box_text_new_with_entry() : OS.gtk_combo_box_entry_new_text();
            if (this.handle == 0) {
                this.error(2);
            }
            this.entryHandle = OS.gtk_bin_get_child(this.handle);
            if (this.entryHandle == 0) {
                this.error(2);
            }
            if (OS.GTK3) {
                this.imContext = OS.imContextLast();
            }
        }
        this.popupHandle = this.findPopupHandle(n2);
        OS.gtk_container_add(this.fixedHandle, this.handle);
        this.textRenderer = OS.gtk_cell_renderer_text_new();
        if (this.textRenderer == 0) {
            this.error(2);
        }
        int n3 = 0;
        OS.g_object_set(this.textRenderer, OS.ypad, n3, 0);
        boolean bl = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.gtk_cell_layout_clear(this.handle);
        this.display.setWarnings(bl);
        OS.gtk_cell_layout_pack_start(this.handle, this.textRenderer, true);
        OS.gtk_cell_layout_set_attributes(this.handle, this.textRenderer, OS.text, 0, 0);
        this.menuHandle = this.findMenuHandle();
        if (this.menuHandle != 0) {
            OS.g_object_ref(this.menuHandle);
        }
        this.buttonHandle = this.findButtonHandle();
        if (this.buttonHandle != 0) {
            OS.g_object_ref(this.buttonHandle);
        }
        if ((this.style & 8) != 0 && this.buttonHandle != 0) {
            this.gtk_widget_set_receives_default(this.buttonHandle, false);
        }
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    public void cut() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_cut_clipboard(this.entryHandle);
        }
    }

    @Override
    void deregister() {
        int n;
        super.deregister();
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.entryHandle != 0) {
            this.display.removeWidget(this.entryHandle);
        }
        if (this.popupHandle != 0) {
            this.display.removeWidget(this.popupHandle);
        }
        if (this.menuHandle != 0) {
            this.display.removeWidget(this.menuHandle);
        }
        if ((n = this.imContext()) != 0) {
            this.display.removeWidget(n);
        }
    }

    @Override
    boolean filterKey(int n, int n2) {
        int n3 = OS.gdk_event_get_time(n2);
        if (n3 != this.lastEventTime) {
            this.lastEventTime = n3;
            int n4 = this.imContext();
            if (n4 != 0) {
                return OS.gtk_im_context_filter_keypress(n4, n2);
            }
        }
        this.gdkEventKey = n2;
        return false;
    }

    int findPopupHandle(int n) {
        int n2 = 0;
        int n3 = OS.gtk_window_list_toplevels();
        int n4 = n;
        int n5 = OS.g_list_last(n3);
        while (n5 != 0) {
            int n6 = OS.g_list_data(n5);
            boolean bl = false;
            n4 = n;
            while (n4 != 0) {
                int n7 = OS.g_list_data(n4);
                if (n6 == n7) {
                    bl = true;
                    break;
                }
                n4 = OS.g_list_next(n4);
            }
            if (!bl) {
                n2 = n6;
                break;
            }
            n5 = OS.g_list_previous(n5);
        }
        OS.g_list_free(n);
        OS.g_list_free(n3);
        return n2;
    }

    int findButtonHandle() {
        int n = 0;
        OS.gtk_container_forall(this.handle, this.display.allChildrenProc, 0);
        if (this.display.allChildren != 0) {
            int n2 = this.display.allChildren;
            while (n2 != 0) {
                int n3 = OS.g_list_data(n2);
                if (!OS.GTK_IS_BUTTON(n3)) continue;
                n = n3;
                break;
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0;
        }
        return n;
    }

    int findMenuHandle() {
        if (this.popupHandle == 0) {
            return 0;
        }
        int n = 0;
        OS.gtk_container_forall(this.popupHandle, this.display.allChildrenProc, 0);
        if (this.display.allChildren != 0) {
            int n2 = this.display.allChildren;
            while (n2 != 0) {
                int n3 = OS.g_list_data(n2);
                if (OS.G_OBJECT_TYPE(n3) == OS.GTK_TYPE_MENU()) {
                    n = n3;
                    break;
                }
                n2 = OS.g_list_next(n2);
            }
            OS.g_list_free(this.display.allChildren);
            this.display.allChildren = 0;
        }
        return n;
    }

    @Override
    void fixModal(int n, int n2) {
        if (this.popupHandle != 0) {
            if (n != 0) {
                OS.gtk_window_group_add_window(n, this.popupHandle);
            } else if (n2 != 0) {
                OS.gtk_window_group_remove_window(n2, this.popupHandle);
            }
        }
    }

    void fixIM() {
        int n;
        if (this.gdkEventKey != 0 && this.gdkEventKey != -1 && (n = this.imContext()) != 0) {
            OS.gtk_im_context_filter_keypress(n, this.gdkEventKey);
            this.gdkEventKey = -1;
            return;
        }
        this.gdkEventKey = 0;
    }

    @Override
    int fontHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.fontHandle();
    }

    @Override
    int focusHandle() {
        if (this.entryHandle != 0) {
            return this.entryHandle;
        }
        return super.focusHandle();
    }

    @Override
    boolean hasFocus() {
        if (super.hasFocus()) {
            return true;
        }
        return this.entryHandle != 0 && this.gtk_widget_has_focus(this.entryHandle);
    }

    @Override
    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.changed, this.display.getClosure(6), true);
        if (this.entryHandle != 0) {
            OS.g_signal_connect_closure(this.entryHandle, OS.changed, this.display.getClosure(6), true);
            OS.g_signal_connect_closure(this.entryHandle, OS.insert_text, this.display.getClosure(26), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.delete_text, this.display.getClosure(13), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.activate, this.display.getClosure(1), false);
            OS.g_signal_connect_closure(this.entryHandle, OS.populate_popup, this.display.getClosure(37), false);
        }
        this.hookEvents(new int[]{this.buttonHandle, this.entryHandle, this.menuHandle});
        int n = this.imContext();
        if (n != 0) {
            OS.g_signal_connect_closure(n, OS.commit, this.display.getClosure(9), false);
            int n2 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
            int n3 = 17;
            OS.g_signal_handlers_block_matched(n, n3, n2, 0, 0, 0, this.entryHandle);
        }
    }

    void hookEvents(int[] nArray) {
        int n = 772;
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (n2 == 0) continue;
            OS.gtk_widget_add_events(n2, n);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[2], 0, this.display.getClosure(2), false);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[4], 0, this.display.getClosure(4), false);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[33], 0, this.display.getClosure(33), false);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[2], 0, this.display.getClosure(3), true);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[4], 0, this.display.getClosure(5), true);
            OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[33], 0, this.display.getClosure(34), true);
            if (n2 != this.focusHandle()) {
                OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[16], 0, this.display.getClosure(16), false);
            }
            if (OS.G_OBJECT_TYPE(n2) != OS.GTK_TYPE_MENU()) continue;
            OS.g_signal_connect_closure(n2, OS.selection_done, this.display.getClosure(68), true);
        }
    }

    int imContext() {
        if (this.imContext != 0) {
            return this.imContext;
        }
        return this.entryHandle != 0 ? OS.GTK_ENTRY_IM_CONTEXT(this.entryHandle) : 0;
    }

    public void deselect(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        if (OS.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
    }

    public void deselectAll() {
        this.checkWidget();
        this.clearText();
    }

    @Override
    boolean dragDetect(int n, int n2, boolean bl, boolean bl2, boolean[] blArray) {
        if (bl && this.entryHandle != 0) {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int n3 = OS.gtk_entry_get_layout(this.entryHandle);
            OS.pango_layout_xy_to_index(n3, n * 1024, n2 * 1024, nArray, nArray2);
            int n4 = OS.pango_layout_get_text(n3);
            int n5 = OS.g_utf8_pointer_to_offset(n4, n4 + nArray[0]) + nArray2[0];
            int[] nArray3 = new int[1];
            int[] nArray4 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray3, nArray4);
            if (nArray3[0] <= n5 && n5 < nArray4[0] && super.dragDetect(n, n2, bl, bl2, blArray)) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return true;
            }
            return false;
        }
        return super.dragDetect(n, n2, bl, bl2, blArray);
    }

    @Override
    int enterExitHandle() {
        return this.fixedHandle;
    }

    @Override
    int eventWindow() {
        return this.paintWindow();
    }

    @Override
    GdkColor getBackgroundColor() {
        return this.getBaseColor();
    }

    public Point getCaretLocation() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return new Point(0, 0);
        }
        int n = OS.gtk_editable_get_position(this.entryHandle);
        n = OS.gtk_entry_text_index_to_layout_index(this.entryHandle, n);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_entry_get_layout_offsets(this.entryHandle, nArray, nArray2);
        int n2 = OS.gtk_entry_get_layout(this.entryHandle);
        PangoRectangle pangoRectangle = new PangoRectangle();
        OS.pango_layout_index_to_pos(n2, n, pangoRectangle);
        int n3 = nArray[0] + OS.PANGO_PIXELS(pangoRectangle.x) - this.getBorderWidth();
        int n4 = nArray2[0] + OS.PANGO_PIXELS(pangoRectangle.y);
        return new Point(n3, n4);
    }

    public int getCaretPosition() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return 0;
        }
        int n = OS.gtk_entry_get_text(this.entryHandle);
        return OS.g_utf8_offset_to_utf16_offset(n, OS.gtk_editable_get_position(this.entryHandle));
    }

    @Override
    GdkColor getForegroundColor() {
        return this.getTextColor();
    }

    public String getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.items.length;
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.fontHeight(this.getFontDescription(), this.handle);
    }

    public String[] getItems() {
        this.checkWidget();
        String[] stringArray = new String[this.items.length];
        System.arraycopy(this.items, 0, stringArray, 0, this.items.length);
        return stringArray;
    }

    public boolean getListVisible() {
        this.checkWidget();
        return this.popupHandle != 0 && this.gtk_widget_get_visible(this.popupHandle);
    }

    @Override
    String getNameText() {
        return this.getText();
    }

    @Override
    public int getOrientation() {
        return super.getOrientation();
    }

    public Point getSelection() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            int n = 0;
            int n2 = OS.gtk_combo_box_get_active(this.handle);
            if (n2 != -1) {
                n = this.getItem(n2).length();
            }
            return new Point(0, n);
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (this.entryHandle != 0) {
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray, nArray2);
            int n = OS.gtk_entry_get_text(this.entryHandle);
            nArray[0] = OS.g_utf8_offset_to_utf16_offset(n, nArray[0]);
            nArray2[0] = OS.g_utf8_offset_to_utf16_offset(n, nArray2[0]);
        }
        return new Point(nArray[0], nArray2[0]);
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return OS.gtk_combo_box_get_active(this.handle);
    }

    public String getText() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            int n = OS.gtk_entry_get_text(this.entryHandle);
            if (n == 0) {
                return "";
            }
            int n2 = OS.strlen(n);
            byte[] byArray = new byte[n2];
            OS.memmove(byArray, n, n2);
            return new String(Converter.mbcsToWcs(null, byArray));
        }
        int n = OS.gtk_combo_box_get_active(this.handle);
        return n != -1 ? this.getItem(n) : "";
    }

    String getText(int n, int n2) {
        return this.getText().substring(n, n2 - 1);
    }

    public int getTextHeight() {
        this.checkWidget();
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.gtk_widget_size_request(this.handle, gtkRequisition);
        if (OS.GTK3) {
            return gtkRequisition.height;
        }
        return OS.GTK_WIDGET_REQUISITION_HEIGHT(this.handle);
    }

    public int getTextLimit() {
        this.checkWidget();
        int n = this.entryHandle != 0 ? OS.gtk_entry_get_max_length(this.entryHandle) : 0;
        return n == 0 ? LIMIT : n;
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleCount;
    }

    @Override
    int gtk_activate(int n) {
        this.sendSelectionEvent(14);
        return 0;
    }

    @Override
    int gtk_button_press_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        if (gdkEventButton.type == 4 && gdkEventButton.button == 1) {
            return this.gtk_button_press_event(n, n2, false);
        }
        return super.gtk_button_press_event(n, n2);
    }

    @Override
    int gtk_changed(int n) {
        if (n == this.handle) {
            int n2;
            if (this.entryHandle == 0) {
                this.sendEvent(24);
                if (this.isDisposed()) {
                    return 0;
                }
            }
            if ((n2 = OS.gtk_combo_box_get_active(this.handle)) != -1) {
                this.sendSelectionEvent(13);
            }
            this.indexSelected = -1;
            return 0;
        }
        boolean bl = false;
        int n3 = OS.gtk_get_current_event();
        if (n3 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n3, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    bl = true;
                }
            }
            OS.gdk_event_free(n3);
        }
        if (bl) {
            this.postEvent(24);
        } else {
            this.sendEvent(24);
        }
        return 0;
    }

    @Override
    int gtk_commit(int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (!OS.gtk_editable_get_editable(this.entryHandle)) {
            return 0;
        }
        int n3 = OS.strlen(n2);
        if (n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, n3);
        char[] cArray = Converter.mbcsToWcs(null, byArray);
        char[] cArray2 = this.sendIMKeyEvent(1, null, cArray);
        if (cArray2 == null) {
            return 0;
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 9);
        int n4 = OS.g_signal_lookup(OS.commit, OS.gtk_im_context_get_type());
        int n5 = 17;
        OS.g_signal_handlers_unblock_matched(n, n5, n4, 0, 0, 0, this.entryHandle);
        if (cArray2 == cArray) {
            OS.g_signal_emit_by_name(n, OS.commit, n2);
        } else {
            byArray = Converter.wcsToMbcs(null, cArray2, true);
            OS.g_signal_emit_by_name(n, OS.commit, byArray);
        }
        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 9);
        OS.g_signal_handlers_block_matched(n, n5, n4, 0, 0, 0, this.entryHandle);
        if (this.fixStart != -1 && this.fixEnd != -1) {
            OS.gtk_editable_set_position(this.entryHandle, this.fixStart);
            OS.gtk_editable_select_region(this.entryHandle, this.fixStart, this.fixEnd);
        }
        this.fixEnd = -1;
        this.fixStart = -1;
        return 0;
    }

    @Override
    int gtk_delete_text(int n, int n2, int n3) {
        int n4;
        int n5;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        int n6 = OS.gtk_entry_get_text(this.entryHandle);
        if (n3 == -1) {
            n3 = OS.g_utf8_strlen(n6, -1);
        }
        if ((string = this.verifyText("", n5 = OS.g_utf8_offset_to_utf16_offset(n6, n2), n4 = OS.g_utf8_offset_to_utf16_offset(n6, n3))) == null) {
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.delete_text);
        } else if (string.length() > 0) {
            int[] nArray = new int[]{n3};
            byte[] byArray = Converter.wcsToMbcs(null, string, false);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.gtk_editable_insert_text(this.entryHandle, byArray, byArray.length, nArray);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
            OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
            OS.gtk_editable_set_position(this.entryHandle, nArray[0]);
        }
        return 0;
    }

    @Override
    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 1) break;
                if (!this.sendMouseEvent(3, gdkEventButton.button, this.display.clickCount, 0, false, gdkEventButton.time, gdkEventButton.x_root, gdkEventButton.y_root, false, gdkEventButton.state)) {
                    return 1;
                }
                if ((this.style & 8) != 0 || n != this.buttonHandle) break;
                OS.gtk_widget_grab_focus(this.entryHandle);
                break;
            }
            case 12: {
                if ((this.style & 8) != 0) break;
                GdkEventFocus gdkEventFocus = new GdkEventFocus();
                OS.memmove(gdkEventFocus, n2, GdkEventFocus.sizeof);
                if (gdkEventFocus.in != 0) {
                    OS.gtk_combo_box_set_focus_on_click(this.handle, false);
                    break;
                }
                OS.gtk_combo_box_set_focus_on_click(this.handle, true);
            }
        }
        return super.gtk_event_after(n, n2);
    }

    @Override
    int gtk_focus_out_event(int n, int n2) {
        this.fixIM();
        return super.gtk_focus_out_event(n, n2);
    }

    @Override
    int gtk_insert_text(int n, int n2, int n3, int n4) {
        int n5;
        String string;
        if (!this.hooks(25) && !this.filters(25)) {
            return 0;
        }
        if (n2 == 0 || n3 == 0) {
            return 0;
        }
        byte[] byArray = new byte[n3];
        OS.memmove(byArray, n2, byArray.length);
        String string2 = new String(Converter.mbcsToWcs(null, byArray));
        int[] nArray = new int[1];
        OS.memmove(nArray, n4, 4);
        int n6 = OS.gtk_entry_get_text(this.entryHandle);
        if (nArray[0] == -1) {
            nArray[0] = OS.g_utf8_strlen(n6, -1);
        }
        if ((string = this.verifyText(string2, n5 = OS.g_utf8_offset_to_utf16_offset(n6, nArray[0]), n5)) != string2) {
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            OS.gtk_editable_get_selection_bounds(this.entryHandle, nArray2, nArray3);
            if (string != null) {
                if (nArray2[0] != nArray3[0]) {
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                    OS.gtk_editable_delete_selection(this.entryHandle);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
                    OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
                }
                byte[] byArray2 = Converter.wcsToMbcs(null, string, false);
                OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                OS.gtk_editable_insert_text(this.entryHandle, byArray2, byArray2.length, nArray);
                OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
                nArray2[0] = nArray3[0] = nArray[0];
            }
            nArray[0] = nArray3[0];
            if (nArray2[0] != nArray3[0]) {
                this.fixStart = nArray2[0];
                this.fixEnd = nArray3[0];
            }
            OS.memmove(n4, nArray, 4);
            OS.g_signal_stop_emission_by_name(this.entryHandle, OS.insert_text);
        }
        return 0;
    }

    @Override
    int gtk_key_press_event(int n, int n2) {
        int n3 = super.gtk_key_press_event(n, n2);
        if (n3 != 0) {
            this.gdkEventKey = 0;
            this.fixIM();
            return n3;
        }
        if (this.gdkEventKey == -1) {
            n3 = 1;
        }
        this.gdkEventKey = 0;
        if ((this.style & 8) == 0) {
            int n4;
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n2, GdkEventKey.sizeof);
            int n5 = n4 = OS.gtk_combo_box_get_active(this.handle);
            int n6 = gdkEventKey.keyval;
            switch (n6) {
                case 65364: 
                case 65433: {
                    if (n4 == this.items.length - 1) break;
                    n5 = n4 + 1;
                    break;
                }
                case 65362: 
                case 65431: {
                    if (n4 == -1 || n4 == 0) break;
                    n5 = n4 - 1;
                    break;
                }
                case 65365: 
                case 65434: {
                    n5 = 0;
                    break;
                }
                case 65366: 
                case 65435: {
                    n5 = this.items.length - 1;
                }
            }
            if (n5 != n4) {
                OS.gtk_combo_box_set_active(this.handle, n5);
                return 1;
            }
        }
        return n3;
    }

    @Override
    int gtk_populate_popup(int n, int n2) {
        if ((this.style & 0x4000000) != 0) {
            OS.gtk_widget_set_direction(n2, 2);
            OS.gtk_container_forall(n2, this.display.setDirectionProc, 2);
        }
        return 0;
    }

    @Override
    int gtk_selection_done(int n) {
        int n2 = OS.gtk_combo_box_get_active(this.handle);
        if (this.indexSelected == -1) {
            this.indexSelected = n2;
        } else if (n2 != -1 && this.indexSelected == n2) {
            this.sendSelectionEvent(13);
        }
        return 0;
    }

    @Override
    int gtk_style_set(int n, int n2) {
        this.setButtonHandle(this.findButtonHandle());
        this.setMenuHandle(this.findMenuHandle());
        return super.gtk_style_set(n, n2);
    }

    public int indexOf(String string) {
        this.checkWidget();
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            return -1;
        }
        for (int i = n; i < this.items.length; ++i) {
            if (!string.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    boolean isFocusHandle(int n) {
        if (this.buttonHandle != 0 && n == this.buttonHandle) {
            return true;
        }
        if (this.entryHandle != 0 && n == this.entryHandle) {
            return true;
        }
        return super.isFocusHandle(n);
    }

    @Override
    int paintWindow() {
        int n = this.entryHandle != 0 ? this.entryHandle : this.handle;
        OS.gtk_widget_realize(n);
        int n2 = this.gtk_widget_get_window(n);
        if ((this.style & 8) != 0) {
            return n2;
        }
        int n3 = OS.gdk_window_get_children(n2);
        if (n3 != 0) {
            n2 = OS.g_list_data(n3);
        }
        OS.g_list_free(n3);
        return n2;
    }

    public void paste() {
        this.checkWidget();
        if (this.entryHandle != 0) {
            OS.gtk_editable_paste_clipboard(this.entryHandle);
        }
    }

    @Override
    int parentingHandle() {
        return this.fixedHandle;
    }

    @Override
    void register() {
        int n;
        super.register();
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.entryHandle != 0) {
            this.display.addWidget(this.entryHandle, this);
        }
        if (this.popupHandle != 0) {
            this.display.addWidget(this.popupHandle, this);
        }
        if (this.menuHandle != 0) {
            this.display.addWidget(this.menuHandle, this);
        }
        if ((n = this.imContext()) != 0) {
            this.display.addWidget(n, this);
        }
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        if (this.menuHandle != 0) {
            OS.g_object_unref(this.menuHandle);
        }
        if (this.buttonHandle != 0) {
            OS.g_object_unref(this.buttonHandle);
        }
        this.entryHandle = 0;
        this.buttonHandle = 0;
        this.menuHandle = 0;
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.textRenderer = 0;
        this.fixIM();
    }

    public void remove(int n) {
        this.checkWidget();
        if (0 > n || n >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray.length - n - 1);
        this.items = stringArray2;
        if (OS.gtk_combo_box_get_active(this.handle) == n) {
            this.clearText();
        }
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove(this.handle, n);
        } else {
            OS.gtk_combo_box_remove_text(this.handle, n);
        }
    }

    public void remove(int n, int n2) {
        this.checkWidget();
        if (n > n2) {
            return;
        }
        if (0 > n || n > n2 || n2 >= this.items.length) {
            this.error(6);
        }
        String[] stringArray = this.items;
        String[] stringArray2 = new String[stringArray.length - (n2 - n + 1)];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n2 + 1, stringArray2, n, stringArray.length - n2 - 1);
        this.items = stringArray2;
        int n3 = OS.gtk_combo_box_get_active(this.handle);
        if (n <= n3 && n3 <= n2) {
            this.clearText();
        }
        for (int i = n2; i >= n; --i) {
            if (OS.GTK3) {
                OS.gtk_combo_box_text_remove(this.handle, i);
                continue;
            }
            OS.gtk_combo_box_remove_text(this.handle, i);
        }
    }

    public void remove(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((n = this.indexOf(string, 0)) == -1) {
            this.error(5);
        }
        this.remove(n);
    }

    public void removeAll() {
        this.checkWidget();
        int n = this.items.length;
        this.items = new String[0];
        this.clearText();
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove_all(this.handle);
        } else {
            for (int i = n - 1; i >= 0; --i) {
                OS.gtk_combo_box_remove_text(this.handle, i);
            }
        }
    }

    public void removeModifyListener(ModifyListener modifyListener) {
        this.checkWidget();
        if (modifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, modifyListener);
    }

    public void removeSegmentListener(SegmentListener segmentListener) {
        this.checkWidget();
        if (segmentListener == null) {
            this.error(4);
        }
        this.eventTable.unhook(49, segmentListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void removeVerifyListener(VerifyListener verifyListener) {
        this.checkWidget();
        if (verifyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, verifyListener);
    }

    public void select(int n) {
        this.checkWidget();
        if (n < 0 || n >= this.items.length) {
            return;
        }
        int n2 = OS.gtk_combo_box_get_active(this.handle);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
        OS.gtk_combo_box_set_active(this.handle, n);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        if ((this.style & 8) != 0 && n2 != n) {
            this.sendEvent(24);
        }
    }

    @Override
    void setBackgroundColor(int n, int n2, GdkRGBA gdkRGBA) {
        if (this.entryHandle == 0 || (this.style & 8) != 0) {
            super.setBackgroundColor(n, n2, gdkRGBA);
            return;
        }
        this.setBackgroundColorGradient(OS.gtk_widget_get_style_context(this.entryHandle), n2, gdkRGBA);
    }

    @Override
    void setBackgroundColor(GdkColor gdkColor) {
        super.setBackgroundColor(gdkColor);
        if (!OS.GTK3) {
            if (this.entryHandle != 0) {
                OS.gtk_widget_modify_base(this.entryHandle, 0, gdkColor);
            }
            if (this.cellHandle != 0) {
                OS.g_object_set(this.cellHandle, OS.background_gdk, gdkColor, 0);
            }
            OS.g_object_set(this.textRenderer, OS.background_gdk, gdkColor, 0);
        }
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        int n5 = n4;
        if (bl2) {
            n5 = Math.max(this.getTextHeight(), n4);
        }
        return super.setBounds(n, n2, n3, n5, bl, bl2);
    }

    void setButtonHandle(int n) {
        if (this.buttonHandle == n) {
            return;
        }
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
            OS.g_object_unref(this.buttonHandle);
        }
        this.buttonHandle = n;
        if (this.buttonHandle != 0) {
            OS.g_object_ref(this.buttonHandle);
            this.display.addWidget(this.buttonHandle, this);
            this.hookEvents(new int[]{this.buttonHandle});
        }
    }

    void setMenuHandle(int n) {
        if (this.menuHandle == n) {
            return;
        }
        if (this.menuHandle != 0) {
            this.display.removeWidget(this.menuHandle);
            OS.g_object_unref(this.menuHandle);
        }
        this.menuHandle = n;
        if (this.menuHandle != 0) {
            OS.g_object_ref(this.menuHandle);
            this.display.addWidget(this.menuHandle, this);
            this.hookEvents(new int[]{this.menuHandle});
        }
    }

    @Override
    void setFontDescription(int n) {
        super.setFontDescription(n);
        if (this.entryHandle != 0) {
            this.setFontDescription(this.entryHandle, n);
        }
        OS.g_object_set(this.textRenderer, OS.font_desc, n, 0);
        if ((this.style & 8) != 0) {
            int n2 = OS.gtk_combo_box_get_active(this.handle);
            OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
            OS.gtk_combo_box_set_active(this.handle, -1);
            OS.gtk_combo_box_set_active(this.handle, n2);
            OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        }
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(this.handle, gdkColor, false);
        if (this.entryHandle != 0) {
            this.setForegroundColor(this.entryHandle, gdkColor, false);
        }
        OS.g_object_set(this.textRenderer, OS.foreground_gdk, gdkColor, 0);
    }

    public void setItem(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (0 > n || n >= this.items.length) {
            this.error(5);
        }
        this.items[n] = string;
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove(this.handle, n);
            OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
        } else {
            OS.gtk_combo_box_remove_text(this.handle, n);
            OS.gtk_combo_box_insert_text(this.handle, n, byArray);
        }
        if ((this.style & 0x4000000) != 0 && this.popupHandle != 0) {
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
        }
    }

    public void setItems(String[] stringArray) {
        int n;
        int n2;
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (stringArray[n2] != null) continue;
            this.error(5);
        }
        n2 = this.items.length;
        this.items = new String[stringArray.length];
        System.arraycopy(stringArray, 0, this.items, 0, stringArray.length);
        this.clearText();
        if (OS.GTK3) {
            OS.gtk_combo_box_text_remove_all(this.handle);
        } else {
            for (n = n2 - 1; n >= 0; --n) {
                OS.gtk_combo_box_remove_text(this.handle, n);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            byte[] byArray = Converter.wcsToMbcs(null, string, true);
            if (OS.GTK3) {
                OS.gtk_combo_box_text_insert(this.handle, n, null, byArray);
            } else {
                OS.gtk_combo_box_insert_text(this.handle, n, byArray);
            }
            if ((this.style & 0x4000000) == 0 || this.popupHandle == 0) continue;
            OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, 2);
        }
    }

    public void setListVisible(boolean bl) {
        this.checkWidget();
        if (bl) {
            OS.gtk_combo_box_popup(this.handle);
        } else {
            OS.gtk_combo_box_popdown(this.handle);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        if ((this.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.style & 0x4000000) != 0 ? 2 : 1;
            if (this.entryHandle != 0) {
                OS.gtk_widget_set_direction(this.entryHandle, n);
            }
            if (this.cellHandle != 0) {
                OS.gtk_widget_set_direction(this.cellHandle, n);
            }
            if (!bl && this.popupHandle != 0) {
                OS.gtk_container_forall(this.popupHandle, this.display.setDirectionProc, n);
            }
        }
    }

    @Override
    public void setOrientation(int n) {
        super.setOrientation(n);
    }

    public void setSelection(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            return;
        }
        if (this.entryHandle != 0) {
            int n = OS.gtk_entry_get_text(this.entryHandle);
            int n2 = OS.g_utf16_offset_to_utf8_offset(n, point.x);
            int n3 = OS.g_utf16_offset_to_utf8_offset(n, point.y);
            OS.gtk_editable_set_position(this.entryHandle, n2);
            OS.gtk_editable_select_region(this.entryHandle, n2, n3);
        }
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 8) != 0) {
            int n2 = this.indexOf(string);
            if (n2 == -1) {
                return;
            }
            this.select(n2);
            return;
        }
        if ((this.hooks(25) || this.filters(25)) && (string = this.verifyText(string, 0, OS.g_utf16_strlen(n = OS.gtk_entry_get_text(this.entryHandle), -1))) == null) {
            return;
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_block_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        OS.gtk_entry_set_text(this.entryHandle, byArray);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 6);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 13);
        OS.g_signal_handlers_unblock_matched(this.entryHandle, 16, 0, 0, 0, 0, 26);
        this.sendEvent(24);
    }

    public void setTextLimit(int n) {
        this.checkWidget();
        if (n == 0) {
            this.error(7);
        }
        if (this.entryHandle != 0) {
            OS.gtk_entry_set_max_length(this.entryHandle, n);
        }
    }

    @Override
    void setToolTipText(Shell shell, String string) {
        if (this.entryHandle != 0) {
            shell.setToolTipText(this.entryHandle, string);
        }
        if (this.buttonHandle != 0) {
            shell.setToolTipText(this.buttonHandle, string);
        }
    }

    public void setVisibleItemCount(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.visibleCount = n;
    }

    @Override
    boolean checkSubwindow() {
        return false;
    }

    @Override
    boolean translateTraversal(GdkEventKey gdkEventKey) {
        int n = gdkEventKey.keyval;
        switch (n) {
            case 65293: 
            case 65421: {
                int n2 = this.imContext();
                if (n2 == 0) break;
                int[] nArray = new int[1];
                OS.gtk_im_context_get_preedit_string(n2, nArray, null, null);
                if (nArray[0] == 0) break;
                int n3 = OS.strlen(nArray[0]);
                OS.g_free(nArray[0]);
                if (n3 == 0) break;
                return false;
            }
        }
        return super.translateTraversal(gdkEventKey);
    }

    String verifyText(String string, int n, int n2) {
        if (string.length() == 0 && n == n2) {
            return null;
        }
        Event event = new Event();
        event.text = string;
        event.start = n;
        event.end = n2;
        int n3 = OS.gtk_get_current_event();
        if (n3 != 0) {
            GdkEventKey gdkEventKey = new GdkEventKey();
            OS.memmove(gdkEventKey, n3, GdkEventKey.sizeof);
            switch (gdkEventKey.type) {
                case 8: {
                    this.setKeyState(event, gdkEventKey);
                }
            }
            OS.gdk_event_free(n3);
        }
        this.sendEvent(25, event);
        if (!event.doit || this.isDisposed()) {
            return null;
        }
        return event.text;
    }
}

