/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.jmolpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.Logger;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolResourceHandler;

class AboutDialog
extends JDialog
implements HyperlinkListener {
    protected JEditorPane html;
    protected URL aboutURL;
    private JmolViewer vwr;
    private JScrollPane scroller;

    AboutDialog(JFrame jFrame, JmolViewer jmolViewer) {
        super(jFrame, GT._("About Jmol"), true);
        this.vwr = jmolViewer;
        try {
            this.aboutURL = this.getClass().getClassLoader().getResource(JmolResourceHandler.getStringX("About.aboutURL"));
            if (this.aboutURL != null) {
                this.html = new JEditorPane();
                this.html.setContentType("text/html");
                this.html.setText(GuiMap.getResourceString(this, this.aboutURL.getPath()));
            } else {
                this.html = new JEditorPane("text/plain", GT.o(GT._("Unable to find url \"{0}\"."), JmolResourceHandler.getStringX("About.aboutURL")));
            }
            this.html.setEditable(false);
            this.html.addHyperlinkListener(this);
        }
        catch (MalformedURLException malformedURLException) {
            Logger.warn("Malformed URL: " + malformedURLException);
        }
        catch (IOException iOException) {
            Logger.warn("IOException: " + iOException);
        }
        this.scroller = new JScrollPane(){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(500, 400);
            }

            @Override
            public float getAlignmentX() {
                return 0.0f;
            }
        };
        this.scroller.getViewport().add(this.html);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setAlignmentX(0.0f);
        jPanel.add((Component)this.scroller, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        jPanel2.add((Component)jPanel, "Center");
        this.getContentPane().add(jPanel2);
        this.pack();
        Dimension dimension = this.getToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        dimension.height /= 2;
        dimension.width /= 2;
        dimension2.height /= 2;
        dimension2.width /= 2;
        int n = dimension.height - dimension2.height;
        int n2 = dimension.width - dimension2.width;
        this.setLocation(n2, n);
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.linkActivated(hyperlinkEvent.getURL());
        }
    }

    protected void linkActivated(URL uRL) {
        this.vwr.showUrl(uRL.toString());
    }
}

