/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import javajs.util.P3;
import javajs.util.PT;
import javajs.util.T3;
import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;

public class XmlOdysseyReader
extends XmlReader {
    private String modelName = null;
    private String formula = null;
    private String phase = null;
    private String[] myAttributes = new String[]{"id", "label", "xyz", "element", "hybrid", "a", "b", "order", "charge", "entity", "box"};
    private int formalCharge = Integer.MIN_VALUE;

    @Override
    protected String[] getDOMAttributes() {
        return this.myAttributes;
    }

    @Override
    protected void processStartElement(String string) {
        if ("structure".equals(string)) {
            this.asc.newAtomSet();
            return;
        }
        if ("atom".equals(string)) {
            String string2 = (String)this.atts.get("id");
            this.atom = new Atom();
            new Atom().atomName = (String)this.atts.get(this.atts.containsKey("label") ? "label" : "id");
            if (string2 != null && this.stateScriptVersionInt >= 140400) {
                this.asc.atomSymbolicMap.put(string2, this.atom);
            }
            if (this.atts.containsKey("xyz")) {
                String string3 = (String)this.atts.get("xyz");
                String[] stringArray = PT.getTokens((String)string3);
                this.atom.set(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            }
            if (this.atts.containsKey("element")) {
                this.atom.elementSymbol = (String)this.atts.get("element");
            }
            return;
        }
        if ("bond".equals(string)) {
            String string4 = (String)this.atts.get("a");
            String string5 = (String)this.atts.get("b");
            int n = 1;
            if (this.atts.containsKey("order")) {
                n = this.parseBondToken((String)this.atts.get("order"));
            }
            this.asc.addNewBondFromNames(string4, string5, n);
            return;
        }
        if ("group".equals(string)) {
            String string6 = (String)this.atts.get("charge");
            if (string6 != null && string6.indexOf(".") < 0) {
                this.formalCharge = PT.parseInt((String)string6);
            }
            return;
        }
        if ("member".equals(string) && this.formalCharge != Integer.MIN_VALUE) {
            Atom atom = this.asc.getAtomFromName((String)this.atts.get("entity"));
            if (atom != null) {
                atom.formalCharge = this.formalCharge;
            }
            return;
        }
        if ("boundary".equals(string)) {
            String[] stringArray = PT.getTokens((String)((String)this.atts.get("box")));
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.parent.setUnitCellItem(0, f);
            this.parent.setUnitCellItem(1, f2);
            this.parent.setUnitCellItem(2, f3);
            this.parent.setUnitCellItem(3, 90.0f);
            this.parent.setUnitCellItem(4, 90.0f);
            this.parent.setUnitCellItem(5, 90.0f);
            P3 p3 = P3.new3((float)(-f / 2.0f), (float)(-f2 / 2.0f), (float)(-f3 / 2.0f));
            this.asc.setCurrentModelInfo("periodicOriginXyz", (Object)p3);
            Atom[] atomArray = this.asc.atoms;
            int n = this.asc.ac;
            while (--n >= 0) {
                atomArray[n].sub((T3)p3);
                this.parent.setAtomCoord(atomArray[n]);
            }
            if (this.parent.latticeCells[0] == 0) {
                this.parent.latticeCells[2] = 1;
                this.parent.latticeCells[1] = 1;
                this.parent.latticeCells[0] = 1;
            }
            this.parent.setSymmetryOperator("x,y,z");
            this.parent.setSpaceGroupName("P1");
            this.parent.applySymmetryAndSetTrajectory();
            return;
        }
        if ("odyssey_simulation".equals(string)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.asc.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.asc.setCurrentModelInfo("formula", (Object)this.formula);
            }
        }
        if ("title".equals(string) || "formula".equals(string) || "phase".equals(string)) {
            this.keepChars = true;
        }
    }

    private int parseBondToken(String string) {
        if (string.length() >= 1) {
            switch (string.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 515;
                }
            }
            return this.parseIntStr(string);
        }
        return 1;
    }

    @Override
    void processEndElement(String string) {
        if ("atom".equals(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.asc.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        if ("group".equals(string)) {
            this.formalCharge = Integer.MIN_VALUE;
        } else if ("title".equals(string)) {
            this.modelName = this.chars;
        } else if ("formula".equals(string)) {
            this.formula = this.chars;
        } else if ("phase".equals(string)) {
            this.phase = this.chars;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

