/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.LineBorder;
import org.jmol.c.CBK;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.nbo.NBODialogSearch;
import org.openscience.jmol.app.nbo.NBOPanel;
import org.openscience.jmol.app.nbo.NBOService;

public class NBODialog
extends NBODialogSearch {
    private JTextField jtRawInput;
    protected boolean isSet;

    public NBODialog(JFrame jFrame, Viewer viewer, NBOService nBOService) {
        super(jFrame);
        this.vwr = viewer;
        this.nboService = nBOService;
        nBOService.nboDialog = this;
        this.createDialog(685, jFrame.getHeight());
    }

    private void createDialog(int n, int n2) {
        this.haveService = this.nboService.serverPath.length() > 0;
        this.setSize(new Dimension(n, n2));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                NBODialog.this.close();
            }
        });
        final NBODialog nBODialog = this;
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                if (!NBODialog.this.isSet) {
                    NBODialog.this.centerDialog(nBODialog);
                }
                NBODialog.this.isSet = true;
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        this.topPanel = null;
        this.modelButton = this.getMainButton("nbomodel_logo.gif", 'm');
        this.mainButtons = new JButton[]{this.modelButton, this.viewButton = this.getMainButton("nboview_logo.gif", 'v'), this.runButton = this.getMainButton("nborun_logo.gif", 'r'), this.searchButton = this.getMainButton("nbosearch_logo.gif", 's')};
        this.browse = new JButton("Browse");
        this.checkEnabled();
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                switch (NBODialog.this.dialogMode) {
                    case 10: {
                        NBODialog.this.showWorkpathDialogM(null, null);
                        break;
                    }
                    case 20: {
                        NBODialog.this.showWorkpathDialogR(NBODialog.this.workingPath);
                        break;
                    }
                    case 30: {
                        NBODialog.this.showWorkpathDialogV(NBODialog.this.workingPath);
                        break;
                    }
                    case 40: {
                        NBODialog.this.showWorkpathDialogS(NBODialog.this.workingPath);
                    }
                }
            }
        });
        this.helpBtn = new JButton("Help");
        this.helpBtn.setFocusable(false);
        this.helpBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.showHelp(null);
            }
        });
        this.jtRawInput = new JTextField();
        this.jtRawInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.rawInput();
            }
        });
        this.statusPanel = this.buildStatusPanel();
        if (this.haveService) {
            this.connect();
        }
    }

    private JButton getMainButton(String string, final char c) {
        JButton jButton = new JButton();
        jButton.setBorder(null);
        jButton.setMargin(new Insets(4, 4, 4, 4));
        jButton.setContentAreaFilled(false);
        jButton.setIcon(new ImageIcon(this.getClass().getResource(string)));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialog.this.openPanel(c);
            }
        });
        return jButton;
    }

    private NBOPanel buildStatusPanel() {
        NBOPanel nBOPanel = new NBOPanel(this, 7);
        nBOPanel.setLayout(new BoxLayout(nBOPanel, 0));
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("NBO Input: "));
        box.add(this.jtRawInput);
        box.add(this.statusLab);
        box.add(this.helpBtn);
        nBOPanel.add(box);
        return nBOPanel;
    }

    protected void close() {
        this.saveHistory();
        this.nboService.closeProcess();
        this.nboResetV();
        this.nboService.runScriptQueued("mo delete; nbo delete; select off");
        this.dispose();
    }

    private boolean checkEnabled() {
        this.haveService = this.nboService.serverPath.length() > 0;
        boolean bl = this.haveService && this.nboService.restartIfNecessary();
        int n = this.mainButtons.length;
        while (--n >= 0) {
            this.mainButtons[n].setEnabled(bl);
        }
        if (!bl) {
            this.dialogMode = 0;
        }
        return bl;
    }

    @Override
    protected boolean connect() {
        boolean bl;
        String string;
        String string2 = System.getenv("PROCESSOR_ARCHITECTURE");
        String string3 = System.getenv("PROCESSOR_ARCHITEW6432");
        String string4 = string = string2.endsWith("64") || string3 != null && string3.endsWith("64") ? "64" : "32";
        if (string.equals("64")) {
            // empty if block
        }
        this.appendOutputWithCaret((bl = this.checkEnabled()) ? "NBOServe successfully connected" : "Could not connect");
        return bl;
    }

    public void openPanel(char c) {
        switch (this.dialogMode) {
            case 0: 
            case 10: 
            case 20: {
                break;
            }
            case 30: 
            case 40: {
                this.nboService.runScriptQueued("mo delete; nbo delete; select off");
            }
        }
        this.isJmolNBO = this.checkJmolNBO();
        if (!this.checkEnabled()) {
            c = (char)99;
        }
        int n = this.mainButtons.length;
        while (--n >= 0) {
            this.mainButtons[n].setBorder(null);
        }
        switch (c) {
            case 'c': {
                this.dialogMode = 0;
                this.buildConfig(this.getContentPane());
                break;
            }
            case 'm': {
                this.dialogMode = 10;
                this.setThis(this.modelButton);
                this.buildModel(this.getContentPane());
                break;
            }
            case 'r': {
                this.dialogMode = 20;
                this.setThis(this.runButton);
                this.buildRun(this.getContentPane());
                break;
            }
            case 'v': {
                this.dialogMode = 30;
                this.setThis(this.viewButton);
                this.buildView(this.getContentPane());
                break;
            }
            case 's': {
                this.dialogMode = 40;
                this.setThis(this.searchButton);
                this.buildSearch(this.getContentPane());
            }
        }
        this.setComponents(this);
        this.invalidate();
        this.setVisible(true);
        this.centerDialog(this);
        this.connect();
    }

    private void setThis(JButton jButton) {
        jButton.setEnabled(false);
        jButton.setBorder(new LineBorder(Color.WHITE, 2));
        this.invalidate();
    }

    protected void rawInput() {
        String string = this.jtRawInput.getText();
        String string2 = string.trim().toUpperCase();
        switch (this.dialogMode) {
            case 10: {
                if (string2.startsWith("HELP")) {
                    this.showHelp(string2.indexOf(" ") >= 0 ? string2.split(" ")[1].toLowerCase() : "");
                    break;
                }
                this.rawInputM(string);
                break;
            }
            case 20: {
                break;
            }
            case 30: {
                this.rawInputV(string2);
                break;
            }
            case 40: {
                this.rawInputS(string2);
            }
        }
        this.jtRawInput.setText("");
    }

    public void notifyCallback(CBK cBK, Object[] objectArray) {
        block0 : switch (cBK) {
            case STRUCTUREMODIFIED: {
                if (this.dialogMode != 10) break;
                this.loadModel();
                break;
            }
            case PICK: {
                int n = (Integer)objectArray[2];
                if (n < 0) break;
                String string = "" + (n + 1);
                switch (this.dialogMode) {
                    case 10: {
                        this.notifyCallbackM(string);
                        break block0;
                    }
                    case 30: {
                        this.notifyCallbackV(string);
                        break block0;
                    }
                    case 40: {
                        this.notifyCallbackS(n);
                    }
                }
            }
        }
    }

    void alert(String string) {
        try {
            switch (this.dialogMode) {
                case 10: {
                    this.appendOutputWithCaret(string);
                    return;
                }
            }
        }
        catch (Exception exception) {
            this.vwr.alert(string);
        }
    }

    protected void showHelp(String string) {
        JDialog jDialog = new JDialog((Dialog)this, "NBO Help");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditable(false);
        jTextPane.setFont(new Font("Arial", 0, 16));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(jTextPane);
        jDialog.add(jScrollPane);
        jDialog.setSize(new Dimension(400, 400));
        switch (this.dialogMode) {
            case 0: {
                jTextPane.setText(this.getHelp("config"));
                break;
            }
            case 10: {
                if (this.helpDialogM(jTextPane, string)) break;
                return;
            }
            case 20: {
                jTextPane.setText(this.getHelp("run"));
                break;
            }
            case 30: {
                jTextPane.setText(this.getHelp("view"));
                break;
            }
            case 40: {
                jTextPane.setText("             NBOSearch: COMMAND SYNTAX AND PROGRAM OVERVIEW\nPROGRAM OVERVIEW:\nFollow menu prompts through the decision tree to the keyword module and datum of interest. Each menu appears with 'Current [V-list] settings' and a scrolling list of output values. All output lines are also echoed to an external NBOLOG$$.DAT file and error messages go to NBOERR$$.DAT for later reference.\n\nGENERAL 'M V n' COMMAND SYNTAX:\nNBOSearch user responses generally consist of 'commands' \n(replies to prompts)\nof the form 'M (V (n))', where\n   M (integer)   = [M]enu selection from displayed items\n   V (character) = [V]ariable data type to be selected\n                   [J](obname)\n                   [B](asis)\n                   [O](rbital number)\n                   [A](tom number, in context)\n                   [U](nit number)\n                   [d](onor NBO number)\n                   [a](cceptor NBO number, in context)\n   n (integer)   = [n]umber of the desired O/A/U/d/a selection\nResponses may also be of simple 'M', 'V', or 'Vn' form , where\n  'M' : selects a numbered menu choice (for current [V] choices)\n  'V' : requests a menu of [V] choices\n  'Vn': selects [V] number 'n' (and current [S])\nNote that [V]-input is case-insensitive, so 'A' (or 'a') is interpreted as 'atom' or 'acceptor' according to context.  Note also that 'Vn' commands can be\ngiven in separated 'V n' form. Although not explicitly included in each active [V]-select list, the 'H'(elp) key is recognized at each prompt.  For NRT search (only), variable [V] may also be 'R' (for 'resonance structure' and A' (for 'interacting atom'). Current A (atom)  and A' (interacting atom) values determine the current A-A' 'bond' selection small fractional bond order.)\n\nEXAMPLES:\n  '2 a7'  : requests menu item 2 for atom 7 (if A-select active)\n  '3 o2'  : requests menu item 3 for orbital 2 \n");
            }
        }
        jTextPane.setCaretPosition(0);
        this.centerDialog(jDialog);
        jDialog.setVisible(true);
    }

    public void addLine(int n, String string) {
        switch (n) {
            case 0: {
                this.reqInfo = string;
                break;
            }
            case 10: {
                this.appendOutputWithCaret(string);
                break;
            }
            case 30: {
                string = string.trim();
                while (string.length() % 20 != 0) {
                    string = string + " ";
                }
            }
            case 40: {
                this.reqInfo = this.reqInfo + string;
                break;
            }
            case -1: {
                if (this.reqInfo.trim().split(" ").length > this.jmolAtomCount) break;
                this.reqInfo = this.reqInfo + string + " ";
            }
        }
    }

    public void setStatus(String string) {
        this.statusLab.setText(string);
    }
}

