/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.exception.JSVException;
import org.jmol.util.Logger;

public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    public static Map<String, String> htCorrelationCache;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static String nciResolver;
    private static String nmrdbServer;
    private static int stringCount;

    static {
        jsDocumentBase = "";
        htCorrelationCache = new Hashtable<String, String>();
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        nciResolver = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf&get3d=True";
        nmrdbServer = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
    }

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String name) {
        if (name == null) {
            return null;
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name, null);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.appendC('\n');
            }
            br.close();
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream in) {
        try {
            return new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForData(Object data) {
        return data == null ? null : new BufferedReader(new StringReader(data instanceof String ? (String)data : new String((byte[])data)));
    }

    public static BufferedReader getBufferedReaderFromName(String name, String startCode) throws JSVException {
        if (name == null) {
            throw new JSVException("Cannot find " + name);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + name);
        String path = JSVFileManager.getFullPathName(name);
        if (!path.equals(name)) {
            Logger.info("JSVFileManager getBufferedReaderFromName " + path);
        }
        return JSVFileManager.getUnzippedBufferedReaderFromName(path, startCode);
    }

    public static String getFullPathName(String name) throws JSVException {
        try {
            if (appletDocumentBase == null) {
                if (JSVFileManager.isURL(name)) {
                    URL url = new URL(null, name, null);
                    return url.toString();
                }
                return JSVFileManager.viewer.apiPlatform.newFile(name).getFullPath();
            }
            if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
                name = "file:///" + name;
            } else if (name.startsWith("cache://")) {
                return name;
            }
            URL url = new URL(appletDocumentBase, name, null);
            return url.toString();
        }
        catch (Exception e) {
            throw new JSVException("Cannot create path for " + name);
        }
    }

    public static boolean isURL(String name) {
        int i = urlPrefixes.length;
        while (--i >= 0) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String name) {
        int i = 0;
        while (i < urlPrefixes.length) {
            if (name.startsWith(urlPrefixes[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isLocal(String fileName) {
        if (fileName == null) {
            return false;
        }
        int itype = JSVFileManager.urlTypeIndex(fileName);
        return itype < 0 || itype == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String name, String startCode) throws JSVException {
        String[] subFileList = null;
        if (name.indexOf("|") >= 0 && (subFileList = PT.split(name, "|")) != null && subFileList.length > 0) {
            name = subFileList[0];
        }
        if (name.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getSimulationReader(name);
        }
        try {
            BufferedInputStream bis;
            InputStream ret = JSVFileManager.getInputStream(name, true, null);
            if (ret instanceof SB || ret instanceof String) {
                return new BufferedReader(new StringReader(ret.toString()));
            }
            if (JSVFileManager.isAB(ret)) {
                return new BufferedReader(new StringReader(new String((byte[])ret)));
            }
            InputStream in = bis = new BufferedInputStream(ret);
            if (JSVFileManager.isZipFile(bis)) {
                return ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newJSVZipFileSequentialReader(in, subFileList, startCode);
            }
            if (JSVFileManager.isGzip(bis)) {
                in = ((JSVZipInterface)JSViewer.getInterface("jspecview.common.JSVZipUtil")).newGZIPInputStream(in);
            }
            return new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (Exception e) {
            throw new JSVException("Cannot read file " + name + " " + e);
        }
    }

    public static String getAbbrSimulationFileName(String name) {
        String data;
        String filename = JSVFileManager.getAbbreviatedSimulationName(name, true);
        if (name.indexOf("MOL=") >= 0 && (data = htCorrelationCache.get(name)) != null) {
            htCorrelationCache.put(filename, data);
        }
        return filename;
    }

    static String getAbbreviatedSimulationName(String name, boolean addProtocol) {
        return name.indexOf("MOL=") >= 0 ? String.valueOf(addProtocol ? SIMULATION_PROTOCOL : "") + "MOL=" + JSVFileManager.getSimulationHash(name) : name;
    }

    private static String getSimulationHash(String name) {
        return "" + Math.abs(name.substring(name.indexOf("V2000") + 1).hashCode());
    }

    public static String getSimulationFileData(String name) {
        return htCorrelationCache.get(name.startsWith("MOL=") ? name.substring(4) : JSVFileManager.getAbbreviatedSimulationName(name, false));
    }

    private static BufferedReader getSimulationReader(String name) {
        String data = htCorrelationCache.get(name);
        if (data == null && (data = JSVFileManager.getNMRSimulationJCampDX(name.substring(SIMULATION_PROTOCOL.length()))) != null) {
            htCorrelationCache.put(name, data);
        }
        return JSVFileManager.getBufferedReaderForData(data);
    }

    public static boolean isAB(Object x) {
        return x instanceof byte[];
    }

    public static boolean isZipFile(InputStream is) throws JSVException {
        try {
            byte[] abMagic = new byte[4];
            is.mark(5);
            int countRead = is.read(abMagic, 0, 4);
            is.reset();
            return countRead == 4 && abMagic[0] == 80 && abMagic[1] == 75 && abMagic[2] == 3 && abMagic[3] == 4;
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    private static boolean isGzip(InputStream is) throws JSVException {
        try {
            byte[] abMagic = new byte[4];
            is.mark(5);
            int countRead = is.read(abMagic, 0, 4);
            is.reset();
            return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    public static Object getStreamAsBytes(BufferedInputStream bis, OC out) throws JSVException {
        try {
            byte[] buf = new byte[1024];
            byte[] bytes = out == null ? new byte[4096] : null;
            int len = 0;
            int totalLen = 0;
            while ((len = bis.read(buf, 0, 1024)) > 0) {
                totalLen += len;
                if (out == null) {
                    if (totalLen >= bytes.length) {
                        bytes = AU.ensureLengthByte(bytes, totalLen * 2);
                    }
                    System.arraycopy(buf, 0, bytes, totalLen - len, len);
                    continue;
                }
                out.write(buf, 0, len);
            }
            bis.close();
            if (out == null) {
                return AU.arrayCopyByte(bytes, totalLen);
            }
            return String.valueOf(totalLen) + " bytes";
        }
        catch (Exception e) {
            throw new JSVException(e.toString());
        }
    }

    public static String postByteArray(String fileName, byte[] bytes) {
        Object ret = null;
        try {
            ret = JSVFileManager.getInputStream(fileName, false, bytes);
        }
        catch (Exception e) {
            ret = e.toString();
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        try {
            ret = JSVFileManager.getStreamAsBytes((BufferedInputStream)ret, null);
        }
        catch (JSVException e) {
            try {
                ((BufferedInputStream)ret).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret == null ? "" : JSVFileManager.fixUTF((byte[])ret);
    }

    private static Encoding getUTFEncoding(byte[] bytes) {
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return Encoding.UTF8;
        }
        if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (bytes.length >= 4 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] bytes) {
        Encoding encoding = JSVFileManager.getUTFEncoding(bytes);
        if (encoding != Encoding.NONE) {
            try {
                String s = new String(bytes, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        s = s.substring(1);
                        break;
                    }
                }
                return s;
            }
            catch (IOException e) {
                Logger.error("fixUTF error " + e);
            }
        }
        return new String(bytes);
    }

    public static InputStream getInputStream(String name, boolean showMsg, byte[] postBytes) throws JSVException {
        int iurl;
        boolean isURL = JSVFileManager.isURL(name);
        boolean isApplet = appletDocumentBase != null;
        Object in = null;
        String post = null;
        if (isURL && (iurl = name.indexOf("?POST?")) >= 0) {
            post = name.substring(iurl + 6);
            name = name.substring(0, iurl);
        }
        if (isApplet || isURL) {
            URL url;
            try {
                url = new URL(appletDocumentBase, name, null);
            }
            catch (Exception e) {
                throw new JSVException("Cannot read " + name);
            }
            Logger.info("JSVFileManager opening URL " + url + (post == null ? "" : " with POST of " + post.length() + " bytes"));
            in = JSVFileManager.viewer.apiPlatform.getURLContents(url, postBytes, post, false);
        } else {
            if (showMsg) {
                Logger.info("JSVFileManager opening file " + name);
            }
            in = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(name);
        }
        if (in instanceof String) {
            throw new JSVException((String)in);
        }
        return (InputStream)in;
    }

    private static String getNMRSimulationJCampDX(String name) {
        String key = JSVFileManager.getSimulationHash(name);
        String jcamp = htCorrelationCache.get(key);
        if (jcamp != null) {
            return jcamp;
        }
        boolean isInline = name.startsWith("MOL=");
        String src = isInline ? null : PT.rep(nciResolver, "%FILE", PT.escapeUrl(name));
        String molFile = isInline ? PT.rep(name.substring(4), "\\n", "\n") : JSVFileManager.getFileAsString(src);
        if (molFile == null) {
            Logger.info("no data returned");
        }
        String json = JSVFileManager.getFileAsString(String.valueOf(nmrdbServer) + molFile);
        htCorrelationCache.put("json", json);
        Logger.debug(json);
        if (json.indexOf("\"error\":") >= 0) {
            return null;
        }
        json = PT.rep(json, "\\r\\n", "\n");
        json = PT.rep(json, "\\t", "\t");
        json = PT.rep(json, "\\n", "\n");
        String jsonMolFile = JSVFileManager.getQuotedJSONAttribute(json, "molfile", null);
        htCorrelationCache.put("mol", jsonMolFile);
        System.out.println("molFile is \n" + molFile);
        System.out.println("jsonMolFile is \n" + jsonMolFile);
        viewer.syncScript("JSVSTR:" + jsonMolFile);
        String xml = JSVFileManager.getQuotedJSONAttribute(json, "xml", null);
        xml = PT.rep(xml, "<Signals>", "<Signals src=" + PT.esc(PT.rep(nmrdbServer, "?POST?molfile=", "")) + ">");
        xml = PT.rep(xml, "</", "\n</");
        xml = PT.rep(xml, "><", ">\n<");
        xml = PT.rep(xml, "\\\"", "\"");
        htCorrelationCache.put("xml", xml);
        jcamp = JSVFileManager.getQuotedJSONAttribute(json, "jcamp", null);
        jcamp = "##TITLE=" + (isInline ? "JMOL SIMULATION" : name) + "\n" + jcamp.substring(jcamp.indexOf("\n##") + 1);
        int pt = molFile.indexOf("\n");
        pt = molFile.indexOf("\n", pt + 1);
        if (pt > 0 && pt == molFile.indexOf("\n \n")) {
            molFile = String.valueOf(molFile.substring(0, pt + 1)) + "Created " + JSVFileManager.viewer.apiPlatform.getDateFormat("8824") + " by JSpecView " + JSVersion.VERSION + molFile.substring(pt + 1);
        }
        pt = 0;
        pt = jcamp.indexOf("##.");
        String id = JSVFileManager.getAbbreviatedSimulationName(name, false);
        int pt1 = id.indexOf("id='");
        if (isInline && pt1 > 0) {
            id = id.substring(pt1 + 4, (String.valueOf(id) + "'").indexOf("'", pt1 + 4));
        }
        jcamp = String.valueOf(jcamp.substring(0, pt)) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + PT.esc(id) + " type=\"MOL\" src=" + PT.esc(src) + ">\n" + molFile + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + xml + "\n" + jcamp.substring(pt);
        htCorrelationCache.put("jcamp", jcamp);
        htCorrelationCache.put(key, jcamp);
        return jcamp;
    }

    private static URL getResource(Object object, String fileName, String[] error) {
        URL url = null;
        try {
            url = object.getClass().getResource(fileName);
            if (url == null) {
                error[0] = "Couldn't find file: " + fileName;
            }
        }
        catch (Exception e) {
            error[0] = "Exception " + e + " in getResource " + fileName;
        }
        return url;
    }

    public static String getResourceString(Object object, String name, String[] error) {
        URL url = JSVFileManager.getResource(object, name, error);
        if (url == null) {
            error[0] = "Error loading resource " + name;
            return null;
        }
        if (url instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)url));
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            error[0] = e.toString();
        }
        return sb.toString();
    }

    public static String getJmolFilePath(String filePath) {
        try {
            filePath = JSVFileManager.getFullPathName(filePath);
        }
        catch (JSVException e) {
            return null;
        }
        return appletDocumentBase == null ? filePath.replace('\\', '/') : filePath;
    }

    public static String getTagName(String fileName) {
        if (fileName == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(fileName)) {
            try {
                if (fileName.startsWith(SIMULATION_PROTOCOL)) {
                    return JSVFileManager.getAbbrSimulationFileName(fileName);
                }
                String name = new URL(null, fileName, null).getFile();
                return name.substring(name.lastIndexOf(47) + 1);
            }
            catch (IOException e) {
                return null;
            }
        }
        return JSVFileManager.viewer.apiPlatform.newFile(fileName).getName();
    }

    public static String getQuotedJSONAttribute(String json, String key1, String key2) {
        if (key2 == null) {
            key2 = key1;
        }
        key1 = "\"" + key1 + "\":";
        key2 = "\"" + key2 + "\":";
        int pt1 = json.indexOf(key1);
        int pt2 = json.indexOf(key2, pt1);
        return pt1 < 0 || pt2 < 0 ? null : PT.getQuotedStringAt(json, pt2 + key2.length());
    }

    public static void setDocumentBase(JSViewer v, URL documentBase) {
        viewer = v;
        appletDocumentBase = documentBase;
    }
}

