/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.objects;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.MetaClassWithShapeCacheNode;
import org.jruby.truffle.nodes.objects.MetaClassWithShapeCacheNodeGen;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.layouts.Layouts;

@NodeChildren(value={@NodeChild(value="instance"), @NodeChild(value="module")})
public abstract class IsANode
extends RubyNode {
    @Node.Child
    MetaClassWithShapeCacheNode metaClassNode;

    public IsANode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.metaClassNode = MetaClassWithShapeCacheNodeGen.create(context, sourceSection, null);
    }

    public abstract boolean executeIsA(Object var1, DynamicObject var2);

    @Specialization(limit="getCacheLimit()", guards={"isRubyModule(cachedModule)", "metaClass(self) == cachedMetaClass", "module == cachedModule"}, assumptions={"getUnmodifiedAssumption(cachedModule)"})
    public boolean isACached(Object self, DynamicObject module, @Cached(value="metaClass(self)") DynamicObject cachedMetaClass, @Cached(value="module") DynamicObject cachedModule, @Cached(value="isA(cachedMetaClass, cachedModule)") boolean result) {
        return result;
    }

    public Assumption getUnmodifiedAssumption(DynamicObject module) {
        return Layouts.MODULE.getFields(module).getUnmodifiedAssumption();
    }

    @Specialization(guards={"isRubyModule(module)"})
    public boolean isAUncached(Object self, DynamicObject module) {
        return this.isA(this.metaClass(self), module);
    }

    @Specialization(guards={"!isRubyModule(module)"})
    public boolean isATypeError(Object self, DynamicObject module) {
        CompilerDirectives.transferToInterpreter();
        throw new RaiseException(this.getContext().getCoreLibrary().typeError("class or module required", this));
    }

    @CompilerDirectives.TruffleBoundary
    protected boolean isA(DynamicObject metaClass, DynamicObject module) {
        return ModuleOperations.assignableTo(metaClass, module);
    }

    protected DynamicObject metaClass(Object object) {
        return this.metaClassNode.executeMetaClass(object);
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().IS_A_CACHE;
    }
}

