/*
 * Decompiled with CFR 0.152.
 */
package org.perl.inline.java;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.StringTokenizer;
import org.perl.inline.java.InlineJavaClass;
import org.perl.inline.java.InlineJavaException;
import org.perl.inline.java.InlineJavaPerlCaller;
import org.perl.inline.java.InlineJavaPerlException;
import org.perl.inline.java.InlineJavaUtils;

public class InlineJavaPerlNatives
extends InlineJavaPerlCaller {
    private static boolean inited = false;
    private static Map registered_classes = Collections.synchronizedMap(new HashMap());
    private static Map registered_methods = Collections.synchronizedMap(new HashMap());

    protected InlineJavaPerlNatives() throws InlineJavaException {
        InlineJavaPerlNatives.init();
        this.RegisterPerlNatives(this.getClass());
    }

    protected static void init() throws InlineJavaException {
        InlineJavaPerlNatives.init("install");
    }

    protected static synchronized void init(String mode) throws InlineJavaException {
        InlineJavaPerlCaller.init();
        if (!inited) {
            try {
                String perlnatives_so = InlineJavaPerlNatives.GetBundle().getString("inline_java_perlnatives_so_" + mode);
                File f = new File(perlnatives_so);
                if (!f.exists()) {
                    throw new InlineJavaException("Can't initialize PerlNatives functionnality: PerlNatives extension (" + perlnatives_so + ") can't be found");
                }
                try {
                    Class<?> ste_class = Class.forName("java.lang.StackTraceElement");
                }
                catch (ClassNotFoundException cnfe) {
                    throw new InlineJavaException("Can't initialize PerlNatives functionnality: Java 1.4 or higher required (current is " + System.getProperty("java.version") + ").");
                }
                InlineJavaUtils.debug(2, "loading shared library " + perlnatives_so);
                System.load(perlnatives_so);
                inited = true;
            }
            catch (MissingResourceException mre) {
                throw new InlineJavaException("Error loading InlineJava.properties resource: " + mre.getMessage());
            }
        }
    }

    private synchronized void RegisterPerlNatives(Class c) throws InlineJavaException {
        if (registered_classes.get(c) == null) {
            Executable x;
            int i;
            InlineJavaUtils.debug(3, "registering natives for class " + c.getName());
            Constructor<?>[] constructors = c.getDeclaredConstructors();
            Method[] methods = c.getDeclaredMethods();
            registered_classes.put(c, c);
            for (i = 0; i < constructors.length; ++i) {
                x = constructors[i];
                if (!Modifier.isNative(((Constructor)x).getModifiers())) continue;
                this.RegisterMethod(c, "new", ((Constructor)x).getParameterTypes(), c);
            }
            for (i = 0; i < methods.length; ++i) {
                x = methods[i];
                if (!Modifier.isNative(((Method)x).getModifiers())) continue;
                this.RegisterMethod(c, ((Method)x).getName(), ((Method)x).getParameterTypes(), ((Method)x).getReturnType());
            }
        }
    }

    private void RegisterMethod(Class c, String mname, Class[] params, Class rt) throws InlineJavaException {
        String cname = c.getName();
        InlineJavaUtils.debug(3, "registering native method " + mname + " for class " + cname);
        if (!Object.class.isAssignableFrom(rt) && rt != Void.TYPE) {
            throw new InlineJavaException("Perl native method " + mname + " of class " + cname + " can only have Object or void return types (not " + rt.getName() + ")");
        }
        StringBuffer fmt = new StringBuffer("L");
        StringBuffer sign = new StringBuffer("(");
        for (int i = 0; i < params.length; ++i) {
            char ch;
            String code = InlineJavaClass.FindJNICode(params[i]);
            sign.append(code);
            char f = ch = code.charAt(0);
            if (f == '[') {
                f = 'L';
            }
            fmt.append(new String(new char[]{f}));
        }
        sign.append(")");
        sign.append(InlineJavaClass.FindJNICode(rt));
        InlineJavaUtils.debug(3, "signature is " + sign);
        InlineJavaUtils.debug(3, "format is " + fmt);
        String meth = cname + "." + mname;
        String prev = (String)registered_methods.get(meth);
        if (prev != null) {
            throw new InlineJavaException("There already is a native method '" + mname + "' registered for class '" + cname + "'");
        }
        registered_methods.put(meth, fmt.toString());
        this.RegisterMethod(c, mname, sign.toString());
    }

    private native void RegisterMethod(Class var1, String var2, String var3) throws InlineJavaException;

    private String LookupMethod() throws InlineJavaException {
        InlineJavaUtils.debug(3, "entering LookupMethod");
        String[] caller = this.GetNativeCaller();
        String meth = caller[0] + "." + caller[1];
        String fmt = (String)registered_methods.get(meth);
        if (fmt == null) {
            throw new InlineJavaException("Native method " + meth + " is not registered");
        }
        InlineJavaUtils.debug(3, "exiting LookupMethod");
        return fmt;
    }

    private Object InvokePerlMethod(Object[] args) throws InlineJavaException, InlineJavaPerlException {
        InlineJavaUtils.debug(3, "entering InvokePerlMethod");
        String[] caller = this.GetNativeCaller();
        String pkg = caller[0];
        String method = caller[1];
        StringTokenizer st = new StringTokenizer(pkg, ".");
        StringBuffer perl_sub = new StringBuffer();
        while (st.hasMoreTokens()) {
            perl_sub.append("::" + st.nextToken());
        }
        perl_sub.append("::" + method);
        for (int i = 0; i < args.length; ++i) {
            InlineJavaUtils.debug(3, "InvokePerlMethod argument " + i + " = " + args[i]);
        }
        Object ret = this.CallPerlSub(perl_sub.toString(), args);
        InlineJavaUtils.debug(3, "exiting InvokePerlMethod");
        return ret;
    }

    private String[] GetNativeCaller() throws InlineJavaException {
        InlineJavaUtils.debug(3, "entering GetNativeCaller");
        Class<?> ste_class = null;
        try {
            ste_class = Class.forName("java.lang.StackTraceElement");
        }
        catch (ClassNotFoundException cnfe) {
            throw new InlineJavaException("Can't load class java.lang.StackTraceElement");
        }
        Throwable exec_point = new Throwable();
        try {
            Method m = exec_point.getClass().getMethod("getStackTrace", new Class[0]);
            Object stack = m.invoke((Object)exec_point, new Object[0]);
            if (Array.getLength(stack) <= 2) {
                throw new InlineJavaException("Improper use of InlineJavaPerlNatives.GetNativeCaller (call stack too short)");
            }
            Object ste = Array.get(stack, 2);
            m = ste.getClass().getMethod("isNativeMethod", new Class[0]);
            Boolean is_nm = (Boolean)m.invoke(ste, new Object[0]);
            if (!is_nm.booleanValue()) {
                throw new InlineJavaException("Improper use of InlineJavaPerlNatives.GetNativeCaller (caller is not native)");
            }
            m = ste.getClass().getMethod("getClassName", new Class[0]);
            String cname = (String)m.invoke(ste, new Object[0]);
            m = ste.getClass().getMethod("getMethodName", new Class[0]);
            String mname = (String)m.invoke(ste, new Object[0]);
            InlineJavaUtils.debug(3, "exiting GetNativeCaller");
            return new String[]{cname, mname};
        }
        catch (NoSuchMethodException nsme) {
            throw new InlineJavaException("Error manipulating java.lang.StackTraceElement classes: " + nsme.getMessage());
        }
        catch (IllegalAccessException iae) {
            throw new InlineJavaException("Error manipulating java.lang.StackTraceElement classes: " + iae.getMessage());
        }
        catch (InvocationTargetException ite) {
            throw new InlineJavaException("Exception caught while manipulating java.lang.StackTraceElement classes: " + ite.getTargetException());
        }
    }
}

