/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.SendToBackCommand;
import CH.ifa.draw.util.Undoable;

public class BringToFrontCommand
extends AbstractCommand {
    public BringToFrontCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    public void execute() {
        super.execute();
        this.setUndoActivity(this.createUndoActivity());
        this.getUndoActivity().setAffectedFigures(this.view().selectionElements());
        FigureEnumeration fe = this.getUndoActivity().getAffectedFigures();
        while (fe.hasMoreElements()) {
            this.view().drawing().bringToFront(fe.nextFigure());
        }
        this.view().checkDamage();
    }

    public boolean isExecutableWithView() {
        return this.view().selectionCount() > 0;
    }

    protected Undoable createUndoActivity() {
        return new UndoActivity(this.view());
    }

    public static class UndoActivity
    extends SendToBackCommand.UndoActivity {
        public UndoActivity(DrawingView newDrawingView) {
            super(newDrawingView);
        }

        protected void sendToCommand(Figure f) {
            this.getDrawingView().drawing().bringToFront(f);
        }
    }
}

