/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.StringUtils;
import ch.softenvironment.util.Tracer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public abstract class NlsUtils {
    public static final String TIME_24HOURS_PATTERN = "HH:mm:ss";

    public static String formatMessage(String pattern, Object[] tokens) {
        return MessageFormat.format(pattern, tokens);
    }

    public static String formatMessage(String pattern, int arg0) {
        Object[] tokens = new Object[]{new Integer(arg0)};
        return NlsUtils.formatMessage(pattern, tokens);
    }

    public static String formatMessage(String pattern, String arg0) {
        Object[] tokens = new Object[]{arg0};
        return NlsUtils.formatMessage(pattern, tokens);
    }

    public static boolean changeLocale(Locale locale) {
        if (Locale.getDefault().getLanguage().equals(locale.getLanguage())) {
            if (!StringUtils.isNullOrEmpty(locale.getCountry()) && !locale.getCountry().equals(Locale.getDefault().getCountry())) {
                // empty if block
            }
        } else {
            Locale.setDefault(locale);
            Tracer.getInstance().runtimeInfo("Locale changed to: " + Locale.getDefault());
            return true;
        }
        return false;
    }

    public static String formatDate(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getDateInstance().format(date);
    }

    public static String formatDate(GregorianCalendar date) {
        return NlsUtils.formatDate(date.getTime());
    }

    public static String formatTime(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getTimeInstance().format(date);
    }

    public static String formatTime24Hours(Date date) {
        return NlsUtils.formatTime24Hours(date, true);
    }

    public static String formatTime24Hours(Date date, boolean includingSeconds) {
        if (date == null) {
            return "";
        }
        String pattern = "HH:mm";
        if (includingSeconds) {
            pattern = TIME_24HOURS_PATTERN;
        }
        SimpleDateFormat sf = new SimpleDateFormat(pattern);
        return sf.format(date);
    }

    public static String formatDateTime(Date date) {
        if (date == null) {
            return "";
        }
        return DateFormat.getDateTimeInstance().format(date);
    }
}

