/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.health;

public enum ClusterHealthStatus {
    GREEN(0),
    YELLOW(1),
    RED(2);

    private byte value;

    private ClusterHealthStatus(byte value) {
        this.value = value;
    }

    public byte value() {
        return this.value;
    }

    public static ClusterHealthStatus fromValue(byte value) {
        switch (value) {
            case 0: {
                return GREEN;
            }
            case 1: {
                return YELLOW;
            }
            case 2: {
                return RED;
            }
        }
        throw new IllegalArgumentException("No cluster health status for value [" + value + "]");
    }

    public static ClusterHealthStatus fromString(String status) {
        if (status.equalsIgnoreCase("green")) {
            return GREEN;
        }
        if (status.equalsIgnoreCase("yellow")) {
            return YELLOW;
        }
        if (status.equalsIgnoreCase("red")) {
            return RED;
        }
        throw new IllegalArgumentException("unknown cluster health status [" + status + "]");
    }
}

