/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ProcessedClusterStateUpdateTask;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.MergeResult;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;

public class MetaDataMappingService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final Object refreshOrUpdateMutex = new Object();
    private final List<MappingTask> refreshOrUpdateQueue = new ArrayList<MappingTask>();
    private long refreshOrUpdateInsertOrder;
    private long refreshOrUpdateProcessedInsertOrder;

    @Inject
    public MetaDataMappingService(Settings settings, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Tuple<ClusterState, List<MappingTask>> executeRefreshOrUpdate(ClusterState currentState, long insertionOrder) throws Exception {
        ArrayList<MappingTask> allTasks = new ArrayList<MappingTask>();
        Object object = this.refreshOrUpdateMutex;
        synchronized (object) {
            if (this.refreshOrUpdateQueue.isEmpty()) {
                return Tuple.tuple(currentState, allTasks);
            }
            if (insertionOrder < this.refreshOrUpdateProcessedInsertOrder) {
                return Tuple.tuple(currentState, allTasks);
            }
            allTasks.addAll(this.refreshOrUpdateQueue);
            this.refreshOrUpdateQueue.clear();
            this.refreshOrUpdateProcessedInsertOrder = this.refreshOrUpdateInsertOrder;
        }
        if (allTasks.isEmpty()) {
            return Tuple.tuple(currentState, allTasks);
        }
        HashMap tasksPerIndex = Maps.newHashMap();
        for (MappingTask task : allTasks) {
            ArrayList<MappingTask> indexTasks;
            if (task.index == null) {
                this.logger.debug("ignoring a mapping task of type [{}] with a null index.", task);
            }
            if ((indexTasks = (ArrayList<MappingTask>)tasksPerIndex.get(task.index)) == null) {
                indexTasks = new ArrayList<MappingTask>();
                tasksPerIndex.put(task.index, indexTasks);
            }
            indexTasks.add(task);
        }
        boolean dirty = false;
        MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            String index = (String)entry.getKey();
            IndexMetaData indexMetaData = mdBuilder.get(index);
            if (indexMetaData == null) {
                this.logger.debug("[{}] ignoring tasks - index meta data doesn't exist", index);
                continue;
            }
            List allIndexTasks = (List)entry.getValue();
            ArrayList<MappingTask> tasks = new ArrayList<MappingTask>();
            for (MappingTask task : allIndexTasks) {
                if (!indexMetaData.isSameUUID(task.indexUUID)) {
                    this.logger.debug("[{}] ignoring task [{}] - index meta data doesn't match task uuid", index, task);
                    continue;
                }
                tasks.add(task);
            }
            boolean removeIndex = false;
            IndexService indexService = this.indicesService.indexService(index);
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetaData.getIndex(), indexMetaData.getSettings(), currentState.nodes().localNode().id());
                removeIndex = true;
                HashSet typesToIntroduce = Sets.newHashSet();
                for (MappingTask task : tasks) {
                    if (task instanceof UpdateTask) {
                        typesToIntroduce.add(((UpdateTask)task).type);
                        continue;
                    }
                    if (!(task instanceof RefreshTask)) continue;
                    Collections.addAll(typesToIntroduce, ((RefreshTask)task).types);
                }
                for (String type : typesToIntroduce) {
                    if (!indexMetaData.getMappings().containsKey(type)) continue;
                    indexService.mapperService().merge(type, indexMetaData.getMappings().get(type).source(), false, true);
                }
            }
            IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
            try {
                boolean indexDirty = this.processIndexMappingTasks(tasks, indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, "created for mapping processing");
            }
        }
        if (!dirty) {
            return Tuple.tuple(currentState, allTasks);
        }
        return Tuple.tuple(ClusterState.builder(currentState).metaData(mdBuilder).build(), allTasks);
    }

    private boolean processIndexMappingTasks(List<MappingTask> tasks, IndexService indexService, IndexMetaData.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().name();
        HashSet processedRefreshes = Sets.newHashSet();
        for (MappingTask task : tasks) {
            if (task instanceof RefreshTask) {
                RefreshTask refreshTask = (RefreshTask)task;
                try {
                    ArrayList<String> updatedTypes = new ArrayList<String>();
                    for (String type : refreshTask.types) {
                        DocumentMapper mapper;
                        if (processedRefreshes.contains(type) || (mapper = indexService.mapperService().documentMapper(type)) == null) continue;
                        if (!mapper.mappingSource().equals(builder.mapping(type).source())) {
                            updatedTypes.add(type);
                            builder.putMapping(new MappingMetaData(mapper));
                        }
                        processedRefreshes.add(type);
                    }
                    if (updatedTypes.isEmpty()) continue;
                    this.logger.warn("[{}] re-syncing mappings with cluster state for types [{}]", index, updatedTypes);
                    dirty = true;
                }
                catch (Throwable t) {
                    this.logger.warn("[{}] failed to refresh-mapping in cluster state, types [{}]", index, refreshTask.types);
                }
                continue;
            }
            if (task instanceof UpdateTask) {
                UpdateTask updateTask = (UpdateTask)task;
                try {
                    String type = updateTask.type;
                    CompressedXContent mappingSource = updateTask.mappingSource;
                    MappingMetaData mappingMetaData = builder.mapping(type);
                    if (mappingMetaData != null && mappingMetaData.source().equals(mappingSource)) {
                        this.logger.debug("[{}] update_mapping [{}] ignoring mapping update task as its source is equal to ours", index, updateTask.type);
                        continue;
                    }
                    DocumentMapper updatedMapper = indexService.mapperService().merge(type, mappingSource, false, true);
                    processedRefreshes.add(type);
                    if (mappingMetaData != null && mappingMetaData.source().equals(updatedMapper.mappingSource())) {
                        this.logger.debug("[{}] update_mapping [{}] ignoring mapping update task as it results in the same source as what we have", index, updateTask.type);
                        continue;
                    }
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("[{}] update_mapping [{}] (dynamic) with source [{}]", index, type, updatedMapper.mappingSource());
                    } else if (this.logger.isInfoEnabled()) {
                        this.logger.info("[{}] update_mapping [{}] (dynamic)", index, type);
                    }
                    builder.putMapping(new MappingMetaData(updatedMapper));
                    dirty = true;
                }
                catch (Throwable t) {
                    this.logger.warn("[{}] failed to update-mapping in cluster state, type [{}]", index, updateTask.type);
                }
                continue;
            }
            this.logger.warn("illegal state, got wrong mapping task type [{}]", task);
        }
        return dirty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshMapping(String index, String indexUUID, String ... types) {
        long insertOrder;
        Object object = this.refreshOrUpdateMutex;
        synchronized (object) {
            insertOrder = ++this.refreshOrUpdateInsertOrder;
            this.refreshOrUpdateQueue.add(new RefreshTask(index, indexUUID, types));
        }
        this.clusterService.submitStateUpdateTask("refresh-mapping [" + index + "][" + Arrays.toString(types) + "]", Priority.HIGH, new ProcessedClusterStateUpdateTask(){
            private volatile List<MappingTask> allTasks;

            @Override
            public void onFailure(String source, Throwable t) {
                MetaDataMappingService.this.logger.warn("failure during [{}]", t, source);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                Tuple<ClusterState, List<MappingTask>> tuple = MetaDataMappingService.this.executeRefreshOrUpdate(currentState, insertOrder);
                this.allTasks = tuple.v2();
                return tuple.v1();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                if (this.allTasks == null) {
                    return;
                }
                for (MappingTask task : this.allTasks) {
                    if (!(task instanceof UpdateTask)) continue;
                    UpdateTask uTask = (UpdateTask)task;
                    ClusterStateUpdateResponse response = new ClusterStateUpdateResponse(true);
                    uTask.listener.onResponse(response);
                }
            }
        });
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping [" + request.type() + "]", Priority.HIGH, new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>((AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                ArrayList<String> indicesToClose = new ArrayList<String>();
                try {
                    IndexMetaData indexMetaData;
                    DocumentMapper newMapper;
                    for (String index : request.indices()) {
                        if (currentState.metaData().hasIndex(index)) continue;
                        throw new IndexNotFoundException(index);
                    }
                    for (String index : request.indices()) {
                        if (MetaDataMappingService.this.indicesService.hasIndex(index)) continue;
                        IndexMetaData indexMetaData2 = currentState.metaData().index(index);
                        IndexService indexService = MetaDataMappingService.this.indicesService.createIndex(indexMetaData2.getIndex(), indexMetaData2.getSettings(), MetaDataMappingService.this.clusterService.localNode().id());
                        indicesToClose.add(indexMetaData2.getIndex());
                        if (indexMetaData2.getMappings().containsKey("_default_")) {
                            indexService.mapperService().merge("_default_", indexMetaData2.getMappings().get("_default_").source(), false, request.updateAllTypes());
                        }
                        if (!indexMetaData2.getMappings().containsKey(request.type())) continue;
                        indexService.mapperService().merge(request.type(), indexMetaData2.getMappings().get(request.type()).source(), false, request.updateAllTypes());
                    }
                    HashMap newMappers = Maps.newHashMap();
                    HashMap existingMappers = Maps.newHashMap();
                    for (String index : request.indices()) {
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexServiceSafe(index);
                        DocumentMapper existingMapper = indexService.mapperService().documentMapper(request.type());
                        if ("_default_".equals(request.type())) {
                            newMapper = indexService.mapperService().parse(request.type(), new CompressedXContent(request.source()), false);
                        } else {
                            newMapper = indexService.mapperService().parse(request.type(), new CompressedXContent(request.source()), existingMapper == null);
                            if (existingMapper != null) {
                                MergeResult mergeResult = existingMapper.merge(newMapper.mapping(), true, request.updateAllTypes());
                                if (mergeResult.hasConflicts()) {
                                    throw new MergeMappingException(mergeResult.buildConflicts());
                                }
                            } else if (Version.indexCreated(indexService.indexSettings()).onOrAfter(Version.V_2_0_0_beta1) && newMapper.parentFieldMapper().active()) {
                                indexMetaData = currentState.metaData().index(index);
                                for (ObjectCursor mapping : indexMetaData.getMappings().values()) {
                                    if (!newMapper.parentFieldMapper().type().equals(((MappingMetaData)mapping.value).type())) continue;
                                    throw new IllegalArgumentException("can't add a _parent field that points to an already existing type");
                                }
                            }
                        }
                        newMappers.put(index, newMapper);
                        if (existingMapper == null) continue;
                        existingMappers.put(index, existingMapper);
                    }
                    String mappingType = request.type();
                    if (mappingType == null) {
                        mappingType = ((DocumentMapper)newMappers.values().iterator().next()).type();
                    } else if (!mappingType.equals(((DocumentMapper)newMappers.values().iterator().next()).type())) {
                        throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
                    }
                    if (!"_default_".equals(mappingType) && !".percolator".equals(mappingType) && mappingType.charAt(0) == '_') {
                        throw new InvalidTypeNameException("Document mapping type name can't start with '_'");
                    }
                    HashMap mappings = Maps.newHashMap();
                    for (Map.Entry entry : newMappers.entrySet()) {
                        String index = (String)entry.getKey();
                        newMapper = (DocumentMapper)entry.getValue();
                        IndexService indexService = MetaDataMappingService.this.indicesService.indexService(index);
                        if (indexService == null) continue;
                        CompressedXContent existingSource = null;
                        if (existingMappers.containsKey(entry.getKey())) {
                            existingSource = ((DocumentMapper)existingMappers.get(entry.getKey())).mappingSource();
                        }
                        DocumentMapper mergedMapper = indexService.mapperService().merge(newMapper.type(), newMapper.mappingSource(), false, request.updateAllTypes());
                        CompressedXContent updatedSource = mergedMapper.mappingSource();
                        if (existingSource != null) {
                            if (existingSource.equals(updatedSource)) continue;
                            mappings.put(index, new MappingMetaData(mergedMapper));
                            if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                                MetaDataMappingService.this.logger.debug("[{}] update_mapping [{}] with source [{}]", index, mergedMapper.type(), updatedSource);
                                continue;
                            }
                            if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                            MetaDataMappingService.this.logger.info("[{}] update_mapping [{}]", index, mergedMapper.type());
                            continue;
                        }
                        mappings.put(index, new MappingMetaData(mergedMapper));
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("[{}] create_mapping [{}] with source [{}]", index, newMapper.type(), updatedSource);
                            continue;
                        }
                        if (!MetaDataMappingService.this.logger.isInfoEnabled()) continue;
                        MetaDataMappingService.this.logger.info("[{}] create_mapping [{}]", index, newMapper.type());
                    }
                    if (mappings.isEmpty()) {
                        ClusterState i$ = currentState;
                        return i$;
                    }
                    MetaData.Builder builder = MetaData.builder(currentState.metaData());
                    for (String indexName : request.indices()) {
                        indexMetaData = currentState.metaData().index(indexName);
                        if (indexMetaData == null) {
                            throw new IndexNotFoundException(indexName);
                        }
                        MappingMetaData mappingMd = (MappingMetaData)mappings.get(indexName);
                        if (mappingMd == null) continue;
                        builder.put(IndexMetaData.builder(indexMetaData).putMapping(mappingMd));
                    }
                    ClusterState clusterState = ClusterState.builder(currentState).metaData(builder).build();
                    return clusterState;
                }
                finally {
                    for (String index : indicesToClose) {
                        MetaDataMappingService.this.indicesService.removeIndex(index, "created for mapping processing");
                    }
                }
            }
        });
    }

    static class UpdateTask
    extends MappingTask {
        final String type;
        final CompressedXContent mappingSource;
        final String nodeId;
        final ActionListener<ClusterStateUpdateResponse> listener;

        UpdateTask(String index, String indexUUID, String type, CompressedXContent mappingSource, String nodeId, ActionListener<ClusterStateUpdateResponse> listener) {
            super(index, indexUUID);
            this.type = type;
            this.mappingSource = mappingSource;
            this.nodeId = nodeId;
            this.listener = listener;
        }
    }

    static class RefreshTask
    extends MappingTask {
        final String[] types;

        RefreshTask(String index, String indexUUID, String[] types) {
            super(index, indexUUID);
            this.types = types;
        }
    }

    static class MappingTask {
        final String index;
        final String indexUUID;

        MappingTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }
    }
}

