/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.concurrent.Semaphore;
import org.elasticsearch.cluster.routing.DjbHashFunction;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.math.MathUtils;
import org.elasticsearch.common.settings.Settings;

public class MetaDataService
extends AbstractComponent {
    private final Semaphore[] indexMdLocks = new Semaphore[500];

    @Inject
    public MetaDataService(Settings settings) {
        super(settings);
        for (int i = 0; i < this.indexMdLocks.length; ++i) {
            this.indexMdLocks[i] = new Semaphore(1);
        }
    }

    public Semaphore indexMetaDataLock(String index) {
        return this.indexMdLocks[MathUtils.mod(DjbHashFunction.DJB_HASH(index), this.indexMdLocks.length)];
    }
}

