/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.GatewayMetaState;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesListGatewayMetaState
extends TransportNodesAction<Request, NodesGatewayMetaState, NodeRequest, NodeGatewayMetaState> {
    public static final String ACTION_NAME = "internal:gateway/local/meta_state";
    private GatewayMetaState metaState;

    @Inject
    public TransportNodesListGatewayMetaState(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request.class, NodeRequest.class, "generic");
    }

    TransportNodesListGatewayMetaState init(GatewayMetaState metaState) {
        this.metaState = metaState;
        return this;
    }

    public ActionFuture<NodesGatewayMetaState> list(String[] nodesIds, @Nullable TimeValue timeout) {
        return this.execute(new Request(nodesIds).timeout(timeout));
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeGatewayMetaState newNodeResponse() {
        return new NodeGatewayMetaState();
    }

    @Override
    protected NodesGatewayMetaState newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeGatewayMetaState> nodesList = new ArrayList<NodeGatewayMetaState>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeGatewayMetaState) {
                nodesList.add((NodeGatewayMetaState)resp);
                continue;
            }
            if (resp instanceof FailedNodeException) {
                failures.add((FailedNodeException)resp);
                continue;
            }
            this.logger.warn("unknown response type [{}], expected NodeLocalGatewayMetaState or FailedNodeException", resp);
        }
        return new NodesGatewayMetaState(this.clusterName, nodesList.toArray(new NodeGatewayMetaState[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeGatewayMetaState nodeOperation(NodeRequest request) {
        try {
            return new NodeGatewayMetaState(this.clusterService.localNode(), this.metaState.loadMetaState());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeGatewayMetaState
    extends BaseNodeResponse {
        private MetaData metaData;

        NodeGatewayMetaState() {
        }

        public NodeGatewayMetaState(DiscoveryNode node, MetaData metaData) {
            super(node);
            this.metaData = metaData;
        }

        public MetaData metaData() {
            return this.metaData;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            if (in.readBoolean()) {
                this.metaData = MetaData.Builder.readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.metaData == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this.metaData.writeTo(out);
            }
        }
    }

    static class NodeRequest
    extends BaseNodeRequest {
        NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(request, nodeId);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }

    public static class NodesGatewayMetaState
    extends BaseNodesResponse<NodeGatewayMetaState> {
        private FailedNodeException[] failures;

        NodesGatewayMetaState() {
        }

        public NodesGatewayMetaState(ClusterName clusterName, NodeGatewayMetaState[] nodes, FailedNodeException[] failures) {
            super(clusterName, (BaseNodeResponse[])nodes);
            this.failures = failures;
        }

        @Override
        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeGatewayMetaState[in.readVInt()];
            for (int i = 0; i < ((NodeGatewayMetaState[])this.nodes).length; ++i) {
                ((NodeGatewayMetaState[])this.nodes)[i] = new NodeGatewayMetaState();
                ((NodeGatewayMetaState[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeGatewayMetaState[])this.nodes).length);
            for (NodeGatewayMetaState response : (NodeGatewayMetaState[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    static class Request
    extends BaseNodesRequest<Request> {
        public Request() {
        }

        public Request(String ... nodesIds) {
            super(nodesIds);
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
        }
    }
}

