/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.support.RestResponseListener;
import org.elasticsearch.rest.action.support.RestTable;

public class RestRecoveryAction
extends AbstractCatAction {
    @Inject
    protected RestRecoveryAction(Settings settings, RestController restController, RestController controller, Client client) {
        super(settings, controller, client);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery", this);
        restController.registerHandler(RestRequest.Method.GET, "/_cat/recovery/{index}", this);
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/recovery\n");
        sb.append("/_cat/recovery/{index}\n");
    }

    @Override
    public void doRequest(final RestRequest request, RestChannel channel, Client client) {
        RecoveryRequest recoveryRequest = new RecoveryRequest(Strings.splitStringByCommaToArray(request.param("index")));
        recoveryRequest.detailed(request.paramAsBoolean("detailed", false));
        recoveryRequest.activeOnly(request.paramAsBoolean("active_only", false));
        recoveryRequest.indicesOptions(IndicesOptions.fromRequest(request, recoveryRequest.indicesOptions()));
        client.admin().indices().recoveries(recoveryRequest, (ActionListener<RecoveryResponse>)new RestResponseListener<RecoveryResponse>(channel){

            @Override
            public RestResponse buildResponse(RecoveryResponse response) throws Exception {
                return RestTable.buildResponse(RestRecoveryAction.this.buildRecoveryTable(request, response), this.channel);
            }
        });
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        Table t = new Table();
        t.startHeaders().addCell("index", "alias:i,idx;desc:index name").addCell("shard", "alias:s,sh;desc:shard name").addCell("time", "alias:t,ti;desc:recovery time").addCell("type", "alias:ty;desc:recovery type").addCell("stage", "alias:st;desc:recovery stage").addCell("source_host", "alias:shost;desc:source host").addCell("target_host", "alias:thost;desc:target host").addCell("repository", "alias:rep;desc:repository").addCell("snapshot", "alias:snap;desc:snapshot").addCell("files", "alias:f;desc:number of files to recover").addCell("files_percent", "alias:fp;desc:percent of files recovered").addCell("bytes", "alias:b;desc:size to recover in bytes").addCell("bytes_percent", "alias:bp;desc:percent of bytes recovered").addCell("total_files", "alias:tf;desc:total number of files").addCell("total_bytes", "alias:tb;desc:total number of bytes").addCell("translog", "alias:tr;desc:translog operations recovered").addCell("translog_percent", "alias:trp;desc:percent of translog recovery").addCell("total_translog", "alias:trt;desc:current total translog operations").endHeaders();
        return t;
    }

    public Table buildRecoveryTable(RestRequest request, RecoveryResponse response) {
        Table t = this.getTableWithHeader(request);
        for (String index : response.shardRecoveryStates().keySet()) {
            List<RecoveryState> shardRecoveryStates = response.shardRecoveryStates().get(index);
            if (shardRecoveryStates.size() == 0) continue;
            CollectionUtil.introSort(shardRecoveryStates, (Comparator)new Comparator<RecoveryState>(){

                @Override
                public int compare(RecoveryState o1, RecoveryState o2) {
                    int id2;
                    int id1 = o1.getShardId().id();
                    if (id1 < (id2 = o2.getShardId().id())) {
                        return -1;
                    }
                    if (id1 > id2) {
                        return 1;
                    }
                    return 0;
                }
            });
            for (RecoveryState state : shardRecoveryStates) {
                t.startRow();
                t.addCell(index);
                t.addCell(state.getShardId().id());
                t.addCell(state.getTimer().time());
                t.addCell(state.getType().toString().toLowerCase(Locale.ROOT));
                t.addCell(state.getStage().toString().toLowerCase(Locale.ROOT));
                t.addCell(state.getSourceNode() == null ? "n/a" : state.getSourceNode().getHostName());
                t.addCell(state.getTargetNode().getHostName());
                t.addCell(state.getRestoreSource() == null ? "n/a" : state.getRestoreSource().snapshotId().getRepository());
                t.addCell(state.getRestoreSource() == null ? "n/a" : state.getRestoreSource().snapshotId().getSnapshot());
                t.addCell(state.getIndex().totalRecoverFiles());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredFilesPercent())));
                t.addCell(state.getIndex().totalRecoverBytes());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getIndex().recoveredBytesPercent())));
                t.addCell(state.getIndex().totalFileCount());
                t.addCell(state.getIndex().totalBytes());
                t.addCell(state.getTranslog().recoveredOperations());
                t.addCell(String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(state.getTranslog().recoveredPercent())));
                t.addCell(state.getTranslog().totalOperations());
                t.endRow();
            }
        }
        return t;
    }
}

