/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.expression;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.script.expression.CountMethodFunctionValues;
import org.elasticsearch.script.expression.FieldDataValueSource;

public class CountMethodValueSource
extends ValueSource {
    protected IndexFieldData<?> fieldData;

    protected CountMethodValueSource(IndexFieldData<?> fieldData) {
        Objects.requireNonNull(fieldData);
        this.fieldData = fieldData;
    }

    public FunctionValues getValues(Map context, LeafReaderContext leaf) throws IOException {
        Object leafData = this.fieldData.load(leaf);
        assert (leafData instanceof AtomicNumericFieldData);
        return new CountMethodFunctionValues(this, (AtomicNumericFieldData)leafData);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FieldDataValueSource that = (FieldDataValueSource)((Object)o);
        return this.fieldData.equals(that.fieldData);
    }

    public int hashCode() {
        return this.fieldData.hashCode();
    }

    public String description() {
        return "count: field(" + this.fieldData.getFieldNames().toString() + ")";
    }
}

