/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.List;
import org.apache.fop.layoutmgr.AbstractBreaker;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.UnresolvedListElement;

public class BreakElement
extends UnresolvedListElement {
    private int penaltyWidth;
    private int penaltyValue;
    private int breakClass;
    private List pendingBeforeMarks;
    private List pendingAfterMarks;

    public BreakElement(Position position, int penaltyValue, LayoutContext context) {
        this(position, penaltyValue, 9, context);
    }

    public BreakElement(Position position, int penaltyValue, int breakClass, LayoutContext context) {
        this(position, 0, penaltyValue, breakClass, context);
    }

    public BreakElement(Position position, int penaltyWidth, int penaltyValue, int breakClass, LayoutContext context) {
        super(position);
        this.penaltyWidth = penaltyWidth;
        this.penaltyValue = penaltyValue;
        this.setBreakClass(breakClass);
        this.pendingBeforeMarks = context.getPendingBeforeMarks();
        this.pendingAfterMarks = context.getPendingAfterMarks();
    }

    private static String getBreakClassName(int breakClass) {
        return AbstractBreaker.getBreakClassName(breakClass);
    }

    public boolean isConditional() {
        return false;
    }

    public int getPenaltyWidth() {
        return this.penaltyWidth;
    }

    public int getPenaltyValue() {
        return this.penaltyValue;
    }

    public void setPenaltyValue(int p) {
        this.penaltyValue = p;
    }

    public boolean isForcedBreak() {
        return this.penaltyValue == -1000;
    }

    public int getBreakClass() {
        return this.breakClass;
    }

    public void setBreakClass(int breakClass) {
        switch (breakClass) {
            case 9: 
            case 28: 
            case 44: 
            case 75: 
            case 100: 
            case 104: {
                this.breakClass = breakClass;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal value for break class: " + breakClass);
            }
        }
    }

    public List getPendingBeforeMarks() {
        return this.pendingBeforeMarks;
    }

    public List getPendingAfterMarks() {
        return this.pendingAfterMarks;
    }

    public void clearPendingMarks() {
        this.pendingBeforeMarks = null;
        this.pendingAfterMarks = null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("BreakPossibility[p:");
        sb.append(KnuthPenalty.valueOf(this.penaltyValue));
        if (this.isForcedBreak()) {
            sb.append(" (forced break, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        } else if (this.penaltyValue >= 0 && this.breakClass != -1) {
            sb.append(" (keep constraint, ").append(BreakElement.getBreakClassName(this.breakClass)).append(")");
        }
        sb.append("; w:");
        sb.append(this.penaltyWidth);
        sb.append("]");
        return sb.toString();
    }
}

