/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import org.apache.fop.pdf.PDFImage;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.pdf.AbstractPDFImageHandler;
import org.apache.fop.render.pdf.ImageRawPNGAdapter;
import org.apache.fop.render.pdf.PDFRenderingContext;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawPNG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFImageHandlerRawPNG
extends AbstractPDFImageHandler {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_PNG};

    @Override
    PDFImage createPDFImage(Image image, String xobjectKey) {
        return new ImageRawPNGAdapter((ImageRawPNG)image, xobjectKey);
    }

    @Override
    public int getPriority() {
        return 100;
    }

    @Override
    public Class<ImageRawPNG> getSupportedImageClass() {
        return ImageRawPNG.class;
    }

    @Override
    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isCompatible(RenderingContext targetContext, Image image) {
        return (image == null || image instanceof ImageRawPNG) && targetContext instanceof PDFRenderingContext;
    }
}

