/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.readers.pymol.PickleReader;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLGroup;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.PymolAtomReader;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Logger;

public class PyMOLReader
extends PdbReader
implements PymolAtomReader {
    private static final int MIN_RESNO = -1000;
    private static String nucleic = " A C G T U ADE THY CYT GUA URI DA DC DG DT DU ";
    private boolean allowSurface = true;
    private boolean doResize;
    private boolean doCache;
    private boolean isStateScript;
    private boolean sourcePNGJ;
    private int ac0;
    private int ac;
    private int stateCount;
    private int structureCount;
    private boolean isHidden;
    private BS bsStructureDefined = new BS();
    private BS bsBytesExcluded;
    private int[] atomMap;
    private Map<String, BS> ssMapSeq;
    private PyMOLScene pymolScene;
    private P3 xyzMin = P3.new3(1000000.0f, 1000000.0f, 1000000.0f);
    private P3 xyzMax = P3.new3(-1000000.0f, -1000000.0f, -1000000.0f);
    private int nModels;
    private boolean logging;
    private BS[] reps = new BS[23];
    private boolean isMovie;
    private int pymolFrame;
    private boolean allStates;
    private int totalAtomCount;
    private int pymolVersion;
    private P3[] trajectoryStep;
    private int trajectoryPtr;
    private String objectName;
    private Map<String, Lst<Object>> volumeData;
    private Lst<Lst<Object>> mapObjects;
    private boolean haveMeasurements;
    private int[] frames;
    private Hashtable<Integer, Lst<Object>> uniqueSettings;
    private Atom[] atoms;
    private boolean haveScenes;
    private int baseModelIndex;
    private Lst<Object> sceneOrder;
    private int bondCount;

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.mustFinalizeModelSet = true;
        this.isBinary = true;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void initializeReader() throws Exception {
        this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        this.baseModelIndex = (Integer)this.htParams.get("baseModelIndex");
        this.asc.setInfo("noAutoBond", Boolean.TRUE);
        this.asc.setCurrentModelInfo("pdbNoHydrogens", Boolean.TRUE);
        this.asc.setInfo("isPyMOL", Boolean.TRUE);
        if (this.isTrajectory) {
            this.trajectorySteps = new Lst();
        }
        this.isStateScript = this.htParams.containsKey("isStateScript");
        this.sourcePNGJ = this.htParams.containsKey("sourcePNGJ");
        this.doResize = this.checkFilterKey("DORESIZE");
        this.allowSurface = !this.checkFilterKey("NOSURFACE");
        this.doCache = this.checkFilterKey("DOCACHE");
        if (this.doCache && this.sourcePNGJ) {
            this.doCache = false;
        } else if (this.sourcePNGJ && !this.doCache) {
            this.sourcePNGJ = false;
        }
        if (this.doCache) {
            this.bsBytesExcluded = new BS();
        }
        this.logging = false;
        super.initializeReader();
    }

    @Override
    public void processBinaryDocument() throws Exception {
        PickleReader pickleReader = new PickleReader(this.binaryDoc, this.vwr);
        Map<String, Object> map = pickleReader.getMap(this.logging);
        pickleReader = null;
        this.process(map);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
    }

    @Override
    protected void finalizeSubclassReader() throws Exception {
        this.finalizeReaderPDB();
        this.asc.setTensors();
    }

    @Override
    public void finalizeModelSet() {
        this.pymolScene.setReaderObjects();
        if (this.haveMeasurements) {
            this.appendLoadNote(this.vwr.getMeasurementInfoAsString());
            this.setLoadNote();
        }
        if (this.haveScenes) {
            String[] stringArray = new String[this.sceneOrder.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = (String)this.sceneOrder.get(n);
            }
            this.vwr.ms.msInfo.put("scenes", stringArray);
        }
        this.vwr.ms.setTrajectoryBs(BSUtil.newBitSet2(this.baseModelIndex, this.vwr.ms.mc));
        if (!this.isStateScript) {
            this.pymolScene.setFrameObject(0, null);
        }
        if (this.bsBytesExcluded != null) {
            int n = this.bsBytesExcluded.cardinality();
            byte[] byArray = (byte[])this.vwr.fm.getFileAsBytes(this.filePath, null);
            byte[] byArray2 = new byte[byArray.length - n];
            int n2 = this.bsBytesExcluded.nextClearBit(0);
            int n3 = byArray.length;
            int n4 = 0;
            while (n2 < n3) {
                byArray2[n4++] = byArray[n2];
                n2 = this.bsBytesExcluded.nextClearBit(n2 + 1);
            }
            byArray = null;
            String string = this.filePath;
            this.vwr.cachePut(string, byArray2);
        }
    }

    private void process(Map<String, Object> map) {
        int n;
        int n2;
        Lst<Object> lst;
        String string;
        this.pymolVersion = (Integer)map.get("version");
        this.appendLoadNote("PyMOL version: " + this.pymolVersion);
        Lst<Object> lst2 = this.fixSettings(PyMOLReader.getMapList(map, "settings"));
        this.sceneOrder = PyMOLReader.getMapList(map, "scene_order");
        this.haveScenes = this.getFrameScenes(map);
        Lst<Object> lst3 = this.listAt(lst2, 440);
        if (lst3 != null) {
            Logger.info("PyMOL session file: " + lst3.get(2));
        }
        this.setUniqueSettings(PyMOLReader.getMapList(map, "unique_settings"));
        this.pymolScene = new PyMOLScene(this, this.vwr, lst2, this.uniqueSettings, this.pymolVersion, this.haveScenes, this.baseAtomIndex, this.baseModelIndex, this.doCache, this.filePath);
        this.logging = this.vwr.getLogFileName().length() > 0;
        Lst<Object> lst4 = PyMOLReader.getMapList(map, "names");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            Logger.info(string);
            if (!string.equals("names")) continue;
            for (int i = 1; i < lst4.size(); ++i) {
                Lst<Object> lst5 = this.listAt(lst4, i);
                Logger.info("  " + PyMOLReader.stringAt(lst5, 0));
            }
        }
        if (this.logging) {
            if (this.logging) {
                this.vwr.log("$CLEAR$");
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                string = entry.getKey();
                if ("names".equals(string)) continue;
                this.vwr.log("\n===" + string + "===");
                this.vwr.log(PT.rep(entry.getValue().toString(), "[", "\n["));
            }
            this.vwr.log("\n===names===");
            for (int i = 1; i < lst4.size(); ++i) {
                Map.Entry<String, Object> entry;
                this.vwr.log("");
                entry = (Lst)lst4.get(i);
                this.vwr.log(" =" + ((ArrayList)((Object)entry)).get(0).toString() + "=");
                try {
                    this.vwr.log(PT.rep(((AbstractCollection)((Object)entry)).toString(), "[", "\n["));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.addColors(PyMOLReader.getMapList(map, "colors"), this.pymolScene.globalSetting(214) != 0.0f);
        this.allStates = this.pymolScene.globalSetting(49) != 0.0f;
        this.pymolFrame = (int)this.pymolScene.globalSetting(194);
        this.getAtomAndStateCount(lst4);
        this.pymolScene.setStateCount(this.stateCount);
        int n3 = (int)this.pymolScene.globalSetting(193);
        if (!this.isMovie) {
            this.pymolScene.setFrameObject(4115, this.allStates ? Integer.valueOf(-1) : Integer.valueOf(n3 - 1));
        }
        this.appendLoadNote("frame=" + this.pymolFrame + " state=" + n3 + " all_states=" + this.allStates);
        if (!this.isStateScript && this.doResize) {
            String string2;
            int n4 = 0;
            int n5 = 0;
            try {
                n4 = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 0);
                n5 = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 > 0 && n5 > 0) {
                string2 = "PyMOL dimensions width=" + n4 + " height=" + n5;
                this.asc.setInfo("perferredWidthHeight", new int[]{n4, n5});
                this.vwr.resizeInnerPanel(n4, n5);
            } else {
                string2 = "PyMOL dimensions?";
            }
            this.appendLoadNote(string2);
        }
        if (!this.isStateScript && !this.allStates && (lst = PyMOLReader.getMapList(map, "movie")) != null && (n2 = PyMOLReader.intAt(lst, 0)) > 0) {
            this.processMovie(lst, n2);
        }
        if (this.totalAtomCount == 0) {
            this.asc.newAtomSet();
        }
        if (!this.allStates || this.desiredModelNumber != Integer.MIN_VALUE) {
            if (this.isMovie) {
                switch (this.desiredModelNumber) {
                    case -2147483648: {
                        break;
                    }
                    default: {
                        this.desiredModelNumber = this.frames[(this.desiredModelNumber > 0 && this.desiredModelNumber <= this.frames.length ? this.desiredModelNumber : this.pymolFrame) - 1];
                        this.pymolScene.setFrameObject(4115, this.desiredModelNumber - 1);
                        break;
                    }
                }
            } else if (this.desiredModelNumber == 0) {
                this.desiredModelNumber = n3;
            }
        }
        int n6 = lst4.size();
        for (n = 0; n < this.stateCount; ++n) {
            if (!this.doGetModel(++this.nModels, null)) continue;
            this.model(this.nModels);
            this.pymolScene.currentAtomSetIndex = this.asc.iSet;
            if (this.isTrajectory) {
                this.trajectoryStep = new P3[this.totalAtomCount];
                this.trajectorySteps.addLast(this.trajectoryStep);
                this.trajectoryPtr = 0;
            }
            for (int i = 1; i < n6; ++i) {
                this.processObject(this.listAt(lst4, i), true, n);
            }
        }
        for (n = 1; n < n6; ++n) {
            this.processObject(this.listAt(lst4, n), false, 0);
        }
        this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
        if (this.mapObjects != null && this.allowSurface) {
            this.processMeshes();
        }
        if (this.isTrajectory) {
            this.appendLoadNote("PyMOL trajectories read: " + this.trajectorySteps.size());
            this.asc.finalizeTrajectoryAs(this.trajectorySteps, null);
        }
        this.processDefinitions();
        this.processSelectionsAndScenes(map);
        this.pymolScene.finalizeVisibility();
        if (!this.isStateScript) {
            this.vwr.initialize(false);
            this.addJmolScript(this.pymolScene.getViewScript(PyMOLReader.getMapList(map, "view")).toString());
        }
        if (this.ac == 0) {
            this.asc.setInfo("dataOnly", Boolean.TRUE);
        }
        this.pymolScene.offsetObjects();
    }

    private Lst<Object> fixSettings(Lst<Object> lst) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            int n2 = PyMOLReader.intAt((Lst)lst.get(i), 0);
            while (i < n2) {
                Logger.info("PyMOL reader adding null settings #" + i);
                lst.add(i++, new Lst());
                ++n;
            }
        }
        return lst;
    }

    private boolean getFrameScenes(Map<String, Object> map) {
        if (this.sceneOrder == null) {
            return false;
        }
        Map map2 = (Map)map.get("scene_dict");
        for (int i = 0; i < this.sceneOrder.size(); ++i) {
            String string = PyMOLReader.stringAt(this.sceneOrder, i);
            Lst<Object> lst = PyMOLReader.getMapList(map2, string);
            if (lst != null && lst.get(2) != null) continue;
            this.sceneOrder.remove(i--);
        }
        return this.sceneOrder != null && this.sceneOrder.size() != 0;
    }

    private int setUniqueSettings(Lst<Object> lst) {
        this.uniqueSettings = new Hashtable();
        int n = 0;
        if (lst != null && lst.size() != 0) {
            int n2 = lst.size();
            while (--n2 >= 0) {
                Lst lst2 = (Lst)lst.get(n2);
                int n3 = PyMOLReader.intAt(lst2, 0);
                if (n3 > n) {
                    n = n3;
                }
                Lst lst3 = (Lst)lst2.get(1);
                int n4 = lst3.size();
                while (--n4 >= 0) {
                    Lst lst4 = (Lst)lst3.get(n4);
                    int n5 = (n3 << 10) + PyMOLReader.intAt(lst4, 0);
                    this.uniqueSettings.put(n5, lst4);
                    Logger.info("PyMOL unique setting " + n3 + " " + lst4);
                }
            }
        }
        return n;
    }

    private void addColors(Lst<Object> lst, boolean bl) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        int n = lst.size();
        while (--n >= 0) {
            Lst<Object> lst2 = this.listAt(lst, n);
            PyMOL.addColor((Integer)lst2.get(1), bl ? PyMOLScene.colorSettingClamped(lst2) : PyMOLScene.colorSetting(lst2));
        }
    }

    private void getAtomAndStateCount(Lst<Object> lst) {
        int n = 0;
        for (int i = 1; i < lst.size(); ++i) {
            Lst<Object> lst2 = this.listAt(lst, i);
            int n2 = PyMOLReader.intAt(lst2, 4);
            if (!this.checkObject(lst2) || n2 != 1) continue;
            Lst<Object> lst3 = this.listAt(lst2, 5);
            Lst<Object> lst4 = this.listAt(lst3, 4);
            int n3 = lst4.size();
            if (n3 > this.stateCount) {
                this.stateCount = n3;
            }
            int n4 = this.listAt(lst3, 7).size();
            for (int j = 0; j < n3; ++j) {
                Lst<Object> lst5 = this.listAt(lst4, j);
                Lst<Object> lst6 = this.listAt(lst5, 3);
                if (lst6 == null) {
                    this.isTrajectory = false;
                    continue;
                }
                int n5 = lst6.size();
                n += n5;
                if (!this.isTrajectory || n5 == n4) continue;
                this.isTrajectory = false;
            }
        }
        this.totalAtomCount = n;
        Logger.info("PyMOL total atom count = " + this.totalAtomCount);
        Logger.info("PyMOL state count = " + this.stateCount);
    }

    private boolean checkObject(Lst<Object> lst) {
        this.objectName = PyMOLReader.stringAt(lst, 0);
        this.isHidden = PyMOLReader.intAt(lst, 2) != 1;
        return this.objectName.indexOf("_") != 0;
    }

    private void processMovie(Lst<Object> lst, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("frameCount", n);
        hashtable.put("currentFrame", this.pymolFrame - 1);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        Lst<Object> lst2 = this.listAt(lst, 4);
        int n2 = lst2.size();
        while (--n2 >= 0) {
            if (PyMOLReader.intAt(lst2, n2) == 0) continue;
            this.frames = new int[lst2.size()];
            int n3 = this.frames.length;
            while (--n3 >= 0) {
                this.frames[n3] = PyMOLReader.intAt(lst2, n3) + 1;
            }
            hashtable.put("frames", this.frames);
            bl3 = true;
            break;
        }
        Lst<Object> lst3 = this.listAt(lst, 5);
        int n4 = lst3.size();
        while (--n4 >= 0) {
            String string = PyMOLReader.stringAt(lst3, n4);
            if (string == null || string.length() <= 1 || (lst3 = PyMOLReader.fixMovieCommands(lst3)) == null) continue;
            hashtable.put("commands", lst3);
            bl = true;
            break;
        }
        Lst<Object> lst4 = this.listAt(lst, 6);
        int n5 = lst4.size();
        while (--n5 >= 0) {
            Lst<Object> lst5 = this.listAt(lst4, n5);
            if (lst5 == null || lst5.size() < 12 || lst5.get(1) == null) continue;
            bl2 = true;
            if ((lst4 = PyMOLReader.fixMovieViews(lst4)) == null) continue;
            hashtable.put("views", lst4);
            break;
        }
        this.appendLoadNote("PyMOL movie frameCount = " + n);
        if (bl3 && !bl && !bl2) {
            this.isMovie = true;
            this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
            this.pymolScene.setFrameObject(0x400000D0, hashtable);
        }
    }

    private static Lst<Object> fixMovieViews(Lst<Object> lst) {
        return lst;
    }

    private static Lst<Object> fixMovieCommands(Lst<Object> lst) {
        return lst;
    }

    private void processObject(Lst<Object> lst, boolean bl, int n) {
        Cloneable cloneable;
        Object object;
        Lst<Object> lst2;
        if (lst == null) {
            return;
        }
        int n2 = PyMOLReader.intAt(lst, 4);
        Lst lst3 = (Lst)lst.get(lst.size() - 1);
        if (n2 == 1 != bl || !this.checkObject(lst)) {
            return;
        }
        Lst<Object> lst4 = this.listAt(lst, 5);
        Lst<Object> lst5 = null;
        if (n2 == 1) {
            lst2 = this.listAt(lst4, 4);
            object = this.listAt(lst2, n);
            cloneable = this.listAt((Lst<Object>)object, 3);
            if (n > 0 && (cloneable == null || cloneable.size() == 0)) {
                return;
            }
            lst5 = this.listAt((Lst<Object>)object, 7);
        } else if (n > 0) {
            return;
        }
        Logger.info("PyMOL model " + this.nModels + " Object " + this.objectName + (this.isHidden ? " (hidden)" : " (visible)"));
        lst2 = this.listAt(lst4, 0);
        Object object2 = object = lst.size() < 8 ? null : PyMOLReader.stringAt(lst, 6);
        if (" ".equals(object)) {
            object = null;
        }
        this.pymolScene.setReaderObjectInfo(this.objectName, n2, (String)object, this.isHidden, this.listAt(lst2, 8), lst5, bl ? "_" + (n + 1) : "");
        cloneable = null;
        boolean bl2 = this.bsBytesExcluded != null;
        String string = null;
        switch (n2) {
            default: {
                string = "" + n2;
                break;
            }
            case -1: {
                break;
            }
            case 1: {
                bl2 = false;
                cloneable = this.processMolecule(lst4, n);
                break;
            }
            case 4: {
                bl2 = false;
                this.processMeasure(lst4);
                break;
            }
            case 2: 
            case 3: {
                this.processMap(lst4, n2 == 3, false);
                break;
            }
            case 8: {
                this.processGadget(lst4);
                break;
            }
            case 12: {
                if (object != null) break;
                object = "";
                break;
            }
            case 6: {
                string = "CGO";
                this.processCGO(lst4);
                break;
            }
            case 11: {
                string = "ALIGNEMENT";
                break;
            }
            case 9: {
                string = "CALCULATOR";
                break;
            }
            case 5: {
                string = "CALLBACK";
                break;
            }
            case 10: {
                string = "SLICE";
                break;
            }
            case 7: {
                string = "SURFACE";
            }
        }
        if (object != null || cloneable != null) {
            PyMOLGroup pyMOLGroup = this.pymolScene.addGroup(lst, (String)object, n2);
            if (cloneable != null) {
                cloneable = pyMOLGroup.addGroupAtoms((BS)cloneable);
            }
        }
        if (bl2) {
            int n3 = PyMOLReader.intAt(lst3, 0);
            int n4 = PyMOLReader.intAt(lst3, 1);
            this.bsBytesExcluded.setBits(n3, n3 + n4);
            Logger.info("cached PSE file excludes PyMOL object type " + n2 + " name=" + this.objectName + " len=" + n4);
        }
        if (string != null) {
            Logger.error("Unprocessed object type " + string + " " + this.objectName);
        }
    }

    private void processCGO(Lst<Object> lst) {
        int n;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Lst<Object> lst2 = this.listAt(this.listAt(lst, 2), 0);
        String string = this.pymolScene.addCGO(lst2, n = PyMOL.getRGB(PyMOLReader.intAt(this.listAt(lst, 0), 2)));
        if (string != null) {
            this.appendLoadNote("CGO " + string);
        }
    }

    private void processGadget(Lst<Object> lst) {
        if (this.objectName.endsWith("_e_pot")) {
            this.processMap(lst, true, true);
        }
    }

    private void processMap(Lst<Object> lst, boolean bl, boolean bl2) {
        if (bl) {
            if (this.sourcePNGJ) {
                return;
            }
            if (this.isHidden && !bl2) {
                return;
            }
            if (this.mapObjects == null) {
                this.mapObjects = new Lst();
            }
            this.mapObjects.addLast(lst);
        } else {
            if (this.volumeData == null) {
                this.volumeData = new Hashtable<String, Lst<Object>>();
            }
            this.volumeData.put(this.objectName, lst);
            if (!this.isHidden && !this.isStateScript) {
                this.pymolScene.addIsosurface(this.objectName);
            }
        }
        lst.addLast(this.objectName);
    }

    private void processMeasure(Lst<Object> lst) {
        int n;
        int n2;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Logger.info("PyMOL measure " + this.objectName);
        Lst<Object> lst2 = this.listAt(this.listAt(lst, 2), 0);
        int n3 = 1;
        if (lst2.get(1) instanceof Lst) {
            n2 = 2;
        } else {
            n3 = 4;
            if (lst2.get(4) instanceof Lst) {
                n2 = 3;
            } else {
                n3 = 6;
                n2 = n = lst2.get(6) instanceof Lst ? 4 : 0;
            }
        }
        if (n == 0) {
            return;
        }
        Lst<Object> lst3 = this.listAt(lst, 0);
        BS bS = PyMOLReader.getBsReps(this.listAt(lst3, 3));
        Lst<Object> lst4 = this.listAt(lst2, n3);
        Lst<Object> lst5 = this.listAt(lst2, 8);
        boolean bl = lst2.size() > 8;
        int n4 = PyMOLReader.intAt(lst3, 2);
        if (this.pymolScene.addMeasurements(null, n, lst4, bS, n4, lst5, bl)) {
            this.haveMeasurements = true;
        }
    }

    private BS processMolecule(Lst<Object> lst, int n) {
        int n2;
        Lst<Object> lst2 = this.listAt(lst, 4);
        Lst<Object> lst3 = this.listAt(lst2, n);
        Lst<Object> lst4 = this.listAt(lst3, 3);
        int n3 = n2 = lst4 == null ? 0 : lst4.size();
        if (n2 == 0) {
            return null;
        }
        this.ac = this.ac0 = this.asc.ac;
        int n4 = PyMOLReader.intAt(lst, 3);
        if (n4 == 0) {
            return null;
        }
        this.ssMapSeq = new Hashtable<String, BS>();
        if (n == 0) {
            this.processMolCryst(this.listAt(lst, 10));
        }
        Lst<Bond> lst5 = this.getBondList(this.listAt(lst, 6));
        Lst<Object> lst6 = this.listAt(lst, 7);
        this.atomMap = new int[n4];
        BS bS = this.pymolScene.setAtomMap(this.atomMap, this.ac0);
        for (int i = 0; i < 23; ++i) {
            this.reps[i] = BS.newN(1000);
        }
        Lst<Object> lst7 = this.listAt(lst3, 2);
        Lst<Object> lst8 = this.listAt(lst3, 8);
        if (n == 0 || !this.isTrajectory) {
            for (int i = 0; i < n2; ++i) {
                P3 p3 = this.addAtom(lst6, PyMOLReader.intAt(lst4, i), i, lst7, lst8, bS, n);
                if (p3 == null) continue;
                this.trajectoryStep[this.trajectoryPtr++] = p3;
            }
        }
        this.addBonds(lst5);
        this.addMolStructures();
        this.atoms = this.asc.atoms;
        if (!this.isStateScript) {
            this.createShapeObjects();
        }
        this.ssMapSeq = null;
        Logger.info("reading " + (this.ac - this.ac0) + " atoms");
        Logger.info("----------");
        return bS;
    }

    private void processMolCryst(Lst<Object> lst) {
        if (lst == null || lst.size() == 0) {
            return;
        }
        Lst<Object> lst2 = this.listAt(this.listAt(lst, 0), 0);
        Lst<Object> lst3 = this.listAt(this.listAt(lst, 0), 1);
        this.setUnitCell(this.floatAt(lst2, 0), this.floatAt(lst2, 1), this.floatAt(lst2, 2), this.floatAt(lst3, 0), this.floatAt(lst3, 1), this.floatAt(lst3, 2));
        this.setSpaceGroupName(PyMOLReader.stringAt(lst, 1));
    }

    private Lst<Bond> getBondList(Lst<Object> lst) {
        Lst<Bond> lst2 = new Lst<Bond>();
        int n = this.pymolScene.booleanSetting(64) ? 0 : 65536;
        int n2 = lst.size();
        for (int i = 0; i < n2; ++i) {
            Lst<Object> lst3 = this.listAt(lst, i);
            int n3 = PyMOLReader.intAt(lst3, 2);
            if (n3 < 1 || n3 > 3) {
                n3 = 1;
            }
            int n4 = PyMOLReader.intAt(lst3, 0);
            int n5 = PyMOLReader.intAt(lst3, 1);
            n3 = n3 > 1 && n == 0 ? (n3 |= 0x18000) : (n3 |= n);
            Bond bond = new Bond(n4, n5, n3);
            bond.uniqueID = lst3.size() > 6 && PyMOLReader.intAt(lst3, 6) != 0 ? PyMOLReader.intAt(lst3, 5) : -1;
            lst2.addLast(bond);
        }
        return lst2;
    }

    private P3 addAtom(Lst<Object> lst, int n, int n2, Lst<Object> lst2, Lst<Object> lst3, BS bS, int n3) {
        Object object;
        boolean bl;
        String string;
        this.atomMap[n] = -1;
        Lst<Object> lst4 = this.listAt(lst, n);
        int n4 = PyMOLReader.intAt(lst4, 0);
        String string2 = PyMOLReader.stringAt(lst4, 1);
        String string3 = PyMOLReader.stringAt(lst4, 2);
        String string4 = " ";
        String string5 = PyMOLReader.stringAt(lst4, 6);
        String string6 = PyMOLReader.stringAt(lst4, 5);
        if (string6.length() > 3) {
            string6 = string6.substring(0, 3);
        }
        if (string6.equals(" ")) {
            string6 = "UNK";
        }
        if ((string = PyMOLReader.stringAt(lst4, 7)).equals("A")) {
            string = "C";
        }
        boolean bl2 = PyMOLReader.intAt(lst4, 19) != 0;
        int n5 = this.vwr.getChainID(string2, true);
        Atom atom = this.processAtom(new Atom(), string5, string3.charAt(0), string6, n5, n4, string4.charAt(0), bl2, string);
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return null;
        }
        float f = this.floatAt(lst2, n2 *= 3);
        float f2 = this.floatAt(lst2, ++n2);
        float f3 = this.floatAt(lst2, ++n2);
        BoxInfo.addPointXYZ(f, f2, f3, this.xyzMin, this.xyzMax, 0.0f);
        if (this.isTrajectory && n3 > 0) {
            return null;
        }
        boolean bl3 = bl = nucleic.indexOf(string6) >= 0;
        if (bS != null) {
            bS.set(this.ac);
        }
        String string7 = PyMOLReader.stringAt(lst4, 9);
        String string8 = PyMOLReader.stringAt(lst4, 10).substring(0, 1);
        if (n4 >= -1000 && (!string8.equals(" ") || string5.equals("CA") || bl)) {
            BS bS2 = this.ssMapSeq.get(string8);
            if (bS2 == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string8, bS2);
            }
            bS2.set(n4 - -1000);
            string8 = string8 + n5;
            bS2 = this.ssMapSeq.get(string8);
            if (bS2 == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string8, bS2);
            }
            bS2.set(n4 - -1000);
        }
        atom.bfactor = this.floatAt(lst4, 14);
        atom.foccupancy = this.floatAt(lst4, 15);
        atom.radius = this.floatAt(lst4, 16);
        if (atom.radius == 0.0f) {
            atom.radius = 1.0f;
        }
        atom.partialCharge = this.floatAt(lst4, 17);
        int n6 = PyMOLReader.intAt(lst4, 18);
        BS bS3 = PyMOLReader.getBsReps(this.listAt(lst4, 20));
        int n7 = PyMOLReader.intAt(lst4, 21);
        int n8 = PyMOLReader.intAt(lst4, 22);
        int n9 = PyMOLReader.intAt(lst4, 23);
        int n10 = PyMOLReader.intAt(lst4, 24);
        boolean bl4 = PyMOLReader.intAt(lst4, 25) != 0;
        int n11 = lst4.size() > 40 && PyMOLReader.intAt(lst4, 40) == 1 ? PyMOLReader.intAt(lst4, 32) : -1;
        atom.vib = V3.new3(n11, n9, Float.NaN);
        if (lst4.size() > 46) {
            object = PyMOLScene.floatsAt(lst4, 41, new float[8], 6);
            this.asc.setAnisoBorU(atom, (float[])object, 12);
        }
        this.pymolScene.setAtomColor(n7);
        this.processAtom2(atom, n8, f, f2, f3, n6);
        if (!bl4) {
            this.pymolScene.bsNonbonded.set(this.ac);
        }
        if (!string7.equals(" ")) {
            this.pymolScene.bsLabeled.set(this.ac);
            object = this.listAt(lst3, n);
            this.pymolScene.addLabel(this.ac, n11, n7, (Lst<Object>)object, string7);
        }
        if (this.isHidden) {
            this.pymolScene.bsHidden.set(this.ac);
        }
        if (bl) {
            this.pymolScene.bsNucleic.set(this.ac);
        }
        for (int i = 0; i < 21; ++i) {
            if (!bS3.get(i)) continue;
            this.reps[i].set(this.ac);
        }
        if (atom.elementSymbol.equals("H")) {
            this.pymolScene.bsHydrogen.set(this.ac);
        }
        if ((n10 & PyMOL.FLAG_NOSURFACE) != 0) {
            this.pymolScene.bsNoSurface.set(this.ac);
        }
        ++this.ac;
        return null;
    }

    private void addBonds(Lst<Bond> lst) {
        int n = lst.size();
        for (int i = 0; i < n; ++i) {
            Bond bond = (Bond)lst.get(i);
            bond.atomIndex1 = this.atomMap[bond.atomIndex1];
            bond.atomIndex2 = this.atomMap[bond.atomIndex2];
            if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0) continue;
            this.pymolScene.setUniqueBond(this.bondCount++, bond.uniqueID);
            this.asc.addBond(bond);
        }
    }

    private void addMolStructures() {
        this.addMolSS("H", STR.HELIX);
        this.addMolSS("S", STR.SHEET);
        this.addMolSS("L", STR.TURN);
        this.addMolSS(" ", STR.NONE);
    }

    private void addMolSS(String string, STR sTR) {
        if (this.ssMapSeq.get(string) == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Atom[] atomArray = this.asc.atoms;
        BS bS = null;
        BS bS2 = this.pymolScene.getSSMapAtom(string);
        int n4 = this.ac + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        for (int i = this.ac0; i < n4; ++i) {
            if (i == this.ac) {
                n6 = 0;
            } else {
                n5 = atomArray[i].sequenceNumber;
                n6 = atomArray[i].chainID;
                n8 = atomArray[i].atomSetIndex;
            }
            if (n6 != n3 || n8 != n7) {
                n3 = n6;
                n7 = n8;
                bS = this.ssMapSeq.get(string + n6);
                --i;
                if (n < 0) {
                    continue;
                }
            } else {
                if (bS != null && n5 >= -1000 && bS.get(n5 - -1000)) {
                    n2 = i;
                    if (n >= 0) continue;
                    n = i;
                    continue;
                }
                if (n < 0) continue;
            }
            if (sTR != STR.NONE) {
                int n9 = this.bsStructureDefined.nextSetBit(n);
                if (n9 >= 0 && n9 <= n2) continue;
                this.bsStructureDefined.setBits(n, n2 + 1);
                Structure structure = new Structure(n7, sTR, sTR, sTR.toString(), ++this.structureCount, sTR == STR.SHEET ? 1 : 0);
                Atom atom = atomArray[n];
                Atom atom2 = atomArray[n2];
                int n10 = this.asc.getAtomSetAtomIndex(n8);
                structure.set(atom.chainID, atom.sequenceNumber, atom.insertionCode, atom2.chainID, atom2.sequenceNumber, atom2.insertionCode, n - n10, n2 - n10);
                this.asc.addStructure(structure);
            }
            bS2.setBits(n, n2 + 1);
            n = -1;
        }
    }

    private void createShapeObjects() {
        this.pymolScene.createShapeObjects(this.reps, this.allowSurface && !this.isHidden, this.ac0, this.ac);
    }

    private void processMeshes() {
        String string = this.vwr.fm.getFilePath(this.pymolScene.surfaceInfoName, true, false);
        this.vwr.cachePut(string, this.volumeData);
        int n = this.mapObjects.size();
        while (--n >= 0) {
            String string2;
            Object object;
            int n2;
            Lst lst = (Lst)this.mapObjects.get(n);
            String string3 = lst.get(lst.size() - 1).toString();
            boolean bl = string3.endsWith("_e_pot");
            if (bl) {
                n2 = 0x400000C0;
                object = string3.substring(0, string3.length() - 3);
                string2 = (String)object + "map";
                String string4 = this.pymolScene.getObjectID((String)object + "chg");
                if (string4 == null) continue;
                lst.addLast(string4);
                this.pymolScene.mepList = this.pymolScene.mepList + ";" + string4 + ";";
            } else {
                n2 = 1073742018;
                string2 = PyMOLReader.stringAt(this.listAt(this.listAt(lst, 2), 0), 1);
            }
            object = this.volumeData.get(string2);
            if (object == null) continue;
            lst.addLast(string2);
            this.volumeData.put(string3, lst);
            this.volumeData.put("__pymolSurfaceData__", lst);
            if (!this.isStateScript) {
                this.pymolScene.addMesh(n2, lst, string3, bl);
            }
            this.appendLoadNote("PyMOL object " + string3 + " references map " + string2);
        }
    }

    private void processDefinitions() {
        String string = this.vwr.getAtomDefs(this.pymolScene.setAtomDefs());
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        this.appendLoadNote(string);
    }

    private void processSelectionsAndScenes(Map<String, Object> map) {
        if (!this.pymolScene.needSelections()) {
            return;
        }
        Map<String, Lst<Object>> map2 = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "names"));
        if (this.haveScenes) {
            Map map3 = (Map)map.get("scene_dict");
            this.finalizeSceneData();
            Map<String, Lst<Object>> map4 = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "selector_secrets"));
            for (int i = 0; i < this.sceneOrder.size(); ++i) {
                String string = PyMOLReader.stringAt(this.sceneOrder, i);
                Lst<Object> lst = PyMOLReader.getMapList(map3, string);
                if (lst == null) continue;
                this.pymolScene.buildScene(string, lst, map2, map4);
                this.appendLoadNote("scene: " + string);
            }
        }
        this.pymolScene.setCarveSets(map2);
    }

    private void finalizeSceneData() {
        int[] nArray = new int[this.ac];
        int[] nArray2 = new int[this.ac];
        int[] nArray3 = new int[this.ac];
        boolean[] blArray = new boolean[this.ac];
        float[] fArray = new float[this.ac];
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.ac; ++i) {
            nArray[i] = this.getCartoonType(i);
            nArray2[i] = this.getUniqueID(i);
            nArray3[i] = this.getSequenceNumber(i);
            fArray[i] = this.getVDW(i);
            if (n == this.atoms[i].chainID && n2 == this.atoms[i].atomSetIndex) continue;
            blArray[i] = true;
            n = this.atoms[i].chainID;
            n2 = this.atoms[i].atomSetIndex;
        }
        this.pymolScene.setAtomInfo(nArray2, nArray, nArray3, blArray, fArray);
    }

    private static int intAt(Lst<Object> lst, int n) {
        return ((Number)lst.get(n)).intValue();
    }

    private static String stringAt(Lst<Object> lst, int n) {
        String string = lst.get(n).toString();
        return string.length() == 0 ? " " : string;
    }

    private static Lst<Object> getMapList(Map<String, Object> map, String string) {
        return (Lst)map.get(string);
    }

    private static BS getBsReps(Lst<Object> lst) {
        BS bS = new BS();
        int n = Math.min(lst.size(), 21);
        for (int i = 0; i < n; ++i) {
            if (PyMOLReader.intAt(lst, i) != 1) continue;
            bS.set(i);
        }
        return bS;
    }

    private float floatAt(Lst<Object> lst, int n) {
        return PyMOLScene.floatAt(lst, n);
    }

    private Lst<Object> listAt(Lst<Object> lst, int n) {
        return PyMOLScene.listAt(lst, n);
    }

    @Override
    public int getUniqueID(int n) {
        return (int)this.atoms[n].vib.x;
    }

    @Override
    public int getCartoonType(int n) {
        return (int)this.atoms[n].vib.y;
    }

    @Override
    public float getVDW(int n) {
        return this.atoms[n].radius;
    }

    @Override
    public int getSequenceNumber(int n) {
        return this.atoms[n].sequenceNumber;
    }

    @Override
    public boolean compareAtoms(int n, int n2) {
        return this.atoms[n].chainID != this.atoms[n2].chainID;
    }
}

