/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.M4;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.export.MeshData;
import org.jmol.export.__CartesianExporter;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.util.Escape;
import org.jmol.util.GData;
import org.jmol.util.Logger;
import org.jmol.util.MeshSurface;
import org.jmol.viewer.Viewer;

public class _ObjExporter
extends __CartesianExporter {
    private static final boolean debug = false;
    private boolean surfacesOnly = false;
    private boolean normalizeUV = true;
    private OC mtlout;
    String objFileRootName;
    private int nMtlBytes;
    Set<Short> textures = new HashSet<Short>();
    Lst<String> textureFiles;
    private int sphereNum = 1;
    private int cylinderNum = 1;
    private int ellipseNum = 1;
    private int circleNum = 1;
    private int ellipsoidNum = 1;
    private int coneNum = 1;
    private int triangleNum = 1;
    private int surfaceNum = 1;
    private int currentVertexOrigin = 1;
    private int currentNormalOrigin = 1;
    private int currentTextureOrigin = 1;
    private float pixelSize;
    private final P3 ptTemp = new P3();

    public _ObjExporter() {
        this.debugPrint("_WavefrontObjExporter CTOR");
        this.commentChar = "# ";
    }

    protected void debugPrint(String string) {
    }

    @Override
    protected void outputFace(int[] nArray, int[] nArray2, int n) {
    }

    @Override
    protected void outputCircle(P3 p3, P3 p32, float f, short s, boolean bl) {
        this.debugPrint("outputCircle");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        if (bl) {
            this.outputCircle1(p3, p32, s, f);
        }
    }

    @Override
    protected void outputCone(P3 p3, P3 p32, float f, short s) {
        this.debugPrint("outputCone");
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputCone1(p3, p32, f, s);
    }

    @Override
    protected boolean outputCylinder(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return true;
        }
        if (p34 != null) {
            if (by == 2) {
                this.outputEllipse1(p3, p32, p34, p35, s);
                this.tempP3.add2(p3, p3);
                this.tempP3.sub(p34);
                this.outputEllipse1(p3, p33, this.tempP3, p35, s);
            }
        } else if (by == 3) {
            this.outputSphere(p32, f * 1.01f, s, true);
            this.outputSphere(p33, f * 1.01f, s, true);
        } else if (by == 2) {
            this.outputCircle1(p32, p33, s, f);
            this.outputCircle1(p33, p32, s, f);
        }
        this.outputCylinder1(p3, p32, p33, s, by, f, p34, p35);
        return true;
    }

    @Override
    protected void outputEllipsoid(P3 p3, P3[] p3Array, short s) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        A4 a4 = Quat.getQuaternionFrame(p3, p3Array[1], p3Array[3]).toAxisAngle4f();
        float f = p3Array[1].distance(p3);
        float f2 = p3Array[3].distance(p3);
        float f3 = p3Array[5].distance(p3);
        this.outputEllipsoid1(p3, f, f2, f3, a4, s);
    }

    @Override
    protected void outputSphere(T3 t3, float f, short s, boolean bl) {
        if (this.surfacesOnly) {
            this.debugPrint("  Not done owing to surfacesOnly");
            return;
        }
        this.outputEllipsoid1(t3, f, f, f, null, s);
    }

    @Override
    protected void outputTextPixel(P3 p3, int n) {
    }

    @Override
    protected void outputTriangle(T3 t3, T3 t32, T3 t33, short s) {
        if (this.surfacesOnly) {
            return;
        }
        this.outputTriangle1(t3, t32, t33, s);
    }

    @Override
    protected void outputHeader() {
        this.debugPrint("outputHeader");
        this.output("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
    }

    @Override
    protected void output(T3 t3) {
        this.debugPrint("output");
    }

    @Override
    protected void drawSurface(MeshSurface meshSurface, short s) {
        int n;
        if (Logger.debugging) {
            this.debugPrint("outputSurface");
            this.debugPrint("  nVertices=" + meshSurface.vc);
            if (meshSurface.normals == null) {
                this.debugPrint("  no vertex normals");
            } else {
                this.debugPrint("  nNormals=" + meshSurface.vc);
            }
            if (meshSurface.vcs == null) {
                this.debugPrint("  no vertex colors");
            } else {
                this.debugPrint("  nColixes=" + meshSurface.vc);
            }
            this.debugPrint("  number of triangles or quads=" + meshSurface.pc);
            if (meshSurface.pcs == null) {
                this.debugPrint("  no face colors");
            } else {
                this.debugPrint("  nPolygonColixes=" + meshSurface.pc);
            }
            if (meshSurface.bsPolygons == null) {
                this.debugPrint("  all polygons used");
            } else {
                this.debugPrint("  number of polygons used=" + meshSurface.bsPolygons.cardinality());
            }
            this.debugPrint("  solid color=" + this.gdata.getColorArgbOrGray(s));
        }
        BS bS = meshSurface.bsPolygons;
        int n2 = meshSurface.pc;
        if (meshSurface.normals != null) {
            meshSurface.normalCount = meshSurface.vc;
        }
        boolean bl = bS == null;
        int[][] nArray = AU.newInt2(bl ? n2 : bS.cardinality());
        int n3 = n = bl ? n2 - 1 : bS.nextSetBit(0);
        int n4 = 0;
        while (n3 >= 0) {
            int[] nArray2;
            int[] nArray3 = meshSurface.pis[n3];
            int n5 = n4++;
            if (meshSurface.haveQuads) {
                nArray2 = nArray3;
            } else {
                int[] nArray4 = new int[3];
                nArray4[0] = nArray3[0];
                nArray4[1] = nArray3[1];
                nArray2 = nArray4;
                nArray4[2] = nArray3[2];
            }
            nArray[n5] = nArray2;
            n3 = bl ? n3 - 1 : bS.nextSetBit(n3 + 1);
        }
        MeshSurface meshSurface2 = MeshSurface.newMesh(false, meshSurface.vs, meshSurface.vc, nArray, meshSurface.normals, 0);
        meshSurface2.vcs = meshSurface.vcs;
        String string = "Surface" + this.surfaceNum++;
        boolean bl2 = s != 0;
        this.addTexture(s, bl2 ? null : string);
        int[] nArray5 = null;
        if (bl2) {
            this.debugPrint("outputSurface: coloring solid");
            this.debugPrint("  Omitting texture map");
        } else {
            int n6 = nArray.length;
            int n7 = (int)Math.ceil(Math.sqrt(n6));
            int n8 = n6 / n7;
            if (n6 % n7 != 0) {
                // empty if block
            }
            nArray5 = new int[]{n7, ++n8};
            this.debugPrint("  width=" + n7 + " height=" + n8 + " size = " + n7 * n8);
            OC oC = this.createTextureFile(string, meshSurface2, nArray5);
            if (oC == null || oC.getByteCount() == 0) {
                System.out.println("Error creating texture file: " + string);
                this.textureFiles.addLast("Error creating texture file: " + string);
                return;
            }
            this.textureFiles.addLast(oC.getByteCount() + " (" + n7 + "x" + n8 + ") " + string);
            String string2 = oC.getName();
            this.outputMtl(" map_Kd " + string2 + "\n");
            this.outputMtl(" map_Ka " + string2 + "\n");
        }
        M4 m4 = M4.newM4(null);
        m4.setTranslation(V3.newV(meshSurface.offset));
        BS bS2 = new BS();
        this.addMesh(string, meshSurface2, m4, null, s, nArray5, bS2);
    }

    @Override
    boolean initializeOutput(Viewer viewer, double d, GData gData, Map<String, Object> map) {
        this.debugPrint("initializeOutput: + output");
        boolean bl = this.initOutput(viewer, d, gData, map);
        if (!bl) {
            this.debugPrint("End initializeOutput (error in super):");
            return false;
        }
        this.pixelSize = 0.5f / this.scalePixelsPerAngstrom;
        int n = this.fileName.lastIndexOf(".");
        if (n < 0) {
            this.debugPrint("End initializeOutput (Error creating .mtl file):");
            return false;
        }
        this.objFileRootName = this.fileName.substring(0, n);
        try {
            String string = this.objFileRootName + ".mtl";
            this.mtlout = viewer.openExportChannel(d, string, true);
        }
        catch (Exception exception) {
            this.debugPrint("End initializeOutput (" + exception.getMessage() + "):");
            return false;
        }
        this.outputMtl("# Created by Jmol " + Viewer.getJmolVersion() + "\n");
        this.output("\nmtllib " + this.mtlout.getName() + "\n");
        this.textureFiles = new Lst();
        this.debugPrint("End initializeOutput:");
        return true;
    }

    @Override
    String finalizeOutput() {
        this.debugPrint("finalizeOutput");
        String string = this.finalizeOutput2();
        String string2 = this.mtlout.closeChannel();
        if (string2 != null) {
            Logger.info(string2);
            string2 = "ERROR EXPORTING MTL FILE: " + string2;
            if (string.startsWith("OK")) {
                return string2;
            }
            return string + " and " + string2;
        }
        string = string + ", " + this.nMtlBytes + " " + this.mtlout.getFileName();
        for (String string3 : this.textureFiles) {
            string = string + ", " + string3;
        }
        this.debugPrint(string);
        this.debugPrint("End finalizeOutput:");
        return string;
    }

    private void outputMtl(String string) {
        this.nMtlBytes += string.length();
        this.mtlout.append(string);
    }

    private String getTextureName(short s) {
        return "k" + Escape.getHexColorFromRGB(this.gdata.getColorArgbOrGray(s));
    }

    private void outputCircle1(P3 p3, P3 p32, short s, float f) {
        MeshSurface meshSurface = MeshData.getCircleData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Circle" + this.circleNum++;
        m4.setToM3(this.getRotationMatrix(p3, p32, f));
        m4.m03 = p3.x;
        m4.m13 = p3.y;
        m4.m23 = p3.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void outputCone1(P3 p3, P3 p32, float f, short s) {
        MeshSurface meshSurface = MeshData.getConeData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Cone" + this.coneNum++;
        m4.setToM3(this.getRotationMatrix(p3, p32, f));
        m4.m03 = p3.x;
        m4.m13 = p3.y;
        m4.m23 = p3.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private boolean outputEllipse1(P3 p3, P3 p32, P3 p33, P3 p34, short s) {
        MeshSurface meshSurface = MeshData.getCircleData();
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Ellipse" + this.ellipseNum++;
        m4.setToM3(this.getRotationMatrix(p3, p32, 1.0f, p33, p34));
        m4.m03 = p32.x;
        m4.m13 = p32.y;
        m4.m23 = p32.z;
        m4.m33 = 1.0f;
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
        return true;
    }

    private void outputEllipsoid1(T3 t3, float f, float f2, float f3, A4 a4, short s) {
        String string;
        MeshSurface meshSurface = MeshSurface.getSphereData(3);
        this.addTexture(s, null);
        if (t3 instanceof Atom) {
            Atom atom = (Atom)t3;
            string = PT.replaceAllCharacters(atom.getAtomName(), " \t", "") + "_Atom";
        } else {
            string = f == f2 && f == f3 ? "Sphere" + this.sphereNum++ : "Ellipsoid" + this.ellipsoidNum++;
        }
        this.setSphereMatrix(t3, f, f2, f3, a4, this.sphereMatrix);
        this.addMesh(string, meshSurface, this.sphereMatrix, this.sphereMatrix, s, null, null);
    }

    private void outputCylinder1(P3 p3, P3 p32, P3 p33, short s, byte by, float f, P3 p34, P3 p35) {
        MeshSurface meshSurface = MeshData.getCylinderData(false);
        M4 m4 = new M4();
        this.addTexture(s, null);
        String string = "Cylinder" + this.cylinderNum++;
        int n = p34 != null && by == 0 ? 2 : 1;
        for (int i = 0; i < n; ++i) {
            if (p34 == null) {
                m4.setToM3(this.getRotationMatrix(p32, p33, f));
            } else {
                m4.setToM3(this.getRotationMatrix(p3, p33, f, p34, p35));
            }
            m4.m03 = p32.x;
            m4.m13 = p32.y;
            m4.m23 = p32.z;
            m4.m33 = 1.0f;
        }
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void outputTriangle1(T3 t3, T3 t32, T3 t33, short s) {
        MeshSurface meshSurface = MeshData.getTriangleData(t3, t32, t33);
        this.addTexture(s, null);
        String string = "Triangle" + this.triangleNum++;
        M4 m4 = M4.newM4(null);
        this.addMesh(string, meshSurface, m4, m4, s, null, null);
    }

    private void addTexture(short s, String string) {
        Short s2 = s;
        if (string == null && this.textures.contains(s2)) {
            return;
        }
        this.textures.add(s2);
        SB sB = new SB();
        sB.append("\nnewmtl " + (string == null ? this.getTextureName(s) : string) + "\n");
        sB.append(" Ns 163\n");
        sB.append(" Tr " + _ObjExporter.opacityFractionalFromColix(s) + "\n");
        sB.append(" Ni 0.001\n");
        sB.append(" illum 2\n");
        sB.append(" Ka 0.20 0.20 0.20\n");
        sB.append(" Kd " + this.rgbFractionalFromColix(s) + "\n");
        sB.append(" Ks 0.25 0.25 0.25\n");
        this.outputMtl(sB.toString());
    }

    private void addMesh(String string, MeshSurface meshSurface, M4 m4, M4 m42, short s, int[] nArray, BS bS) {
        int n;
        int n2;
        Object object;
        if (this.surfacesOnly && (string == null || !string.startsWith("Surface"))) {
            return;
        }
        this.output("\ng " + string + "\n");
        this.output("usemtl " + (nArray == null ? this.getTextureName(s) : string) + "\n");
        int[][] nArray2 = meshSurface.getFaces();
        int n3 = nArray2.length;
        if (bS != null) {
            object = nArray2;
            n2 = ((int[][])object).length;
            for (int i = 0; i < n2; ++i) {
                int[] nArray3;
                for (int lst : nArray3 = object[i]) {
                    bS.set(lst);
                }
            }
        }
        object = meshSurface.getVertices();
        n2 = meshSurface.vc;
        int[] nArray4 = new int[n2];
        int n5 = this.getCoordinateMap((T3[])object, nArray4, bS);
        this.output("# Number of vertices: " + n5 + "\n");
        this.outputList((T3[])object, n2, m4, "v ", bS);
        n2 = n5;
        T3[] t3Array = meshSurface.normals;
        int n4 = meshSurface.normalCount;
        int[] nArray3 = null;
        Lst<String> lst = null;
        if (t3Array != null) {
            lst = new Lst<String>();
            nArray3 = this.getNormalMap(t3Array, n4, bS, lst);
            n4 = lst.size();
            this.output("# Number of normals: " + n4 + "\n");
            for (n = 0; n < n4; ++n) {
                this.output("vn " + (String)lst.get(n));
            }
        }
        if (nArray != null) {
            this.output("# Number of texture coordinates: " + n3 + "\n");
            n = nArray[0];
            int n6 = nArray[1];
            int n7 = 0;
            block3: for (int i = 0; i < n6; ++i) {
                float f = (float)i + 0.5f;
                if (this.normalizeUV) {
                    f /= (float)n6;
                }
                for (int j = 0; j < n; ++j) {
                    float f2 = (float)j + 0.5f;
                    if (this.normalizeUV) {
                        f2 /= (float)n;
                    }
                    this.output("vt " + f2 + " " + f + "\n");
                    if (++n7 == n3) continue block3;
                }
            }
            if (!this.normalizeUV) {
                this.output("vt 0.0 0.0\n");
                this.output("vt " + (float)n + " " + (float)n6 + "\n");
            }
        }
        this.output("# Number of faces: " + n3 + "\n");
        for (n = 0; n < n3; ++n) {
            if (nArray != null) {
                this.outputFace2(nArray2[n], n, nArray4, nArray3);
                continue;
            }
            this.outputFace1(nArray2[n], nArray4, nArray3);
        }
        if (nArray != null) {
            this.currentTextureOrigin += n3;
        }
        this.currentVertexOrigin += n2;
        this.currentNormalOrigin += n4;
    }

    private void outputList(T3[] t3Array, int n, M4 m4, String string, BS bS) {
        for (int i = 0; i < n; ++i) {
            if (bS != null && !bS.get(i)) continue;
            this.ptTemp.setT(t3Array[i]);
            if (m4 != null) {
                m4.rotTrans(this.ptTemp);
            }
            this.output(string + this.ptTemp.x + " " + this.ptTemp.y + " " + this.ptTemp.z + "\n");
        }
    }

    private void outputFace1(int[] nArray, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n : nArray) {
            this.output(" " + ((nArray2 == null ? n : nArray2[n]) + this.currentVertexOrigin) + "//" + ((nArray3 == null ? n : nArray3[n]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private void outputFace2(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        this.output("f");
        for (int n2 : nArray) {
            this.output(" " + ((nArray2 == null ? n2 : nArray2[n2]) + this.currentVertexOrigin) + "/" + (this.currentTextureOrigin + n) + "/" + ((nArray3 == null ? n2 : nArray3[n2]) + this.currentNormalOrigin));
        }
        this.output("\n");
    }

    private OC createTextureFile(String string, MeshSurface meshSurface, int[] nArray) {
        short[] sArray;
        this.debugPrint("createTextureFile: " + string);
        short[] sArray2 = sArray = meshSurface.pcs == null ? meshSurface.vcs : meshSurface.pcs;
        if (sArray == null || sArray.length == 0) {
            this.debugPrint("createTextureFile: Array problem");
            this.debugPrint("  colixes=" + sArray + " data=" + meshSurface);
            if (sArray != null) {
                this.debugPrint("  colixes.length=" + sArray.length);
            }
            return null;
        }
        int n = meshSurface.pis.length;
        if (n <= 0) {
            this.debugPrint("createTextureFile: nFaces = 0");
            return null;
        }
        int n2 = nArray[0];
        int n3 = nArray[1];
        String string2 = "png";
        int n4 = n3 - 1;
        int n5 = 0;
        P3 p3 = new P3();
        int n6 = n2 * 3;
        int n7 = n3 * 3;
        byte[][] byArray = string2.equals("tga") ? new byte[n7][n6 * 3] : (byte[][])null;
        int[] nArray2 = byArray == null ? new int[n7 * n6] : null;
        P3 p32 = new P3();
        for (int i = 0; i < meshSurface.pis.length; ++i) {
            int n8;
            if (meshSurface.pcs == null) {
                int[] nArray3 = meshSurface.pis[i];
                p3.set(0.0f, 0.0f, 0.0f);
                for (int n9 : nArray3) {
                    p3.add(CU.colorPtFromInt(this.gdata.getColorArgbOrGray(sArray[n9]), p32));
                }
                p3.scale(1.0f / (float)nArray3.length);
                n8 = CU.colorPtToFFRGB(p3);
            } else {
                n8 = this.gdata.getColorArgbOrGray(sArray[i]);
            }
            if (byArray == null) {
                for (int j = 0; j < 3; ++j) {
                    for (int k = 0; k < 3; ++k) {
                        nArray2[(n4 * 3 + k) * n6 + n5 * 3 + j] = n8;
                    }
                }
            }
            if ((n5 = (n5 + 1) % n2) != 0) continue;
            --n4;
        }
        try {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            String string3 = this.fileName;
            if (nArray2 != null) {
                hashtable.put("rgbbuf", nArray2);
                hashtable.put("fileName", this.objFileRootName + "_" + string + "." + string2);
                hashtable.put("type", string2);
                hashtable.put("width", n6);
                hashtable.put("height", n7);
                string3 = this.fileName = this.vwr.outputToFile(hashtable);
            }
            this.debugPrint("End createTextureFile: " + string3);
            return (OC)hashtable.get("outputChannel");
        }
        catch (Exception exception) {
            this.debugPrint("End createTextureFile (" + exception.getMessage() + "):");
            return null;
        }
    }
}

