/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolNMRInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Model;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

public class NMRCalculation
implements JmolNMRInterface {
    private static final int MAGNETOGYRIC_RATIO = 1;
    private static final int QUADRUPOLE_MOMENT = 2;
    private static final double e_charge = 1.60217646E-19;
    private static final double h_planck = 6.62606957E-34;
    private static final double h_bar_planck = 1.0545717253362894E-34;
    private static final double DIPOLAR_FACTOR = 1054.5717253362893;
    private static final double J_FACTOR = 0.0167840302932219;
    private static final double Q_FACTOR = 2.349647144641375E8;
    private Viewer vwr;
    private Map<String, double[]> isotopeData;
    private static final String resource = "nmr_data.txt";
    private Map<String, Float> shiftRefsPPM = new Hashtable<String, Float>();

    public JmolNMRInterface setViewer(Viewer viewer) {
        this.vwr = viewer;
        this.getData();
        return this;
    }

    public float getQuadrupolarConstant(Tensor tensor) {
        if (tensor == null) {
            return 0.0f;
        }
        Atom atom = this.vwr.ms.at[tensor.atomIndex1];
        return (float)(this.getIsotopeData(atom, 2) * (double)tensor.eigenValues[2] * 2.349647144641375E8);
    }

    private Lst<Tensor> getInteractionTensorList(String string, BS bS) {
        if (string != null) {
            string = string.toLowerCase();
        }
        BS bS2 = this.vwr.ms.getModelBS(bS, false);
        BS bS3 = this.getAtomSiteBS(bS);
        int n = bS3.cardinality() == 1 ? bS3.nextSetBit(0) : -1;
        Lst lst = new Lst();
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            Lst lst2 = (Lst)this.vwr.ms.getInfo(n2, "interactionTensors");
            if (lst2 != null) {
                int n3 = lst2.size();
                for (int i = 0; i < n3; ++i) {
                    Tensor tensor = (Tensor)lst2.get(i);
                    if (string != null && (!tensor.type.equals(string) || !tensor.isSelected(bS3, n))) continue;
                    lst.addLast((Object)tensor);
                }
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
        return lst;
    }

    private BS getAtomSiteBS(BS bS) {
        if (bS == null) {
            return null;
        }
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        Model[] modelArray = this.vwr.ms.am;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bS.get(n)) {
                Atom atom = atomArray[n];
                bS2.set(modelArray[atom.mi].firstAtomIndex - 1 + atom.atomSite);
            }
            n = bS.nextSetBit(n + 1);
        }
        return bS2;
    }

    public BS getUniqueTensorSet(BS bS) {
        BS bS2 = new BS();
        Atom[] atomArray = this.vwr.ms.at;
        int n = this.vwr.ms.mc;
        while (--n >= 0) {
            BS bS3 = this.vwr.getModelUndeletedAtomsBitSet(n);
            bS3.and(bS);
            if (this.vwr.ms.getUnitCell(n) == null) continue;
            int n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                if (atomArray[n2].atomSite != atomArray[n2].i + 1) {
                    bS3.clear(n2);
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
            bS2.or(bS3);
            n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                Object[] objectArray = atomArray[n2].getTensors();
                if (objectArray != null) {
                    int n3 = objectArray.length;
                    while (--n3 >= 0) {
                        Tensor tensor = (Tensor)objectArray[n3];
                        if (tensor == null) continue;
                        int n4 = bS3.nextSetBit(n2 + 1);
                        while (n4 >= 0) {
                            Object[] objectArray2 = atomArray[n4].getTensors();
                            if (objectArray2 != null) {
                                int n5 = objectArray2.length;
                                while (--n5 >= 0) {
                                    if (!tensor.isEquiv((Tensor)objectArray2[n5])) continue;
                                    bS3.clear(n4);
                                    bS2.clear(n4);
                                    break;
                                }
                            }
                            n4 = bS3.nextSetBit(n4 + 1);
                        }
                    }
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    public float getJCouplingHz(Atom atom, Atom atom2, String string, Tensor tensor) {
        return this.getIsoOrAnisoHz(true, atom, atom2, string, tensor);
    }

    public float getIsoOrAnisoHz(boolean bl, Atom atom, Atom atom2, String string, Tensor tensor) {
        if (tensor == null) {
            if ((string = this.getISCtype(atom, string)) == null || atom.mi != atom2.mi) {
                return 0.0f;
            }
            BS bS = new BS();
            bS.set(atom.i);
            bS.set(atom2.i);
            Lst<Tensor> lst = this.getInteractionTensorList(string, bS);
            if (lst.size() == 0) {
                return Float.NaN;
            }
            tensor = (Tensor)lst.get(0);
        } else {
            atom = this.vwr.ms.at[tensor.atomIndex1];
            atom2 = this.vwr.ms.at[tensor.atomIndex2];
        }
        return (float)(this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) * (double)(bl ? tensor.isotropy() : tensor.anisotropy()) * 0.0167840302932219);
    }

    private String getISCtype(Atom atom, String string) {
        Lst lst = (Lst)this.vwr.ms.getInfo((int)atom.mi, "interactionTensors");
        if (lst == null) {
            return null;
        }
        string = string == null ? "" : string.toLowerCase();
        int n = -1;
        n = string.indexOf("_hz");
        if (n >= 0 || (n = string.indexOf("_khz")) >= 0 || (n = string.indexOf("hz")) >= 0 || (n = string.indexOf("khz")) >= 0) {
            string = string.substring(0, n);
        }
        if (string.length() == 0) {
            string = "isc";
        }
        return string;
    }

    public float getDipolarConstantHz(Atom atom, Atom atom2) {
        float f;
        if (Logger.debugging) {
            Logger.debug((String)(atom + " g=" + this.getIsotopeData(atom, 1) + "; " + atom2 + " g=" + this.getIsotopeData(atom2, 1)));
        }
        return (f = (float)(-this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) / Math.pow(atom.distance((T3)atom2), 3.0) * 1054.5717253362893)) == 0.0f || atom == atom2 ? Float.NaN : f;
    }

    public float getDipolarCouplingHz(Atom atom, Atom atom2, V3 v3) {
        V3 v32 = V3.newVsub((T3)atom2, (T3)atom);
        double d = v32.length();
        double d2 = (double)v32.dot((T3)v3) / d / (double)v3.length();
        return (float)((double)this.getDipolarConstantHz(atom, atom2) * (3.0 * d2 - 1.0) / 2.0);
    }

    private double getIsotopeData(Atom atom, int n) {
        int n2 = atom.getIsotopeNumber();
        String string = atom.getElementSymbolIso(false);
        double[] dArray = this.isotopeData.get(n2 == 0 ? string : "" + n2 + string);
        return dArray == null ? 0.0 : dArray[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getData() {
        BufferedReader bufferedReader = null;
        try {
            String string;
            boolean bl = Logger.debugging;
            bufferedReader = FileManager.getBufferedReaderForResource((Viewer)this.vwr, (Object)this, (String)"org/jmol/quantum/", (String)resource);
            this.isotopeData = new Hashtable<String, double[]>();
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    Logger.info((String)string);
                }
                if (string.indexOf("#") >= 0) continue;
                String[] stringArray = PT.getTokens((String)string);
                String string2 = stringArray[0];
                String string3 = stringArray[2] + string2;
                if (bl) {
                    Logger.info((String)(string2 + " default isotope " + string3));
                }
                for (int i = 3; i < stringArray.length; i += 3) {
                    int n = Integer.parseInt(stringArray[i]);
                    String string4 = n + string2;
                    double[] dArray = new double[]{n, Double.parseDouble(stringArray[i + 1]), Double.parseDouble(stringArray[i + 2])};
                    if (bl) {
                        Logger.info((String)(string4 + "  " + Escape.eAD((double[])dArray)));
                    }
                    this.isotopeData.put(string4, dArray);
                }
                double[] dArray = this.isotopeData.get(string3);
                if (dArray == null) {
                    Logger.error((String)("Cannot find default NMR data in nmr_data.txt for " + string3));
                    throw new NullPointerException();
                }
                dArray[0] = -dArray[0];
                this.isotopeData.put(string2, dArray);
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Exception " + exception.toString() + " reading " + resource));
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public Object getInfo(String string) {
        if (string.equals("all")) {
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            hashtable.put("isotopes", this.isotopeData);
            hashtable.put("shiftRefsPPM", this.shiftRefsPPM);
            return hashtable;
        }
        if (PT.isDigit((char)string.charAt(0))) {
            return this.isotopeData.get(string);
        }
        Lst lst = new Lst();
        for (Map.Entry<String, double[]> entry : this.isotopeData.entrySet()) {
            String string2 = entry.getKey();
            if (!PT.isDigit((char)string2.charAt(0)) || !string2.endsWith(string)) continue;
            lst.addLast((Object)entry.getValue());
        }
        return lst;
    }

    public float getChemicalShift(Atom atom) {
        float f = this.getMagneticShielding(atom);
        if (Float.isNaN(f)) {
            return f;
        }
        Float f2 = this.shiftRefsPPM.get(atom.getElementSymbol());
        return (f2 == null ? 0.0f : f2.floatValue()) - f;
    }

    public float getMagneticShielding(Atom atom) {
        Tensor tensor = this.vwr.ms.getAtomTensor(atom.i, "ms");
        return tensor == null ? Float.NaN : tensor.isotropy();
    }

    public boolean getState(SB sB) {
        if (this.shiftRefsPPM.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Float> entry : this.shiftRefsPPM.entrySet()) {
            sB.append("  set shift_").append(entry.getKey()).append(" ").appendO((Object)entry.getValue()).append("\n");
        }
        return true;
    }

    public boolean setChemicalShiftReference(String string, float f) {
        if (string == null) {
            this.shiftRefsPPM.clear();
            return false;
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        this.shiftRefsPPM.put(string, Float.valueOf(f));
        return true;
    }

    public Lst<Object> getTensorInfo(String string, String string2, BS bS) {
        int n;
        boolean bl;
        boolean bl2;
        if ("".equals(string)) {
            string = null;
        }
        string2 = string2 == null ? ";all." : ";" + string2 + ".";
        Lst lst = new Lst();
        if (";dc.".equals(string2)) {
            Atom[] atomArray = this.vwr.ms.at;
            int n2 = bS.nextSetBit(0);
            while (n2 >= 0) {
                int n3 = bS.nextSetBit(n2 + 1);
                while (n3 >= 0) {
                    Lst lst2 = new Lst();
                    lst2.addLast((Object)atomArray[n2].i);
                    lst2.addLast((Object)atomArray[n3].i);
                    lst2.addLast((Object)Float.valueOf(this.getDipolarConstantHz(atomArray[n2], atomArray[n3])));
                    lst.addLast((Object)lst2);
                    n3 = bS.nextSetBit(n3 + 1);
                }
                n2 = bS.nextSetBit(n2 + 1);
            }
            return lst;
        }
        if (string == null || string.startsWith("isc")) {
            bl2 = string2.equals(";j.");
            bl = string2.equals(";eta.");
            Lst<Tensor> lst3 = this.getInteractionTensorList(string, bS);
            int n4 = lst3 == null ? 0 : lst3.size();
            for (n = 0; n < n4; ++n) {
                Tensor tensor = (Tensor)lst3.get(n);
                Lst lst4 = new Lst();
                lst4.addLast((Object)tensor.atomIndex1);
                lst4.addLast((Object)tensor.atomIndex2);
                lst4.addLast(bl || bl2 ? Float.valueOf(this.getIsoOrAnisoHz(bl2, null, null, null, tensor)) : tensor.getInfo(string2));
                lst.addLast((Object)lst4);
            }
            if (string != null) {
                return lst;
            }
        }
        bl2 = string != null && string.startsWith("efg") && string2.equals(";chi.");
        bl = bl2 || Tensor.isFloatInfo((String)string2);
        int n5 = bS.nextSetBit(0);
        while (n5 >= 0) {
            Tensor tensor;
            if (string == null) {
                tensor = this.vwr.ms.getAtomTensorList(n5);
                if (tensor != null) {
                    for (n = 0; n < ((Tensor)tensor).length; ++n) {
                        lst.addLast(tensor[n].getInfo(string2));
                    }
                }
            } else {
                tensor = this.vwr.ms.getAtomTensor(n5, string);
                lst.addLast(tensor == null ? (bl ? Float.valueOf(0.0f) : "") : (bl2 ? Float.valueOf(this.getQuadrupolarConstant(tensor)) : tensor.getInfo(string2)));
            }
            n5 = bS.nextSetBit(n5 + 1);
        }
        return lst;
    }

    public Map<String, Integer> getMinDistances(MeasurementData measurementData) {
        BS bS = (BS)measurementData.points.get(0);
        int n = bS.cardinality();
        if (n == 0 || !(measurementData.points.get(1) instanceof BS)) {
            return null;
        }
        BS bS2 = (BS)measurementData.points.get(1);
        int n2 = bS2.cardinality();
        if (n < 2 && n2 < 2) {
            return null;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.vwr.ms.at;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            String string = atom.getAtomName();
            int n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom2 = atomArray[n4];
                int n5 = (int)(atom2.distanceSquared((T3)atom) * 100.0f);
                if (n5 != 0) {
                    String string2 = atom2.getAtomName();
                    String string3 = string.compareTo(string2) < 0 ? string + string2 : string2 + string;
                    Integer n6 = (Integer)hashtable.get(string3);
                    if (n6 == null) {
                        n6 = n5;
                        hashtable.put(string3, n6);
                    } else if (n5 < n6) {
                        hashtable.put(string3, n5);
                    }
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return hashtable;
    }
}

