/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.nbo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.border.TitledBorder;
import org.jmol.i18n.GT;
import org.jmol.viewer.Viewer;
import org.openscience.jmol.app.jmolpanel.GuiMap;
import org.openscience.jmol.app.jmolpanel.JmolPanel;
import org.openscience.jmol.app.nbo.NBOPanel;
import org.openscience.jmol.app.nbo.NBOService;

abstract class NBODialogConfig
extends JDialog {
    protected static final String sep = System.getProperty("line.separator");
    protected static final String DEFAULT_PARAMS = "PLOT CMO DIPOLE STERIC";
    protected static final int PANEL_RIGHT = -1;
    protected static final int PANEL_CENTER = -2;
    protected static final int PANEL_TOP = -3;
    protected static final int PANEL_MODEL_SELECT = 1;
    protected static final int PANEL_RUN_SELECT = 2;
    protected static final int PANEL_VIEW_SELECT = 3;
    protected static final int PANEL_SEARCH_SELECT = 4;
    protected static final int PANEL_RUN_FILE = 5;
    protected static final int PANEL_SEARCH_CENTER = 6;
    protected static final int PANEL_STATUS = 7;
    protected static final int PANEL_SEARCH_OUT = 0;
    protected NBOPanel topPanel;
    protected NBOPanel statusPanel;
    protected NBOService nboService;
    protected boolean haveService;
    boolean isJmolNBO;
    protected Viewer vwr;
    protected JButton nboPathButton;
    protected JButton browse;
    protected JButton helpBtn;
    protected JButton modelButton;
    protected JButton runButton;
    protected JButton viewButton;
    protected JButton searchButton;
    protected JButton[] mainButtons;
    protected JTextField Field;
    protected JTextField dataPathLabel;
    protected JTextField serverPathLabel;
    protected JScrollPane editPane2;
    protected JLabel statusLab = new JLabel();
    protected JComboBox<String> action;
    protected JComboBox<String> module;
    protected JTextPane fileText;
    protected JButton go;
    protected String reqInfo;
    protected JTextPane jpNboOutput;
    protected String jobStem;
    JLabel icon;
    protected Font nboFont = new Font("Monospaced", 1, 16);
    protected JTextField tfFolder;
    protected JTextField tfName;
    protected JTextField tfExt;
    protected int jmolAtomCount;
    protected File inputFile;
    protected String workingPath;
    protected Runnable showWorkPathDone = new Runnable(){

        @Override
        public void run() {
            NBODialogConfig.this.nboService.runScriptNow("load " + NBODialogConfig.this.inputFile.toString());
            NBODialogConfig.this.nboService.runScriptNow("refresh");
        }
    };
    protected static String helpConfig;
    protected static final String helpModel = "NBOModel COMMAND SYNTAX\n \nCommand verbs are case-insensitive and canbe abbreviated by the leading unique characters.Arguments are separated by commas or spaces.Parameters are attached to the command verbafter a dot (viz., DRAW.ap MODEL).  Argumentsand parameters are case-insensitive, exceptfor chemical formulas and group acronyms.Use 'HELP <command>' (e.g., 'HELP SHOW') forfurther specifics of each COMMAND type.\n \nCOMMAND(.t)   arguments\n------------------------------------\nALTER         IA [IB IC ID] newvalue\nCLIP          IA IB\nDRAW          filename\nFUSE(.R)      IA IB\nHELP          command\nLINK          IA IB\nMUTATE        IA formula\nREBOND        IA symtype\nROTATE        AXIS angle\nSAVE.t        filename\nSHOW          formula\nSWITCH        IA IB\nSYMMETRY\nTRANSLATE     AXIS shift\nTWIST         IA IB IC ID newvalue\nUNIFY         CFI1 CFI2 IA1 IB1 IA2 IB2 dist\nUSE.t         filename\nVALUE         IA [IB IC ID]\n3CHB          IA IB :Ligand\n";
    protected static final String alterHelp = "ALTER IA newval     (nuclear charge of atom IA)\n      IA IB newval          (bond length IA-IB)\n      IA IB IC newval  (valence angle IA-IB-IC)\n      IA IB IC ID newval (dihedral IA-IB-IC-IC)\n \nExamples:\n ALTER 10 14.   [change atom 10 to Si (Z = 14)]\n ALTER  2 5 1.69  [change R(5-8) bond to 1.69A]\n ALTER  1 2 3 4 180.   [change 1-2-3-4 dihedral\n                          angle to 180 degrees]\n \nNote that 'ALTER 1 2 3 4 180.' changes ONLYthe 1-2-3-4 dihedral (often giving unphysicaldistorted geometry).  Use 'TWIST 1 2 3 4 180.'to form a proper torsional rotamer.\n \nUse VFILE to determine which angles can besafely ALTERed.  Otherwise, the coordinatesmay be re-defined, with unexpected effectson other variables.";
    protected static final String clipHelp = "CLIP IA IB          (erase bond between IA, IB)\n \nExample:\n CLIP 1 2        [erase bond between atoms 1,2]\n \nNote that CLIP takes no account of electronicrequirements for a Lewis-compliant model.";
    protected static final String fuseHelp = "FUSE IA,IB       (remove IA,IB and join the two\n                'dangling' sites by a new bond)\n \nAllowed parameter:\n .r = ring-forming (conformational search)\n \nExamples:\n FUSE 4 12    [remove atoms 4, 12 and draw a new\n          bond between resulting radical centers\n          (e.g., 3-11), with no geometry change]\n FUSE.r 4 12      [similar, but a conformational\n            search is performed to find the most\n                 suitable ring-closing geometry]\n \nNote that IA, IB must have similar valency, so\nthe resulting structure remains Lewis-compliant.\n";
    protected static final String linkHelp = "LINK IA IB  (draw a 'bond' between atoms IA, IB)\nExamples:\n LINK 3 17    [draws a 'bond: between atoms 3-17\nNote that this command (unlike FUSE) takes no\naccount of chemical reasonability.\n";
    protected static final String mutateHelp = "MUTATE IA formula (replace atom IA by the group\n               of specified chemical 'formula',\n             if both are of consistent valency)\n \nExample:\n MUTATE 4 CH3     [remove monovalent atom 4 and\n           attach a methyl (CH3) radical in its\n         place, preserving valence consistency]\n";
    protected static final String rebondHelp = "REBOND IA symtype   (select a new Lewis valence\n                   isomer of 'symtype' symmetry\n                   at transition metal atom IA)\n \nAllowed 'symtype' parameters (TM species only):\n \n ML6 bonding: c3vo      ('Outer' C3v [default])\n              c3vi       ('Inner' C3v symmetry)\n              c5vo       ('Outer' C5v symmetry)\n              c5vi       ('Inner' C5v symmetry)\n \n ML5 bonding: c4vo      ('Outer' C4v [default])\n              c4vi       ('Inner' C4v symmetry)\n \n ML4 bonding: td        (Td symmetry [default])\n              c3vi       ('Inner' C3v symmetry)\n              c4v        (C4v symmetry)\nExample:\n SHOW WH6       [Tungsten hexahydride, in ideal\n                        'c3vo' isomer geometry]\n REBOND 2 c5vi     [reform preceding WH6 isomer\n                     to alternative 'inner C5v'\n                         geometry at TM atom 2]\n";
    protected static final String saveHelp = "SAVE.t filename     (save current model as file\n              'filename' of type 't' extension)\n \nParameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .mm  = MM2 molecular mechanics file (.mm2)\n .mnd = AM1/MINDO-type input file (.mnd)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n SAVE.G job   [save Gaussian-type 'job.gau' file]\n";
    protected static final String showHelp = "SHOW <formula> (create a molecule model from\n                its 'formula')\nSHOW <acceptor> <donor-1> <donor-2>...\n               (create supramolecular model from\n                radical 'acceptor' and ligand\n                'donor-i' formulas)\nThe chemical 'formula' is a valid Lewis-typeline formula, similar to textbook examples.Use colons to denote multiple bonds (C::O doublebond, C:::N triple bond, etc.) and parenthesesto identify repeat units or side groups.Atomic symbols in the range H-Cf (Z = 1-98)and repetition numbers 1-9 are allowed.Chemical formula symbols are case-sensitive.\n \nLigated free radicals (with free-valent acceptorsites) can also be formed in specified hapticitymotifs with chosen molecular ligands. Radical<acceptor> and ligand <donor-i> monomers arespecified by valid line formulas, with eachligand <donor> formula preceded by a number ofcolons (:) representing the number of 2e sitesin the desired ligand denticity (such as ':NH3'for monodentate ammine ligand, '::NH2CH::CH2'for bidentate vinylamine ligand, or ':::Bz' fortridentate benzene ligand). Each such ligationsymbol may be prefixed with a stoichiometriccoefficient 2-9 for the number of ligands.\n \nIn both molecular and supramolecular formulas,valid transition metal duodectet structuresare also accepted. For d-block molecular species,the default idealized metal hybridization isomercan be altered with the REBOND command.For d-block species one can also includecoordinative ligands (:Lig), enclosed inparentheses and preceded by a colon symbol.Formal 'ylidic' charges are allowed only foradjacent atom pairs (e.g., dative pi-bonds).\n \nModels may also be specified by using acronymsfrom a library of pre-formed species (manyat B3LYP/6-31+G* optimized level). Each suchacronym can also be used as a monovalent ligandin MUTATE commands, as illustrated below.\n \nCommon cyclic aromatic species\n Bz        C6H6   benzene\n A10R2L    C10H8  naphthalene\n A14R3L    C14H12 anthracene\n A18R4L    C18H16 tetracene\n A22R5L    C22H20 pentacene\n A14R3     C14H10 phenanthrene\n A14R4     C14H12 chrysene\n A16R4     C16H10 pyrene\n A18R4     C18H12 triphenylene\n A20R5     C20H12 benzopyrene\n A20R6     C20H10 corannulene\n A24R7     C24H12 coronene\n A32R10    C32H14 ovalene\nCommon cyclic saturated species\n R6C       C6H12 cyclohexane (chair)\n R6B         '        '      (boat t.s.) \n R6T         '        '      (twist-boat)\n R5        C5H10 cyclopentane\n R4        C4H8  cyclobutane\n R3        C3H6  cyclopropane\n RB222     [2,2,2]bicyclooctane\n RB221     [2,2,1]bicycloheptane (norbornane)\n RB211     [2,1,1]bicyclohexane\n RB111     [1,1,1]bicyclopentane (propellane)\n R5S       spiropentane\n RAD       adamantane\n \nCommon inorganic ligands\n acac   acetylacetonate anion   (bidentate)\n bipy   2,2\"\"-bipyridine         (bidentate)\n cp     cyclopentadienyl anion  (:, ::, :::)\n dien   diethylenetriamine      (tridentate)\n dppe   1,2-bis(diphenylphosphino)ethane\n                                (bidentate)\n edta   ethylenediaminetetraacetate anion\n                                (hexadentate)\n en     ethylenediamine         (bidentate)\n phen   1,10-phenanthroline     (bidentate)\n tren   tris(2-aminoethyl)amine (tetradentate)\n trien  triethylenetetramine    (tetradentate)\n \nPeptide fragments (HC::ONHCH2R)\n GLY       glycine\n ALA       alanine\n VAL       valine\n LEU       leucine\n ILE       isoleucine\n PRO       proline\n PHE       phenylalanine\n TYR       tyrosine\n TRP       tryptophan\n SER       serine\n THR       threonine\n CYS       cysteine\n MET       methionine\n ASN       asparagine\n GLN       glutamine\n ASP       aspartate\n GLU       glutamate\n LYS       lysine\n ARG       argenine\n HIS       histidine\n \nNucleic acid fragments\n NA_G      guanine\n NA_C      cytosine\n NA_A      adenine\n NA_T      thymine\n NA_U      uracil\n NA_R      ribose backbone fragment\n \nIn addition, the SHOW command recognizes\n'D3H' (trigonal bipyramid) or 'D4H' (octahedral)\nspecies, created as SF5, SF6, respectively.\n \n('SHOW' and 'FORM' are synonymous commands.) \nMolecular examples:\n SHOW CH3C::OOH      acetic acid\n SHOW CH3(CH2)4CH3   n-hexane\n SHOW WH2(:NH3)2     diammine of WH2\n SHOW NA_C           cytosine\n SHOW CH4            methane\n  MUTATE 3 RAD       methyladamantane\n SHOW ALA            alanine\n  MUTATE 7 ALA       ala-ala\n  MUTATE 17 ALA      ala-ala-ala, etc.\nSupramolecular examples:\n SHOW CH3 :H2O       hydrated methyl radical\n SHOW Cr 2:::Bz      dibenzene chromium\n SHOW CrCl3 2:H2O :NH3\n SHOW Cr 3::acac\n SHOW Cr ::::::edta\n";
    protected static final String switchHelp = "SWITCH IA IB      [switch atoms IA, IB (and\n                  attached groups) to invert\n                  configuration at an attached\n                  stereocenter.]\nExample:\n SHOW ALA         (L-alanine)\n SWITCH 6 7       (switch to D-alanine)\n";
    protected static final String symHelp = "SYMMETRY           (determine point group)\n \nNote that exact point-group symmetry is amathematical idealization. NBOModel recognizes'effective' symmetry, adequate for chemicalpurposes even if actual atom positions deviateslightly (say, ~0.02A) from idealized symmetry.";
    protected static final String twistHelp = "TWIST IA IB IC IC newval\n              IA-IB-IC-ID angle to 'newval')\n \nExample:\n SHOW C2H6          ethane (staggered)\n TWIST 1 2 3 4 0.   ethane (eclipsed)\n";
    protected static final String unifyHelp = "UNIFY CFI-1 CFI-2 IA1 IB1 IA2 IB2 dist\n          (form a complex from molecules in\n           cfiles CFI-1, CFI-2, chosen to have\n           linear IA1-IB1-IB2-IA2 alignment\n           and IA1-IA2 separation 'dist')\n \nCFI-1 and CFI-2 are two CFILES (previously\ncreated with SAVE.C); IA1, IB1 are two atoms\nof CFI-1 and IA2, IB2 are two atoms of CFI-2\nthat will be 'unified' in linear IA1-IB1-IB2-IA2\narrangement, with specified IA1-IA2 'dist'.\n \nExample:\n SHOW H2C::O       (create formaldehyde)\n SAVE.C H2CO       (save H2CO.cfi)\n SHOW NH3          (create ammonia)\n SAVE.C NH3        (save NH3.cfi)\n UNIFY H2CO.cfi NH3.cfi 2 3 1 2 4.3\n                   (creates H-bonded complex)\n";
    protected static final String useHelp = "USE.t filename  (use file 'filename' of type 't'\n                 to initiate a modeling session)\n \n't' parameters: \n .v   = valence coordinate VFILE ([.vfi])\n .c   = cartesian coordinate CFILE (.cfi)\n .a   = NBO archive file (.47)\n .adf = ADF input file (.adf)\n .g   = Gaussian input file (.gau)\n .gms = GAMESS input file (.gms)\n .jag = Jaguar input file (.jag)\n .l   = Gaussian log file (.log)\n .mp  = Molpro input file (.mp)\n .nw  = NWChem input file (.nw)\n .orc = Orca input file (.orc)\n .pqs = PQS input file (.pqs)\n .qc  = Q-Chem input file (.qc)\nExample:\n USE.G ACETIC   (use Gaussian-type ACETIC.GAU\n                input file to start session)\n";
    protected static final String chbHelp = "3CHB IA IB :Lig     (form 3-center hyperbond\n                    IA-IB-Lig to ligand :Lig)\nExamples:\n SHOW W(:NH3)3      (normal-valent W triammine)\n 3CHB  1 2 :NH3     (hyperbonded N-W-N triad)\n SHOW H2O           (water monomer)\n 3CHB  2 3 :OH2     (H-bonded water dimer)\n";
    protected static final String searchHelp = "             NBOSearch: COMMAND SYNTAX AND PROGRAM OVERVIEW\nPROGRAM OVERVIEW:\nFollow menu prompts through the decision tree to the keyword module and datum of interest. Each menu appears with 'Current [V-list] settings' and a scrolling list of output values. All output lines are also echoed to an external NBOLOG$$.DAT file and error messages go to NBOERR$$.DAT for later reference.\n\nGENERAL 'M V n' COMMAND SYNTAX:\nNBOSearch user responses generally consist of 'commands' \n(replies to prompts)\nof the form 'M (V (n))', where\n   M (integer)   = [M]enu selection from displayed items\n   V (character) = [V]ariable data type to be selected\n                   [J](obname)\n                   [B](asis)\n                   [O](rbital number)\n                   [A](tom number, in context)\n                   [U](nit number)\n                   [d](onor NBO number)\n                   [a](cceptor NBO number, in context)\n   n (integer)   = [n]umber of the desired O/A/U/d/a selection\nResponses may also be of simple 'M', 'V', or 'Vn' form , where\n  'M' : selects a numbered menu choice (for current [V] choices)\n  'V' : requests a menu of [V] choices\n  'Vn': selects [V] number 'n' (and current [S])\nNote that [V]-input is case-insensitive, so 'A' (or 'a') is interpreted as 'atom' or 'acceptor' according to context.  Note also that 'Vn' commands can be\ngiven in separated 'V n' form. Although not explicitly included in each active [V]-select list, the 'H'(elp) key is recognized at each prompt.  For NRT search (only), variable [V] may also be 'R' (for 'resonance structure' and A' (for 'interacting atom'). Current A (atom)  and A' (interacting atom) values determine the current A-A' 'bond' selection small fractional bond order.)\n\nEXAMPLES:\n  '2 a7'  : requests menu item 2 for atom 7 (if A-select active)\n  '3 o2'  : requests menu item 3 for orbital 2 \n";
    protected int dialogMode;
    static final int DIALOG_CONFIG = 0;
    static final int DIALOG_MODEL = 10;
    static final int DIALOG_RUN = 20;
    static final int DIALOG_VIEW = 30;
    static final int DIALOG_SEARCH = 40;
    static final int DIALOG_LIST = -1;
    private static final Map<String, String> htHelp;

    protected abstract boolean connect();

    protected abstract void goRunClicked(String var1, File var2, Runnable var3);

    protected abstract void showWorkpathDialogR(String var1);

    protected abstract void showWorkpathDialogM(String var1, String var2);

    protected abstract void showWorkpathDialogV(String var1);

    protected abstract void showWorkpathDialogS(String var1);

    protected NBODialogConfig(JFrame jFrame) {
        super(jFrame, GT._("NBO Server Interface"), false);
    }

    protected void setComponents(Component component) {
        if (component.equals(this.topPanel) || component.equals(this.statusPanel)) {
            this.setComponents2(component);
            return;
        }
        if (component instanceof JTextField) {
            return;
        }
        if (component instanceof JComboBox) {
            return;
        }
        component.setForeground(Color.BLACK);
        if (component instanceof Container) {
            component.setBackground(Color.WHITE);
            for (Component component2 : ((Container)component).getComponents()) {
                this.setComponents(component2);
            }
        }
    }

    protected void setComponents2(Component component) {
        component.setForeground(Color.WHITE);
        if (component instanceof Container) {
            component.setBackground(Color.BLACK);
            for (Component component2 : ((Container)component).getComponents()) {
                this.setComponents2(component2);
            }
        }
    }

    protected void buildConfig(Container container) {
        container.removeAll();
        container.setLayout(new BorderLayout());
        this.topPanel = this.buildTopPanel();
        container.add((Component)this.topPanel, "North");
        container.add((Component)this.statusPanel, "South");
        container.add((Component)this.buildFilePanel(), "Center");
        this.centerDialog(this);
    }

    private JPanel buildFilePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        Box box = Box.createHorizontalBox();
        box.setBorder(BorderFactory.createTitledBorder(new TitledBorder("Location of NBOServe executable:")));
        this.serverPathLabel = new JTextField("");
        this.serverPathLabel.setEditable(false);
        this.serverPathLabel.setBorder(null);
        this.serverPathLabel.setText(this.nboService.serverPath);
        box.add(this.serverPathLabel);
        box.add(new JLabel("  "));
        this.nboPathButton = new JButton("Browse...");
        this.nboPathButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogConfig.this.showNBOPathDialog();
            }
        });
        box.add(this.nboPathButton);
        JButton jButton = new JButton("Connect");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogConfig.this.connect();
            }
        });
        box.add(jButton);
        jPanel.add((Component)box, "North");
        this.jpNboOutput = new JTextPane();
        this.jpNboOutput.setFont(new Font("Arial", 0, 16));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.jpNboOutput);
        jScrollPane.setBorder(BorderFactory.createTitledBorder(new TitledBorder("NBO Output:")));
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    protected NBOPanel buildTopPanel() {
        NBOPanel nBOPanel = new NBOPanel(this, -3);
        Font font = new Font("Arial", 1, 20);
        nBOPanel.add(this.modelButton).setFont(font);
        nBOPanel.add(this.runButton).setFont(font);
        nBOPanel.add(this.viewButton).setFont(font);
        nBOPanel.add(this.searchButton).setFont(font);
        nBOPanel.add(Box.createRigidArea(new Dimension(15, 0)));
        this.icon = new JLabel();
        nBOPanel.add(this.icon);
        nBOPanel.setBackground(Color.BLACK);
        return nBOPanel;
    }

    protected JPanel folderBox() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        this.tfFolder = new JTextField();
        this.tfFolder.setPreferredSize(new Dimension(130, 20));
        this.tfFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NBODialogConfig.this.showWorkpathDialogM(NBODialogConfig.this.tfFolder.getText() + "/new", null);
            }
        });
        jPanel.add((Component)this.tfFolder, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(new Dimension(100, 20));
        jPanel.add((Component)this.tfName, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("         folder"), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)new JLabel("          name"), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.tfExt = new JTextField();
        this.tfExt.setPreferredSize(new Dimension(40, 20));
        jPanel.add((Component)this.tfExt, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel("  ext"), gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)this.browse, gridBagConstraints);
        return jPanel;
    }

    protected void rawCmd(String string, final String string2, final int n) {
        this.nboService.queueJob(string, null, new Runnable(){

            @Override
            public void run() {
                NBODialogConfig.this.nboService.rawCmdNew(string2, null, false, n);
            }
        });
    }

    protected void saveHistory() {
        Properties properties = new Properties();
        properties.setProperty("nboServerPath", this.nboService.serverPath);
        JmolPanel.historyFile.addProperties(properties);
    }

    protected void saveWorkHistory() {
        Properties properties = new Properties();
        properties.setProperty("workingPath", this.workingPath);
        JmolPanel.historyFile.addProperties(properties);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    protected void showNBOPathDialog() {
        JFileChooser jFileChooser = new JFileChooser();
        String string = this.serverPathLabel.getText();
        jFileChooser.setSelectedFile(new File(string));
        int n = jFileChooser.showDialog(this, GT._("Select"));
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            String string2 = file.toString();
            if (string2.indexOf("NBO") < 0) {
                return;
            }
            this.serverPathLabel.setText(string2);
            this.nboService.serverPath = string2;
            this.saveHistory();
            this.pack();
        }
    }

    protected void centerDialog(JDialog jDialog) {
        Dimension dimension = jDialog.getToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        int n = jDialog.getParent().getY();
        int n2 = Math.min(dimension.width - dimension2.width, jDialog.getParent().getX() + jDialog.getParent().getWidth());
        jDialog.setLocation(n2, n);
    }

    protected void appendOutputWithCaret(String string) {
        if (this.jpNboOutput == null) {
            return;
        }
        if (string.length() > 1) {
            this.jpNboOutput.setText(this.jpNboOutput.getText() + string + "\n");
        }
        try {
            this.jpNboOutput.setCaretPosition(this.jpNboOutput.getText().length());
        }
        catch (Exception exception) {
            System.out.println(exception + " in appendOutputWithCaret");
        }
    }

    protected void appendOutput(String string) {
        this.jpNboOutput.setText(this.jpNboOutput.getText() + string + "\n");
    }

    protected void clearOutput() {
        this.jpNboOutput.setText("");
    }

    protected Dimension setPreferredSPanelSize(NBOPanel nBOPanel, int n) {
        switch (n) {
            case -3: {
                return new Dimension(nBOPanel.getParent().getWidth(), 85);
            }
            case 1: {
                return new Dimension((int)((double)nBOPanel.getParent().getWidth() * 0.6667), (int)((double)nBOPanel.getParent().getHeight() * 0.7));
            }
            case 6: {
                return new Dimension((int)((double)nBOPanel.getParent().getWidth() * 0.5), (int)((double)nBOPanel.getParent().getHeight() * 0.7));
            }
            case 4: {
                return new Dimension((int)((double)nBOPanel.getParent().getWidth() * 0.25), (int)((double)nBOPanel.getParent().getHeight() * 0.7));
            }
            case 0: {
                return new Dimension((int)((double)nBOPanel.getParent().getWidth() * 0.25), (int)((double)nBOPanel.getParent().getHeight() * 0.7));
            }
            case 7: {
                return new Dimension(nBOPanel.getParent().getWidth(), (int)((double)nBOPanel.getParent().getHeight() * 0.05));
            }
        }
        return new Dimension(nBOPanel.getParent().getWidth() / 3, (int)((double)nBOPanel.getParent().getHeight() * 0.7));
    }

    protected void appendToFile(String string, SB sB) {
        sB.append(string);
    }

    protected void nboReset() {
    }

    protected void setInputFile(File file, String string, final Runnable runnable) {
        this.inputFile = file;
        if (file.getName().indexOf(".") > 0) {
            this.jobStem = this.getJobStem(file);
        }
        this.tfFolder.setText(file.getParent());
        this.tfName.setText(this.jobStem);
        this.tfExt.setText(string);
        this.jmolAtomCount = this.nboService.evaluateJmol("{*}.count").asInt();
        if (this.getExt(file).equals("47")) {
            this.isJmolNBO = true;
            this.workingPath = file.toString();
            this.saveWorkHistory();
            Runnable runnable2 = new Runnable(){

                @Override
                public void run() {
                    NBODialogConfig.this.statusLab.setText("");
                    if (runnable != null) {
                        runnable.run();
                    }
                }
            };
            if (!this.newNBOFile(file, "46").exists()) {
                this.goRunClicked(DEFAULT_PARAMS, file, runnable2);
                return;
            }
            runnable2.run();
        }
    }

    protected File newNBOFile(File file, String string) {
        String string2 = file.toString();
        return new File(string2.substring(0, string2.lastIndexOf(".")) + "." + string);
    }

    protected String getJobStem(File file) {
        String string = file.getName();
        return string.substring(0, string.lastIndexOf("."));
    }

    protected String getExt(File file) {
        String string = file.toString();
        return string.substring(string.lastIndexOf(".") + 1);
    }

    protected boolean checkJmolNBO() {
        return this.vwr.ms.getInfo(this.vwr.am.cmi, "nboType") != null || this.getExt(new File(this.nboService.getJmolFilename())).equals("47");
    }

    protected void clearInputFile() {
        this.tfFolder.setText("");
        this.tfName.setText("");
        this.tfExt.setText("");
        this.inputFile = null;
        this.nboService.runScriptQueued("zap");
    }

    protected synchronized String getHelp(String string) {
        String string2 = htHelp.get(string);
        if (string2 == null) {
            try {
                String string3 = "org/openscience/jmol/app/nbo/help/" + string + ".txt";
                string2 = GuiMap.getResourceString((Object)this, (String)string3);
            }
            catch (IOException iOException) {
                string2 = "<resource not found>";
            }
            htHelp.put(string, string2);
        }
        return string2;
    }

    static {
        htHelp = new HashMap<String, String>();
    }
}

