/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class ConditionProfile
extends Profile {
    ConditionProfile() {
    }

    public abstract boolean profile(boolean var1);

    public static ConditionProfile createCountingProfile() {
        if (Profile.isProfilingEnabled()) {
            return Counting.create();
        }
        return Disabled.INSTANCE;
    }

    public static ConditionProfile createBinaryProfile() {
        if (Profile.isProfilingEnabled()) {
            return Binary.create();
        }
        return Disabled.INSTANCE;
    }

    static final class Binary
    extends ConditionProfile {
        @CompilerDirectives.CompilationFinal
        private boolean wasTrue;
        @CompilerDirectives.CompilationFinal
        private boolean wasFalse;

        Binary() {
        }

        @Override
        public boolean profile(boolean value) {
            if (value) {
                if (!this.wasTrue) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.wasTrue = true;
                }
                return true;
            }
            if (!this.wasFalse) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.wasFalse = true;
            }
            return false;
        }

        boolean wasTrue() {
            return this.wasTrue;
        }

        boolean wasFalse() {
            return this.wasFalse;
        }

        public String toString() {
            return String.format("%s(wasTrue=%s, wasFalse=%s)@%x", this.getClass().getSimpleName(), this.wasTrue, this.wasFalse, this.hashCode());
        }

        static ConditionProfile create() {
            return new Binary();
        }
    }

    static final class Counting
    extends ConditionProfile {
        @CompilerDirectives.CompilationFinal
        private int trueCount;
        @CompilerDirectives.CompilationFinal
        private int falseCount;

        Counting() {
        }

        @Override
        public boolean profile(boolean value) {
            if (CompilerDirectives.inInterpreter()) {
                if (value) {
                    int t = this.trueCount;
                    if (t < Integer.MAX_VALUE) {
                        this.trueCount = t + 1;
                    }
                } else {
                    int f = this.falseCount;
                    if (f < Integer.MAX_VALUE) {
                        this.falseCount = f + 1;
                    }
                }
                return value;
            }
            int t = this.trueCount;
            int f = this.falseCount;
            if (value) {
                if (t == 0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    t = 1;
                }
            } else if (f == 0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                f = 1;
            }
            return CompilerDirectives.injectBranchProbability((double)t / (double)(t + f), value);
        }

        int getTrueCount() {
            return this.trueCount;
        }

        int getFalseCount() {
            return this.falseCount;
        }

        public String toString() {
            int t = this.trueCount;
            int f = this.falseCount;
            return this.toString(ConditionProfile.class, this.trueCount == 0 && this.falseCount == 0, false, String.format("trueProbability=%s (trueCount=%s, falseCount=%s)", (double)t / (double)(t + f), t, f));
        }

        static ConditionProfile create() {
            return new Counting();
        }
    }

    static final class Disabled
    extends ConditionProfile {
        static final ConditionProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public boolean profile(boolean value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(ConditionProfile.class);
        }
    }
}

