/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.utilities;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;

public class AssumedValue<T> {
    private final String name;
    @CompilerDirectives.CompilationFinal
    private T value;
    @CompilerDirectives.CompilationFinal
    private Assumption assumption;

    public AssumedValue(T initialValue) {
        this(null, initialValue);
    }

    public AssumedValue(String name, T initialValue) {
        this.name = name;
        this.value = initialValue;
        this.assumption = Truffle.getRuntime().createAssumption(name);
    }

    public T get() {
        try {
            this.assumption.check();
        }
        catch (InvalidAssumptionException invalidAssumptionException) {
            // empty catch block
        }
        return this.value;
    }

    public void set(T newValue) {
        CompilerDirectives.transferToInterpreter();
        this.value = newValue;
        Assumption oldAssumption = this.assumption;
        this.assumption = Truffle.getRuntime().createAssumption(this.name);
        oldAssumption.invalidate();
    }
}

