/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.callgraph;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jruby.truffle.callgraph.Method;
import org.jruby.truffle.callgraph.MethodVersion;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class CallGraph {
    private final Map<SharedMethodInfo, Method> sharedMethodInfoToMethod = new HashMap<SharedMethodInfo, Method>();
    private final Map<RubyRootNode, MethodVersion> rootNodeToMethodVersion = new HashMap<RubyRootNode, MethodVersion>();

    public synchronized void registerRootNode(RubyRootNode rootNode) {
        this.rootNodeToMethodVersion(rootNode);
    }

    public Method sharedMethodInfoToMethod(SharedMethodInfo sharedMethodInfo) {
        Method method = this.sharedMethodInfoToMethod.get(sharedMethodInfo);
        if (method == null) {
            method = new Method(this, sharedMethodInfo);
            this.sharedMethodInfoToMethod.put(sharedMethodInfo, method);
        }
        return method;
    }

    public MethodVersion rootNodeToMethodVersion(RubyRootNode rootNode) {
        MethodVersion methodVersion = this.rootNodeToMethodVersion.get(rootNode);
        if (methodVersion == null) {
            methodVersion = new MethodVersion(this.sharedMethodInfoToMethod(rootNode.getSharedMethodInfo()), rootNode);
            this.rootNodeToMethodVersion.put(rootNode, methodVersion);
        }
        return methodVersion;
    }

    public Collection<Method> getMethods() {
        return Collections.unmodifiableCollection(this.sharedMethodInfoToMethod.values());
    }

    public void resolve() {
        for (MethodVersion methodVersion : this.rootNodeToMethodVersion.values()) {
            methodVersion.resolve();
        }
    }
}

