/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.format.parser;

import com.oracle.truffle.api.object.DynamicObject;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.Token;
import org.jruby.truffle.format.nodes.PackNode;
import org.jruby.truffle.format.nodes.SourceNode;
import org.jruby.truffle.format.nodes.control.SequenceNode;
import org.jruby.truffle.format.nodes.format.FormatFloatNodeGen;
import org.jruby.truffle.format.nodes.format.FormatIntegerNodeGen;
import org.jruby.truffle.format.nodes.read.LiteralBytesNode;
import org.jruby.truffle.format.nodes.read.LiteralIntegerNode;
import org.jruby.truffle.format.nodes.read.ReadHashValueNodeGen;
import org.jruby.truffle.format.nodes.read.ReadIntegerNodeGen;
import org.jruby.truffle.format.nodes.read.ReadStringNodeGen;
import org.jruby.truffle.format.nodes.read.ReadValueNodeGen;
import org.jruby.truffle.format.nodes.type.ToDoubleWithCoercionNodeGen;
import org.jruby.truffle.format.nodes.type.ToIntegerNodeGen;
import org.jruby.truffle.format.nodes.type.ToStringNodeGen;
import org.jruby.truffle.format.nodes.write.WriteByteNode;
import org.jruby.truffle.format.nodes.write.WriteBytesNodeGen;
import org.jruby.truffle.format.nodes.write.WritePaddedBytesNodeGen;
import org.jruby.truffle.format.parser.PrintfParser;
import org.jruby.truffle.format.parser.PrintfParserBaseListener;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

public class PrintfTreeBuilder
extends PrintfParserBaseListener {
    public static final int PADDING_FROM_ARGUMENT = -2;
    public static final int DEFAULT = -1;
    private final RubyContext context;
    private final ByteList source;
    private final List<PackNode> sequence = new ArrayList<PackNode>();

    public PrintfTreeBuilder(RubyContext context, ByteList source) {
        this.context = context;
        this.source = source;
    }

    @Override
    public void exitEscaped(PrintfParser.EscapedContext ctx) {
        this.sequence.add(new WriteByteNode(this.context, 37));
    }

    @Override
    public void exitString(PrintfParser.StringContext ctx) {
        ByteList keyBytes = this.tokenAsBytes(ctx.CURLY_KEY().getSymbol(), 1);
        DynamicObject key = this.context.getSymbol(keyBytes);
        this.sequence.add(WriteBytesNodeGen.create(this.context, ToStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), ReadHashValueNodeGen.create(this.context, key, new SourceNode()))));
    }

    @Override
    public void exitFormat(PrintfParser.FormatContext ctx) {
        PackNode node;
        PackNode valueNode;
        int width = ctx.width != null ? Integer.parseInt(ctx.width.getText()) : -1;
        boolean leftJustified = false;
        int spacePadding = -1;
        int zeroPadding = -1;
        for (int n = 0; n < ctx.flag().size(); ++n) {
            PrintfParser.FlagContext flag = ctx.flag(n);
            if (flag.MINUS() != null) {
                leftJustified = true;
                continue;
            }
            if (flag.SPACE() != null) {
                if (n + 1 < ctx.flag().size() && ctx.flag(n + 1).STAR() != null) {
                    spacePadding = -2;
                    continue;
                }
                spacePadding = width;
                continue;
            }
            if (flag.ZERO() != null) {
                if (n + 1 < ctx.flag().size() && ctx.flag(n + 1).STAR() != null) {
                    zeroPadding = -2;
                    continue;
                }
                zeroPadding = width;
                continue;
            }
            if (flag.STAR() != null) continue;
            throw new UnsupportedOperationException();
        }
        if (spacePadding == -1 && zeroPadding == -1) {
            spacePadding = width;
        }
        char type = ctx.TYPE().getSymbol().getText().charAt(0);
        if (ctx.ANGLE_KEY() == null) {
            valueNode = ReadValueNodeGen.create(this.context, new SourceNode());
        } else {
            ByteList keyBytes = this.tokenAsBytes(ctx.ANGLE_KEY().getSymbol(), 1);
            DynamicObject key = this.context.getSymbol(keyBytes);
            valueNode = ReadHashValueNodeGen.create(this.context, key, new SourceNode());
        }
        int precision = ctx.precision != null ? Integer.parseInt(ctx.precision.getText()) : -1;
        switch (type) {
            case 's': {
                if (ctx.ANGLE_KEY() == null) {
                    if (spacePadding == -1) {
                        node = WriteBytesNodeGen.create(this.context, ReadStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), new SourceNode()));
                        break;
                    }
                    node = WritePaddedBytesNodeGen.create(this.context, spacePadding, leftJustified, ReadStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), new SourceNode()));
                    break;
                }
                if (spacePadding == -1) {
                    node = WriteBytesNodeGen.create(this.context, ToStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), valueNode));
                    break;
                }
                node = WritePaddedBytesNodeGen.create(this.context, spacePadding, leftJustified, ToStringNodeGen.create(this.context, true, "to_s", false, new ByteList(), valueNode));
                break;
            }
            case 'X': 
            case 'd': 
            case 'i': 
            case 'o': 
            case 'u': 
            case 'x': {
                char format;
                PackNode spacePaddingNode = spacePadding == -2 ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : new LiteralIntegerNode(this.context, spacePadding);
                PackNode zeroPaddingNode = zeroPadding == -2 ? ReadIntegerNodeGen.create(this.context, new SourceNode()) : (ctx.precision != null ? new LiteralIntegerNode(this.context, Integer.parseInt(ctx.precision.getText())) : new LiteralIntegerNode(this.context, zeroPadding));
                switch (type) {
                    case 'd': 
                    case 'i': 
                    case 'u': {
                        format = 'd';
                        break;
                    }
                    case 'o': {
                        format = 'o';
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        format = type;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                node = WriteBytesNodeGen.create(this.context, FormatIntegerNodeGen.create(this.context, format, spacePaddingNode, zeroPaddingNode, ToIntegerNodeGen.create(this.context, valueNode)));
                break;
            }
            case 'E': 
            case 'G': 
            case 'e': 
            case 'f': 
            case 'g': {
                node = WriteBytesNodeGen.create(this.context, FormatFloatNodeGen.create(this.context, spacePadding, zeroPadding, precision, type, ToDoubleWithCoercionNodeGen.create(this.context, valueNode)));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        this.sequence.add(node);
    }

    @Override
    public void exitLiteral(PrintfParser.LiteralContext ctx) {
        ByteList text = this.tokenAsBytes(ctx.LITERAL().getSymbol());
        PackNode node = text.length() == 1 ? new WriteByteNode(this.context, (byte)text.get(0)) : WriteBytesNodeGen.create(this.context, new LiteralBytesNode(this.context, text));
        this.sequence.add(node);
    }

    public PackNode getNode() {
        return new SequenceNode(this.context, this.sequence.toArray(new PackNode[this.sequence.size()]));
    }

    private ByteList tokenAsBytes(Token token) {
        return this.tokenAsBytes(token, 0);
    }

    private ByteList tokenAsBytes(Token token, int trim) {
        return new ByteList(this.source, token.getStartIndex() + trim, token.getStopIndex() - token.getStartIndex() + 1 - 2 * trim);
    }
}

