/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Instrument;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.RubyGC;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.truffle.nodes.RubyGuards;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.NotProvided;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.BacktraceFormatter;
import org.jruby.truffle.runtime.backtrace.BacktraceInterleaver;
import org.jruby.truffle.runtime.cext.CExtManager;
import org.jruby.truffle.runtime.cext.CExtSubsystem;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.ArrayOperations;
import org.jruby.truffle.runtime.core.CoreLibrary;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.hash.BucketsStrategy;
import org.jruby.truffle.runtime.layouts.Layouts;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.SimpleShell;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;
import org.jruby.util.unsafe.UnsafeHolder;

@CoreClass(name="Truffle::Primitive")
public abstract class TrufflePrimitiveNodes {

    @CoreMethod(names={"logical_processors"}, onSingleton=true)
    public static abstract class LogicalProcessorsNode
    extends CoreMethodNode {
        public LogicalProcessorsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int logicalProcessors() {
            return Runtime.getRuntime().availableProcessors();
        }
    }

    @CoreMethod(names={"create_simple_string"}, onSingleton=true)
    public static abstract class CreateSimpleStringNode
    extends CoreMethodArrayArgumentsNode {
        public CreateSimpleStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject createSimpleString() {
            return this.createString(new ByteList(new byte[]{116, 101, 115, 116}, false));
        }
    }

    @CoreMethod(names={"run_jruby_root"}, onSingleton=true)
    public static abstract class RunJRubyRootNode
    extends CoreMethodArrayArgumentsNode {
        public RunJRubyRootNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object runJRubyRootNode() {
            return this.getContext().execute(this.getContext().getInitialJRubyRootNode());
        }
    }

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1, optional=1)
    public static abstract class LoadNode
    extends CoreMethodArrayArgumentsNode {
        public LoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public boolean load(DynamicObject file, boolean wrap) {
            if (wrap) {
                throw new UnsupportedOperationException();
            }
            try {
                this.getContext().loadFile(StringOperations.getString(this.getContext(), file), this);
            }
            catch (IOException e) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(file.toString(), this));
            }
            return true;
        }

        @Specialization(guards={"isRubyString(file)"})
        public boolean load(DynamicObject file, NotProvided wrap) {
            return this.load(file, false);
        }
    }

    @CoreMethod(names={"context"}, onSingleton=true)
    public static abstract class ContextNode
    extends CoreMethodArrayArgumentsNode {
        public ContextNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public RubyContext context() {
            return this.getContext();
        }
    }

    @CoreMethod(names={"spawn_process"}, onSingleton=true, required=3)
    public static abstract class SpawnProcessNode
    extends CoreMethodArrayArgumentsNode {
        public SpawnProcessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyString(command)", "isRubyArray(arguments)", "isRubyArray(environmentVariables)"})
        public int spawn(DynamicObject command, DynamicObject arguments, DynamicObject environmentVariables) {
            long longPid = this.call(StringOperations.getString(this.getContext(), command), this.toStringArray(arguments), this.toStringArray(environmentVariables));
            assert (longPid <= Integer.MAX_VALUE);
            int pid = (int)longPid;
            if (pid == -1) {
                throw new RaiseException(this.getContext().getCoreLibrary().errnoError(this.getContext().getPosix().errno(), this));
            }
            return pid;
        }

        private String[] toStringArray(DynamicObject rubyStrings) {
            int size = Layouts.ARRAY.getSize(rubyStrings);
            Object[] unconvertedStrings = ArrayOperations.toObjectArray(rubyStrings);
            String[] strings = new String[size];
            for (int i = 0; i < size; ++i) {
                assert (Layouts.STRING.isString(unconvertedStrings[i]));
                strings[i] = StringOperations.getString(this.getContext(), (DynamicObject)unconvertedStrings[i]);
            }
            return strings;
        }

        @CompilerDirectives.TruffleBoundary
        private long call(String command, String[] arguments, String[] environmentVariables) {
            return this.getContext().getPosix().posix_spawnp(command, Collections.emptyList(), Arrays.asList(arguments), Arrays.asList(environmentVariables));
        }
    }

    @CoreMethod(names={"object_type_of"}, onSingleton=true, required=1)
    public static abstract class ObjectTypeOfNode
    extends CoreMethodArrayArgumentsNode {
        public ObjectTypeOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject objectTypeOf(DynamicObject value) {
            return this.getSymbol(value.getShape().getObjectType().getClass().getSimpleName());
        }
    }

    @CoreMethod(names={"ast"}, onSingleton=true, required=1)
    public static abstract class ASTNode
    extends CoreMethodArrayArgumentsNode {
        public ASTNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyMethod(method)"})
        public DynamicObject astMethod(DynamicObject method) {
            return this.ast(Layouts.METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyUnboundMethod(method)"})
        public DynamicObject astUnboundMethod(DynamicObject method) {
            return this.ast(Layouts.UNBOUND_METHOD.getMethod(method));
        }

        @Specialization(guards={"isRubyProc(proc)"})
        public DynamicObject astProc(DynamicObject proc) {
            return this.ast(Layouts.PROC.getMethod(proc));
        }

        @CompilerDirectives.TruffleBoundary
        private DynamicObject ast(InternalMethod method) {
            if (method.getCallTarget() instanceof RootCallTarget) {
                return this.ast(((RootCallTarget)method.getCallTarget()).getRootNode());
            }
            return this.nil();
        }

        private DynamicObject ast(Node node) {
            if (node == null) {
                return this.nil();
            }
            ArrayList<DynamicObject> array = new ArrayList<DynamicObject>();
            array.add(this.getSymbol(node.getClass().getSimpleName()));
            for (Node child : node.getChildren()) {
                array.add(this.ast(child));
            }
            return Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), array.toArray(), array.size());
        }
    }

    @CoreMethod(names={"print_interleaved_backtrace"}, onSingleton=true)
    public static abstract class PrintInterleavedBacktraceNode
    extends CoreMethodNode {
        public PrintInterleavedBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject printInterleavedBacktrace() {
            List<String> rubyBacktrace = BacktraceFormatter.createDefaultFormatter(this.getContext()).formatBacktrace(null, RubyCallStack.getBacktrace(this));
            StackTraceElement[] javaStacktrace = new Exception().getStackTrace();
            for (String line : BacktraceInterleaver.interleave(rubyBacktrace, javaStacktrace)) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"print_backtrace"}, onSingleton=true)
    public static abstract class PrintBacktraceNode
    extends CoreMethodNode {
        public PrintBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject printBacktrace() {
            List<String> rubyBacktrace = BacktraceFormatter.createDefaultFormatter(this.getContext()).formatBacktrace(null, RubyCallStack.getBacktrace(this));
            for (String line : rubyBacktrace) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"full_memory_barrier"}, isModuleFunction=true)
    public static abstract class FullMemoryBarrierPrimitiveNode
    extends CoreMethodNode {
        public FullMemoryBarrierPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public Object fullMemoryBarrier() {
            if (!UnsafeHolder.SUPPORTS_FENCES) {
                throw new UnsupportedOperationException();
            }
            UnsafeHolder.fullFence();
            return this.nil();
        }
    }

    @CoreMethod(names={"synchronized"}, isModuleFunction=true, required=1, needsBlock=true)
    public static abstract class SynchronizedPrimitiveNode
    extends YieldingCoreMethodNode {
        public SynchronizedPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object synchronize(VirtualFrame frame, DynamicObject self, DynamicObject block) {
            DynamicObject dynamicObject = self;
            synchronized (dynamicObject) {
                return this.yield(frame, block, new Object[0]);
            }
        }
    }

    @CoreMethod(names={"fixnum_lower"}, isModuleFunction=true, required=1)
    public static abstract class FixnumLowerPrimitiveNode
    extends UnaryCoreMethodNode {
        public FixnumLowerPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public int lower(int value) {
            return value;
        }

        @Specialization(guards={"canLower(value)"})
        public int lower(long value) {
            return (int)value;
        }

        @Specialization(guards={"!canLower(value)"})
        public long lowerFails(long value) {
            return value;
        }

        protected static boolean canLower(long value) {
            return CoreLibrary.fitsIntoInteger(value);
        }
    }

    @CoreMethod(names={"install_rubinius_primitive"}, isModuleFunction=true, required=1)
    public static abstract class InstallRubiniusPrimitiveNode
    extends CoreMethodArrayArgumentsNode {
        public InstallRubiniusPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization(guards={"isRubyMethod(rubyMethod)"})
        public Object installRubiniusPrimitive(DynamicObject rubyMethod) {
            String name = Layouts.METHOD.getMethod(rubyMethod).getName();
            this.getContext().getRubiniusPrimitiveManager().installPrimitive(name, rubyMethod);
            return this.nil();
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true, required=1)
    public static abstract class AtExitSystemNode
    extends CoreMethodArrayArgumentsNode {
        public AtExitSystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object atExit(boolean always, DynamicObject block) {
            this.getContext().getAtExitManager().add(block, always);
            return this.nil();
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        public HostOSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject hostOS() {
            return this.createString(StringOperations.encodeByteList(RbConfigLibrary.getOSName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"jruby_home_directory"}, onSingleton=true)
    public static abstract class JRubyHomeDirectoryNode
    extends CoreMethodNode {
        public JRubyHomeDirectoryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject jrubyHomeDirectory() {
            return this.createString(StringOperations.encodeByteList(this.getContext().getRuntime().getJRubyHome(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"debug_print"}, onSingleton=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodArrayArgumentsNode {
        public DebugPrintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject debugPrint(DynamicObject string) {
            System.err.println(string.toString());
            return this.nil();
        }
    }

    @CoreMethod(names={"cext_supported?"}, needsSelf=false, onSingleton=true)
    public static abstract class CExtSupportedNode
    extends CoreMethodArrayArgumentsNode {
        public CExtSupportedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean cExtSupported() {
            return CExtManager.getSubsystem() != null;
        }
    }

    @CoreMethod(names={"cext_load"}, onSingleton=true, needsSelf=false, required=3)
    public static abstract class CExtLoadNode
    extends CoreMethodArrayArgumentsNode {
        public CExtLoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(initFunctions)", "isRubyArray(cFlags)", "isRubyArray(files)"})
        public boolean cExtLoad(DynamicObject initFunctions, DynamicObject cFlags, DynamicObject files) {
            CExtSubsystem subsystem = CExtManager.getSubsystem();
            if (subsystem == null) {
                throw new UnsupportedOperationException();
            }
            subsystem.load(this.toStrings(initFunctions), this.toStrings(cFlags), this.toStrings(files));
            return true;
        }

        private String[] toStrings(DynamicObject array) {
            assert (RubyGuards.isRubyArray(array));
            String[] strings = new String[Layouts.ARRAY.getSize(array)];
            int n = 0;
            for (Object object : ArrayOperations.toIterable(array)) {
                if (RubyGuards.isRubyString(object) || RubyGuards.isRubySymbol(object)) {
                    strings[n] = object.toString();
                    ++n;
                    continue;
                }
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertInto(object, "String", this));
            }
            return strings;
        }
    }

    @CoreMethod(names={"detach"}, onSingleton=true, required=1)
    public static abstract class DetachNode
    extends CoreMethodArrayArgumentsNode {
        public DetachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHandle(handle)"})
        public DynamicObject detach(DynamicObject handle) {
            Instrument instrument = (Instrument)Layouts.HANDLE.getObject(handle);
            instrument.dispose();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"attach"}, onSingleton=true, required=2, needsBlock=true)
    public static abstract class AttachNode
    extends CoreMethodArrayArgumentsNode {
        public AttachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public DynamicObject attach(DynamicObject file, int line, DynamicObject block) {
            return this.getContext().createHandle(this.getContext().getAttachmentsManager().attach(file.toString(), line, block));
        }
    }

    @CoreMethod(names={"coverage_start"}, onSingleton=true)
    public static abstract class CoverageStartNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageStartNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject coverageStart() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            this.getContext().getEnv().instrumenter().install(this.getContext().getCoverageTracker());
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"coverage_result"}, onSingleton=true)
    public static abstract class CoverageResultNode
    extends CoreMethodArrayArgumentsNode {
        public CoverageResultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject coverageResult() {
            if (this.getContext().getCoverageTracker() == null) {
                throw new UnsupportedOperationException("coverage is disabled");
            }
            HashMap<DynamicObject, DynamicObject> converted = new HashMap<DynamicObject, DynamicObject>();
            for (Map.Entry<Source, Long[]> source : this.getContext().getCoverageTracker().getCounts().entrySet()) {
                Object[] store = this.lineCountsStore(source.getValue());
                DynamicObject array = Layouts.ARRAY.createArray(this.getContext().getCoreLibrary().getArrayFactory(), store, store.length);
                if (source.getKey().getPath() == null) continue;
                converted.put(this.createString(StringOperations.encodeByteList(source.getKey().getPath(), (Encoding)UTF8Encoding.INSTANCE)), array);
            }
            return BucketsStrategy.create(this.getContext(), converted.entrySet(), false);
        }

        private Object[] lineCountsStore(Long[] array) {
            Object[] store = new Object[array.length];
            for (int n = 0; n < array.length; ++n) {
                store[n] = array[n] == null ? this.getContext().getCoreLibrary().getNilObject() : array[n];
            }
            return store;
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true)
    public static abstract class SimpleShellNode
    extends CoreMethodArrayArgumentsNode {
        public SimpleShellNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject simpleShell() {
            new SimpleShell(this.getContext()).run(RubyCallStack.getCallerFrame(this.getContext()).getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"graal_version"}, onSingleton=true)
    public static abstract class GraalVersionNode
    extends CoreMethodArrayArgumentsNode {
        public GraalVersionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject graalVersion() {
            return this.createString(StringOperations.encodeByteList(System.getProperty("graal.version", "unknown"), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"substrate?"}, onSingleton=true)
    public static abstract class SubstrateNode
    extends CoreMethodArrayArgumentsNode {
        public SubstrateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public boolean substrate() {
            return TruffleOptions.AOT;
        }
    }

    @CoreMethod(names={"graal?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodArrayArgumentsNode {
        public GraalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean graal() {
            return this.getContext().onGraal();
        }
    }

    @CoreMethod(names={"dump_string"}, onSingleton=true, required=1)
    public static abstract class DumpStringNode
    extends CoreMethodArrayArgumentsNode {
        public DumpStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject dumpString(DynamicObject string) {
            StringBuilder builder = new StringBuilder();
            ByteList byteList = StringOperations.getByteList(string);
            for (int i = 0; i < byteList.length(); ++i) {
                builder.append(String.format("\\x%02x", byteList.get(i)));
            }
            return this.createString(StringOperations.encodeByteList(builder.toString(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodArrayArgumentsNode {
        public JavaClassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject javaClassOf(Object value) {
            return this.createString(StringOperations.encodeByteList(value.getClass().getSimpleName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"assert_not_compiled"}, onSingleton=true)
    public static abstract class AssertNotCompiledNode
    extends CoreMethodArrayArgumentsNode {
        public AssertNotCompiledNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject assertNotCompiled() {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_not_compiled can only be called lexically", this));
        }
    }

    @CoreMethod(names={"assert_constant"}, onSingleton=true, required=1)
    public static abstract class AssertConstantNode
    extends CoreMethodArrayArgumentsNode {
        public AssertConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Specialization
        public DynamicObject assertConstant(Object value) {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_constant can only be called lexically", this));
        }
    }

    @CoreMethod(names={"gc_time"}, onSingleton=true)
    public static abstract class GCTimeNode
    extends CoreMethodArrayArgumentsNode {
        public GCTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public long gcTime() {
            return RubyGC.getCollectionTime();
        }
    }

    @CoreMethod(names={"gc_count"}, onSingleton=true)
    public static abstract class GCCountNode
    extends CoreMethodArrayArgumentsNode {
        public GCCountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int gcCount() {
            return RubyGC.getCollectionCount();
        }
    }

    @CoreMethod(names={"source_of_caller"}, isModuleFunction=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public SourceOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject sourceOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            String source = Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<String>(){

                @Override
                public String visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            if (source == null) {
                return this.nil();
            }
            return this.createString(StringOperations.encodeByteList(source, (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"binding_of_caller"}, isModuleFunction=true)
    public static abstract class BindingOfCallerNode
    extends CoreMethodArrayArgumentsNode {
        public BindingOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject bindingOfCaller() {
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame frame = Truffle.getRuntime().iterateFrames(new FrameInstanceVisitor<MaterializedFrame>(){

                @Override
                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            if (frame == null) {
                return this.nil();
            }
            return BindingNodes.createBinding(this.getContext(), frame);
        }
    }
}

