/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.literal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jcodings.Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNode;
import org.jruby.truffle.nodes.objects.AllocateObjectNodeGen;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.util.ByteList;

public class StringLiteralNode
extends RubyNode {
    @CompilerDirectives.CompilationFinal
    private byte[] bytes;
    private final Encoding encoding;
    private final int codeRange;
    @Node.Child
    private AllocateObjectNode allocateObjectNode;

    public StringLiteralNode(RubyContext context, SourceSection sourceSection, ByteList byteList, int codeRange) {
        super(context, sourceSection);
        assert (byteList != null);
        this.bytes = byteList.bytes();
        this.encoding = byteList.getEncoding();
        this.codeRange = codeRange;
        this.allocateObjectNode = AllocateObjectNodeGen.create(context, sourceSection, false, null, null);
    }

    @Override
    public DynamicObject execute(VirtualFrame frame) {
        byte[] copy = Arrays.copyOf(this.bytes, this.bytes.length);
        ByteList byteList = new ByteList(copy, this.encoding, false);
        return this.allocateObjectNode.allocate(this.getContext().getCoreLibrary().getStringClass(), byteList, this.codeRange, null);
    }
}

