/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.supercall;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNode;
import org.jruby.truffle.nodes.supercall.LookupSuperMethodNodeGen;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.StringOperations;
import org.jruby.truffle.runtime.methods.InternalMethod;

public class ZSuperOutsideMethodNode
extends RubyNode {
    final boolean insideDefineMethod;
    @Node.Child
    LookupSuperMethodNode lookupSuperMethodNode;

    public ZSuperOutsideMethodNode(RubyContext context, SourceSection sourceSection, boolean insideDefineMethod) {
        super(context, sourceSection);
        this.insideDefineMethod = insideDefineMethod;
        this.lookupSuperMethodNode = LookupSuperMethodNodeGen.create(context, sourceSection, null);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        CompilerDirectives.transferToInterpreter();
        if (this.insideDefineMethod) {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("implicit argument passing of super from method defined by define_method() is not supported. Specify all arguments explicitly.", this));
        }
        throw new RaiseException(this.getContext().getCoreLibrary().noSuperMethodOutsideMethodError(this));
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        Object self = RubyArguments.getSelf(frame.getArguments());
        InternalMethod superMethod = this.lookupSuperMethodNode.executeLookupSuperMethod(frame, self);
        if (superMethod == null) {
            return this.nil();
        }
        return this.create7BitString(StringOperations.encodeByteList("super", (Encoding)UTF8Encoding.INSTANCE));
    }
}

