/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.Ruby;
import org.jruby.util.ByteList;
import org.jruby.util.Pack;
import org.jruby.util.RegexpOptions;
import org.jruby.util.Sprintf;
import org.jruby.util.StringSupport;

public class RegexpSupport {
    public static ByteList preprocess(Ruby runtime, ByteList str, Encoding enc, Encoding[] fixedEnc, ErrorMode mode2) {
        ByteList to = new ByteList(str.getRealSize());
        if (enc.isAsciiCompatible()) {
            fixedEnc[0] = null;
        } else {
            fixedEnc[0] = enc;
            to.setEncoding(enc);
        }
        boolean hasProperty = RegexpSupport.unescapeNonAscii(runtime, to, str.getUnsafeBytes(), str.getBegin(), str.getBegin() + str.getRealSize(), enc, fixedEnc, str, mode2);
        if (hasProperty && fixedEnc[0] == null) {
            fixedEnc[0] = enc;
        }
        if (fixedEnc[0] != null) {
            to.setEncoding(fixedEnc[0]);
        }
        return to;
    }

    public static boolean unescapeNonAscii(Ruby runtime, ByteList to, byte[] bytes2, int p2, int end2, Encoding enc, Encoding[] encp, ByteList str, ErrorMode mode2) {
        boolean hasProperty = false;
        byte[] buf = null;
        block9: while (p2 < end2) {
            int cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
            if (cl <= 0) {
                RegexpSupport.raisePreprocessError(runtime, str, "invalid multibyte character", mode2);
            }
            if (cl > 1 || (bytes2[p2] & 0x80) != 0) {
                if (to != null) {
                    to.append(bytes2, p2, cl);
                }
                p2 += cl;
                if (encp[0] == null) {
                    encp[0] = enc;
                    continue;
                }
                if (encp[0] == enc) continue;
                RegexpSupport.raisePreprocessError(runtime, str, "non ASCII character in UTF-8 regexp", mode2);
                continue;
            }
            int c = bytes2[p2++] & 0xFF;
            switch (c) {
                case 92: {
                    if (p2 == end2) {
                        RegexpSupport.raisePreprocessError(runtime, str, "too short escape sequence", mode2);
                    }
                    c = bytes2[p2++] & 0xFF;
                    switch (c) {
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: {
                            if (StringSupport.scanOct(bytes2, p2 - 1, end2 - (p2 - 1)) <= 127) {
                                if (to == null) continue block9;
                                to.append(92).append(c);
                                continue block9;
                            }
                        }
                        case 48: 
                        case 67: 
                        case 77: 
                        case 99: 
                        case 120: {
                            p2 -= 2;
                            if (enc == USASCIIEncoding.INSTANCE) {
                                if (buf == null) {
                                    buf = new byte[1];
                                }
                                p2 = RegexpSupport.readEscapedByte(runtime, buf, 0, bytes2, p2, end2, str, mode2);
                                c = buf[0];
                                if (c == 65535) {
                                    return false;
                                }
                                if (to == null) continue block9;
                                to.append(c);
                                continue block9;
                            }
                            p2 = RegexpSupport.unescapeEscapedNonAscii(runtime, to, bytes2, p2, end2, enc, encp, str, mode2);
                            continue block9;
                        }
                        case 117: {
                            if (p2 == end2) {
                                RegexpSupport.raisePreprocessError(runtime, str, "too short escape sequence", mode2);
                            }
                            if (bytes2[p2] == 123) {
                                ++p2;
                                if ((p2 = RegexpSupport.unescapeUnicodeList(runtime, to, bytes2, p2, end2, encp, str, mode2)) != end2 && bytes2[p2++] == 125) continue block9;
                                RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode list", mode2);
                                continue block9;
                            }
                            p2 = RegexpSupport.unescapeUnicodeBmp(runtime, to, bytes2, p2, end2, encp, str, mode2);
                            continue block9;
                        }
                        case 112: {
                            if (encp[0] == null) {
                                hasProperty = true;
                            }
                            if (to == null) continue block9;
                            to.append(92).append(c);
                            continue block9;
                        }
                    }
                    if (to == null) continue block9;
                    to.append(92).append(c);
                    continue block9;
                }
            }
            if (to == null) continue;
            to.append(c);
        }
        return hasProperty;
    }

    public static int raisePreprocessError(Ruby runtime, ByteList str, String err, ErrorMode mode2) {
        switch (mode2) {
            case RAISE: {
                RegexpSupport.raiseRegexpError19(runtime, str, str.getEncoding(), RegexpOptions.NULL_OPTIONS, err);
            }
            case PREPROCESS: {
                throw runtime.newArgumentError("regexp preprocess failed: " + err);
            }
        }
        return 0;
    }

    public static void raiseRegexpError19(Ruby runtime, ByteList bytes2, Encoding enc, RegexpOptions options2, String err) {
        throw runtime.newRegexpError(err + ": " + RegexpSupport.regexpDescription19(runtime, bytes2, options2, enc));
    }

    public static ByteList regexpDescription19(Ruby runtime, ByteList bytes2, RegexpOptions options2, Encoding enc) {
        return RegexpSupport.regexpDescription19(runtime, bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize(), options2, enc);
    }

    private static ByteList regexpDescription19(Ruby runtime, byte[] s2, int start2, int len, RegexpOptions options2, Encoding enc) {
        ByteList description = new ByteList();
        description.setEncoding(enc);
        description.append((byte)47);
        Encoding resultEnc = runtime.getDefaultInternalEncoding();
        if (resultEnc == null) {
            resultEnc = runtime.getDefaultExternalEncoding();
        }
        RegexpSupport.appendRegexpString19(runtime, description, s2, start2, len, enc, resultEnc);
        description.append((byte)47);
        RegexpSupport.appendOptions(description, options2);
        if (options2.isEncodingNone()) {
            description.append((byte)110);
        }
        return description;
    }

    public static void appendRegexpString19(Ruby runtime, ByteList to, byte[] bytes2, int start2, int len, Encoding enc, Encoding resEnc) {
        int p2 = start2;
        int end2 = p2 + len;
        boolean needEscape = false;
        while (p2 < end2) {
            int c;
            int cl;
            if (enc.isAsciiCompatible()) {
                cl = 1;
                c = bytes2[p2] & 0xFF;
            } else {
                cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                c = enc.mbcToCode(bytes2, p2, end2);
            }
            if (!Encoding.isAscii(c)) {
                p2 += StringSupport.length(enc, bytes2, p2, end2);
                continue;
            }
            if (c != 47 && enc.isPrint(c)) {
                p2 += cl;
                continue;
            }
            needEscape = true;
            break;
        }
        if (!needEscape) {
            to.append(bytes2, start2, len);
        } else {
            boolean isUnicode = StringSupport.isUnicode(enc);
            p2 = start2;
            while (p2 < end2) {
                int c;
                int cl;
                if (enc.isAsciiCompatible()) {
                    cl = 1;
                    c = bytes2[p2] & 0xFF;
                } else {
                    cl = StringSupport.preciseLength(enc, bytes2, p2, end2);
                    c = enc.mbcToCode(bytes2, p2, end2);
                }
                if (c == 92 && p2 + cl < end2) {
                    int n = cl + StringSupport.length(enc, bytes2, p2 + cl, end2);
                    to.append(bytes2, p2, n);
                    p2 += n;
                    continue;
                }
                if (c == 47) {
                    to.append((byte)92);
                    to.append(bytes2, p2, cl);
                } else {
                    if (!Encoding.isAscii(c)) {
                        int l = StringSupport.preciseLength(enc, bytes2, p2, end2);
                        if (l <= 0) {
                            l = 1;
                            Sprintf.sprintf(runtime, to, (CharSequence)"\\x%02X", c);
                        } else if (resEnc != null) {
                            int code = enc.mbcToCode(bytes2, p2, end2);
                            Sprintf.sprintf(runtime, to, (CharSequence)StringSupport.escapedCharFormat(code, isUnicode), code);
                        } else {
                            to.append(bytes2, p2, l);
                        }
                        p2 += l;
                        continue;
                    }
                    if (enc.isPrint(c)) {
                        to.append(bytes2, p2, cl);
                    } else if (!enc.isSpace(c)) {
                        Sprintf.sprintf(runtime, to, (CharSequence)"\\x%02X", c);
                    } else {
                        to.append(bytes2, p2, cl);
                    }
                }
                p2 += cl;
            }
        }
    }

    public static void appendOptions(ByteList to, RegexpOptions options2) {
        if (options2.isMultiline()) {
            to.append((byte)109);
        }
        if (options2.isIgnorecase()) {
            to.append((byte)105);
        }
        if (options2.isExtended()) {
            to.append((byte)120);
        }
    }

    public static int readEscapedByte(Ruby runtime, byte[] to, int toP, byte[] bytes2, int p2, int end2, ByteList str, ErrorMode mode2) {
        if (p2 == end2 || bytes2[p2++] != 92) {
            RegexpSupport.raisePreprocessError(runtime, str, "too short escaped multibyte character", mode2);
        }
        boolean metaPrefix = false;
        boolean ctrlPrefix = false;
        int code = 0;
        block15: while (true) {
            if (p2 == end2) {
                RegexpSupport.raisePreprocessError(runtime, str, "too short escape sequence", mode2);
            }
            switch (bytes2[p2++]) {
                case 92: {
                    code = 92;
                    break block15;
                }
                case 110: {
                    code = 10;
                    break block15;
                }
                case 116: {
                    code = 9;
                    break block15;
                }
                case 114: {
                    code = 13;
                    break block15;
                }
                case 102: {
                    code = 12;
                    break block15;
                }
                case 118: {
                    code = 11;
                    break block15;
                }
                case 97: {
                    code = 7;
                    break block15;
                }
                case 101: {
                    code = 27;
                    break block15;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    int olen = end2 < --p2 + 3 ? end2 - p2 : 3;
                    code = StringSupport.scanOct(bytes2, p2, olen);
                    p2 += StringSupport.octLength(bytes2, p2, olen);
                    break block15;
                }
                case 120: {
                    int hlen = end2 < p2 + 2 ? end2 - p2 : 2;
                    code = StringSupport.scanHex(bytes2, p2, hlen);
                    int len = StringSupport.hexLength(bytes2, p2, hlen);
                    if (len < 1) {
                        RegexpSupport.raisePreprocessError(runtime, str, "invalid hex escape", mode2);
                    }
                    p2 += len;
                    break block15;
                }
                case 77: {
                    if (metaPrefix) {
                        RegexpSupport.raisePreprocessError(runtime, str, "duplicate meta escape", mode2);
                    }
                    metaPrefix = true;
                    if (p2 + 1 < end2 && bytes2[p2++] == 45 && (bytes2[p2] & 0x80) == 0) {
                        if (bytes2[p2] == 92) {
                            ++p2;
                            continue block15;
                        }
                        code = bytes2[p2++] & 0xFF;
                        break block15;
                    }
                    RegexpSupport.raisePreprocessError(runtime, str, "too short meta escape", mode2);
                }
                case 67: {
                    if (p2 == end2 || bytes2[p2++] != 45) {
                        RegexpSupport.raisePreprocessError(runtime, str, "too short control escape", mode2);
                    }
                }
                case 99: {
                    if (ctrlPrefix) {
                        RegexpSupport.raisePreprocessError(runtime, str, "duplicate control escape", mode2);
                    }
                    ctrlPrefix = true;
                    if (p2 < end2 && (bytes2[p2] & 0x80) == 0) {
                        if (bytes2[p2] == 92) {
                            ++p2;
                            continue block15;
                        }
                        code = bytes2[p2++] & 0xFF;
                        break block15;
                    }
                    RegexpSupport.raisePreprocessError(runtime, str, "too short control escape", mode2);
                }
                default: {
                    RegexpSupport.raisePreprocessError(runtime, str, "unexpected escape sequence", mode2);
                }
            }
            break;
        }
        if (code < 0 || code > 255) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid escape code", mode2);
        }
        if (ctrlPrefix) {
            code &= 0x1F;
        }
        if (metaPrefix) {
            code |= 0x80;
        }
        to[toP] = (byte)code;
        return p2;
    }

    private static int unescapeEscapedNonAscii(Ruby runtime, ByteList to, byte[] bytes2, int p2, int end2, Encoding enc, Encoding[] encp, ByteList str, ErrorMode mode2) {
        byte[] chBuf = new byte[enc.maxLength()];
        int chLen = 0;
        p2 = RegexpSupport.readEscapedByte(runtime, chBuf, chLen++, bytes2, p2, end2, str, mode2);
        while (chLen < enc.maxLength() && StringSupport.MBCLEN_NEEDMORE_P(StringSupport.preciseLength(enc, chBuf, 0, chLen))) {
            p2 = RegexpSupport.readEscapedByte(runtime, chBuf, chLen++, bytes2, p2, end2, str, mode2);
        }
        int cl = StringSupport.preciseLength(enc, chBuf, 0, chLen);
        if (cl == -1) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid multibyte escape", mode2);
        }
        if (chLen > 1 || (chBuf[0] & 0x80) != 0) {
            if (to != null) {
                to.append(chBuf, 0, chLen);
            }
            if (encp[0] == null) {
                encp[0] = enc;
            } else if (encp[0] != enc) {
                RegexpSupport.raisePreprocessError(runtime, str, "escaped non ASCII character in UTF-8 regexp", mode2);
            }
        } else if (to != null) {
            Sprintf.sprintf(runtime, to, (CharSequence)"\\x%02X", chBuf[0] & 0xFF);
        }
        return p2;
    }

    private static int unescapeUnicodeList(Ruby runtime, ByteList to, byte[] bytes2, int p2, int end2, Encoding[] encp, ByteList str, ErrorMode mode2) {
        while (p2 < end2 && ASCIIEncoding.INSTANCE.isSpace(bytes2[p2] & 0xFF)) {
            ++p2;
        }
        boolean hasUnicode = false;
        block1: while (true) {
            int code = StringSupport.scanHex(bytes2, p2, end2 - p2);
            int len = StringSupport.hexLength(bytes2, p2, end2 - p2);
            if (len == 0) break;
            if (len > 6) {
                RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode range", mode2);
            }
            p2 += len;
            if (to != null) {
                RegexpSupport.appendUtf8(runtime, to, code, encp, str, mode2);
            }
            hasUnicode = true;
            while (true) {
                if (p2 >= end2 || !ASCIIEncoding.INSTANCE.isSpace(bytes2[p2] & 0xFF)) continue block1;
                ++p2;
            }
            break;
        }
        if (!hasUnicode) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode list", mode2);
        }
        return p2;
    }

    private static int unescapeUnicodeBmp(Ruby runtime, ByteList to, byte[] bytes2, int p2, int end2, Encoding[] encp, ByteList str, ErrorMode mode2) {
        if (p2 + 4 > end2) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode escape", mode2);
        }
        int code = StringSupport.scanHex(bytes2, p2, 4);
        int len = StringSupport.hexLength(bytes2, p2, 4);
        if (len != 4) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode escape", mode2);
        }
        RegexpSupport.appendUtf8(runtime, to, code, encp, str, mode2);
        return p2 + 4;
    }

    private static void appendUtf8(Ruby runtime, ByteList to, int code, Encoding[] enc, ByteList str, ErrorMode mode2) {
        RegexpSupport.checkUnicodeRange(runtime, code, str, mode2);
        if (code < 128) {
            if (to != null) {
                Sprintf.sprintf(runtime, to, (CharSequence)"\\x%02X", code);
            }
        } else {
            if (to != null) {
                to.ensure(to.getRealSize() + 6);
                to.setRealSize(to.getRealSize() + Pack.utf8Decode(runtime, to.getUnsafeBytes(), to.getBegin() + to.getRealSize(), code));
            }
            if (enc[0] == null) {
                enc[0] = UTF8Encoding.INSTANCE;
            } else if (!enc[0].isUTF8()) {
                RegexpSupport.raisePreprocessError(runtime, str, "UTF-8 character in non UTF-8 regexp", mode2);
            }
        }
    }

    private static void checkUnicodeRange(Ruby runtime, int code, ByteList str, ErrorMode mode2) {
        if (55296 <= code && code <= 57343 || 0x10FFFF < code) {
            RegexpSupport.raisePreprocessError(runtime, str, "invalid Unicode range", mode2);
        }
    }

    public static enum ErrorMode {
        RAISE,
        PREPROCESS,
        DESC;

    }
}

